var a = false;
$(document).ready(function () {
    // Button click
    $("#btn_save").click(function () {
        
        if (a == false) {
            validateAndSubmit();
        }
    });

    // Real-time input/textarea validation
    $(document).on('input change', 'input, textarea', function () {
        updateBorderColor($(this));
    });

    // Real-time select2 validation
    bindSelect2LiveValidation('#mainFaculty');
    bindSelect2LiveValidation('#altFaculty');
    bindSelect2LiveValidation('#LeaveType');
});

function updateBorderColor(element) {
    var val = element.val().trim();
    if (val === '') {
        element.css('border', '2px solid red');
    } else {
        element.css('border', '2px solid green');
    }
}

function bindSelect2LiveValidation(selectId) {
    let $select = $(selectId);
    let $container = $select.siblings('.select2-container').find('.select2-selection');

    $select.on('change', function () {
        if ($select.val() === '') {
            $container.css('border', '2px solid red');
        } else {
            $container.css('border', '2px solid green');
        }
    });
}

function validateAndSubmit() {
    var valid = true;

    // Fields to validate
    var fields = [
        '#mainFaculty',
        '#altFaculty',
        '#LeaveType',
        '#Leave_from',
        '#Leave_to',
        '#No_of_days',
        '#Leave_Reas'
    ];

    fields.forEach(function (selector) {
        var $el = $(selector);

        if ($el.is('select')) {
            var $container = $el.siblings('.select2-container').find('.select2-selection');
            if ($el.val() === '') {
                $container.css('border', '2px solid red');
                valid = false;
            } else {
                $container.css('border', '2px solid green');
            }
        } else {
            if ($el.val().trim() === '') {
                $el.css('border', '2px solid red');
                valid = false;
            } else {
                $el.css('border', '2px solid green');
            }
        }
    });

    if (!valid) {
        Swal.fire('', 'Please Enter Required Fields!', 'error');
        return;
    }

    // Proceed to submit
    saveperform();
}

function saveperform() {
    var LeaveApp_id = $('#LeaveApp_id').val();
    var form = $("#Form")[0];
    var formData = new FormData(form);

    if (LeaveApp_id > 0) {
        // Update
        a = true;
        $.ajax({
            url: base_path + "Faculty/Leave/updateLeave",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                $('#btn_save').prop('disabled', true).html('Loading...');
            },
            success: function (data) {
                let res = JSON.parse(data);
                $('#btn_save').prop('disabled', false).html('Save');
                a = false;

                if (!res.status) {
                    Swal.fire('', res.message, 'error');
                    return;
                }

                Swal.fire({
  position: 'center',
  icon: 'success',
  title: '<strong>Success!</strong>',
  html: 'Data Updated Successfully',
  showConfirmButton: false,
  timer: 2000,
  customClass: {
    popup: 'custom-swal-popup',
    icon: 'custom-swal-icon',
    title: 'custom-swal-title',
    htmlContainer: 'custom-swal-text'
  }
}).then(() => {
                    location.reload();
                });
            }
        });
    } else {
        // Insert
        a = true;
        $.ajax({
            url: base_path + "Faculty/Leave/insertLeave",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                $('#btn_save').prop('disabled', true).html('Loading...');
            },
            success: function (data) {
                let res = JSON.parse(data);
                $('#btn_save').prop('disabled', false).html('Save');
                a = false;

                if (!res.status) {
                    Swal.fire('', res.message, 'error');
                    return;
                }

                $("#Form")[0].reset();
                $('.select2').val(null).trigger('change'); 
                Swal.fire({
  position: 'center',
  icon: 'success',
  title: '<strong>Success!</strong>',
  html: 'Data Submitted Successfully',
  showConfirmButton: false,
  timer: 2000,
  customClass: {
    popup: 'custom-swal-popup',
    icon: 'custom-swal-icon',
    title: 'custom-swal-title',
    htmlContainer: 'custom-swal-text'
  }
}).then(() => {
                    location.reload();
                });
            }
        });
    }
}
