var isSubmitting = false;

$(document).ready(function () {
    $('#btn_save').click(function () {
        if (!isSubmitting) {
            validateAndSubmitLeave();
        }
    });

    $(document).on('input change', 'input, textarea', function () {
        updateFieldBorder($(this));
    });

    bindSelect2LiveValidation('#mainFaculty');
    bindSelect2LiveValidation('#altFaculty');
    bindSelect2LiveValidation('#LeaveType');
});

function updateFieldBorder(element) {
    var val = element.val().trim();
    element.css('border', val === '' ? '2px solid red' : '2px solid green');
}

function bindSelect2LiveValidation(selector) {
    let $select = $(selector);
    let $container = $select.siblings('.select2-container').find('.select2-selection');
    $select.on('change', function () {
        $container.css('border', $select.val() === '' ? '2px solid red' : '2px solid green');
    });
}

function validateAndSubmitLeave() {
    const $btn = $('#btn_save');
    const regStatus = $btn.data('reg');
    const princStatus = $btn.data('princ');

    if (regStatus === 'approved') {
        Swal.fire({
            icon: 'warning',
            title: 'Update Blocked',
            html: '<b>This Leave is already approved by the Registrar.</b><br>No further changes are allowed.',
            confirmButtonColor: '#d33',
            confirmButtonText: 'OK'
        });
        return;
    }

    if (princStatus === 'approved') {
        Swal.fire({
            icon: 'warning',
            title: 'Update Blocked',
            html: '<b>This Leave is already approved by the Principal.</b><br>No further changes are allowed.',
            confirmButtonColor: '#d33',
            confirmButtonText: 'OK'
        });
        return;
    }

    let valid = true;
    let fields = ['#mainFaculty', '#altFaculty', '#LeaveType', '#Leave_from', '#Leave_to', '#No_of_days', '#Leave_Reas'];

    fields.forEach(function (selector) {
        let $el = $(selector);
        if ($el.is('select')) {
            let $container = $el.siblings('.select2-container').find('.select2-selection');
            if ($el.val() === '') {
                $container.css('border', '2px solid red');
                valid = false;
            } else {
                $container.css('border', '2px solid green');
            }
        } else {
            if ($el.val().trim() === '') {
                $el.css('border', '2px solid red');
                valid = false;
            } else {
                $el.css('border', '2px solid green');
            }
        }
    });

    if (!valid) {
        Swal.fire('', 'Please Enter Required Fields!', 'error');
        return;
    }

    submitLeaveForm();
}

function submitLeaveForm() {
    let form = $('#Form')[0];
    let formData = new FormData(form);
    let LeaveApp_id = $('#LeaveApp_id').val();

    isSubmitting = true;

    let url = LeaveApp_id > 0
        ? base_path + "Heads/Leave/updateLeave"
        : base_path + "Heads/Leave/insertLeave";

    $.ajax({
        url: url,
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function () {
            $('#btn_save').prop('disabled', true).html('Loading...');
        },
        success: function (data) {
            let res;
            try {
                res = typeof data === 'string' ? JSON.parse(data) : data;
            } catch (e) {
                Swal.fire('Error', 'Invalid response from server.', 'error');
                console.error('Parse error', data);
                isSubmitting = false;
                $('#btn_save').prop('disabled', false).html('Save');
                return;
            }

            isSubmitting = false;
            $('#btn_save').prop('disabled', false).html('Save');

            if (!res.status) {
                Swal.fire('', res.message, 'error');
                return;
            }

            if (LeaveApp_id === '' || LeaveApp_id == 0) {
                $('#Form')[0].reset();
                $('.select2').val(null).trigger('change');
            }

            Swal.fire({
                position: 'center',
                icon: 'success',
                title: '<strong>Success!</strong>',
                html: 'Data Updated Successfully',
                showConfirmButton: false,
                timer: 4000,
                customClass: {
                    popup: 'custom-swal-popup',
                    icon: 'custom-swal-icon',
                    title: 'custom-swal-title',
                    htmlContainer: 'custom-swal-text'
                }
            }).then(() => {
                const role = res.form_role;
                const regStatus = $('#btn_save').data('reg');
                let redirectUrl = '';

                if (role === 'HOD' && regStatus !== 'approved') {
                    redirectUrl = base_path + "Heads/Leave/verify";
                } else if (role === 'REG') {
                    redirectUrl = base_path + "Heads/Leave/RegVerify";
                } else if (role === 'Princ') {
                    redirectUrl = base_path + "Heads/Leave/PrincipleVerify";
                }

                // if (redirectUrl !== '') {
                //     window.location.href = redirectUrl;
                // } else {
                //     Swal.fire('Error', 'Redirection failed. Unknown role.', 'error');
                // }
                
                if (redirectUrl !== '') {
    // Force reload the redirected page to avoid caching
    window.location.replace(redirectUrl + '?refresh=' + new Date().getTime());
} else {
    Swal.fire('Error', 'Redirection failed. Unknown role.', 'error');
}

            });
        },
        error: function () {
            isSubmitting = false;
            $('#btn_save').prop('disabled', false).html('Save');
            Swal.fire('Error', 'Something went wrong. Please try again.', 'error');
        }
    });
}
