var a = false;

 $(document).ready(function() {

    // ===== Save button click handler =====
    $('#submit').click(function() {
        if (a === true) return;

        var isValid = true;

        // Check required fields
        $('#Form').find('input[required], textarea[required], select[required]').each(function() {
            if (!$(this).val() || !$(this).val().trim()) {
                $(this).addClass('custom-invalid');
                isValid = false;
            } else {
                $(this).removeClass('custom-invalid');
            }
        });

        if (isValid) {
            checkOrderNumberAndSave();
        }
    });

    // ===== Remove red border on valid input =====
    $('#Form').on('input change', 'input, textarea, select', function() {
        if ($(this).val() && $(this).val().trim() !== '') {
            $(this).removeClass('custom-invalid');
        }
    });

});

// ===== CHECK ORDER NUMBER DUPLICATE =====
function checkOrderNumberAndSave() {
    var answertypeid   = $('#answertypeid').val();
    var orderno        = $('#orderno').val();

    // Validate
    if (!orderno) {
        Swal.fire({
            icon: 'warning',
            title: 'Missing Information',
            text: 'Order Number is required'
        });
        return;
    }

    a = true;

    // Check for duplicate order number
    $.ajax({
        url: base_path + "admin/AnswerType/checkDuplicateOrderNumber",
        type: "POST",
        data: {
            orderno: orderno,
            answertypeid: answertypeid
        },
        dataType: 'json',
        beforeSend: function() {
            $('#submit').prop('disabled', true);
            $('#submit').html('<i class="fa-solid fa-spinner fa-spin"></i> Checking...');
        },
        success: function(response) {
            $('#submit').prop('disabled', false);
            $('#submit').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');

            if (response.status) {
                // If there's an active duplicate, show error
                if (response.hasActiveDuplicate) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Duplicate Order Number',
                        text: 'This order number already exists and is active'
                    });
                    a = false;
                } else {
                    // No active duplicate, proceed with save
                    saveperform();
                }
            } else {
                // Error checking duplicate, proceed with save (or show error)
                saveperform();
            }
        },
        error: function(xhr, status, error) {
            $('#submit').prop('disabled', false);
            $('#submit').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
            
            // If error checking duplicate, proceed with save
            saveperform();
        }
    });
}

// ===== MAIN SAVE / UPDATE FUNCTION =====
function saveperform() {
    var answertypeid   = $('#answertypeid').val();
    var answertypename = $('#answertypename').val();
    var orderno        = $('#orderno').val();

    // Validate
    if (!answertypename || !orderno) {
        Swal.fire({
            icon: 'warning',
            title: 'Missing Information',
            text: 'Please fill all required fields'
        });
        a = false;
        return;
    }

    // Build FormData
    var formData = new FormData();

    // answertypeid: only append if editing (update mode)
    if (answertypeid && answertypeid.trim() !== '' && answertypeid.trim() !== '0' && parseInt(answertypeid) > 0) {
        formData.append('answertypeid', answertypeid.trim());
    }

    formData.append('answertypename', answertypename);
    formData.append('orderno',        orderno);
    formData.append('is_active',      $('#is_active').is(':checked') ? 1 : 0);

    // ===== Decide INSERT or UPDATE URL =====
    var ajaxUrl        = base_path + "admin/AnswerType/insertAnswerType";
    var successMessage = 'Answer Type Added Successfully';
    
    if (answertypeid && answertypeid.trim() !== '' && answertypeid.trim() !== '0' && parseInt(answertypeid) > 0) {
        ajaxUrl        = base_path + "admin/AnswerType/updateAnswerType";
        successMessage = 'Answer Type Updated Successfully';
    }

    // ===== AJAX CALL =====
    $.ajax({
        url:         ajaxUrl,
        type:        "POST",
        data:        formData,
        processData: false,
        contentType: false,
        dataType:    'json',
        beforeSend: function() {
            $('#submit').prop('disabled', true);
            $('#submit').html('<i class="fa-solid fa-spinner fa-spin"></i> Saving...');
        },
        success: function(response) {
            $('#submit').prop('disabled', false);
            $('#submit').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');

            if (response.status) {
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: '<strong>Success!</strong>',
                    html: successMessage,
                    showConfirmButton: false,
                    timer: 2000,
                    customClass: {
                        popup:        'custom-swal-popup',
                        icon:         'custom-swal-icon',
                        title:        'custom-swal-title',
                        htmlContainer: 'custom-swal-text'
                    }
                }).then(() => {
                    window.location.href = base_path + 'admin/AnswerType/index';
                });
            } else {
                Swal.fire({
                    icon:  'error',
                    title: 'Error',
                    text:  response.message || 'Failed to save data'
                });
            }
            
            a = false;
        },
        error: function(xhr, status, error) {
            $('#submit').prop('disabled', false);
            $('#submit').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
            
            Swal.fire({
                icon:  'error',
                title: 'Error',
                text:  'An error occurred while saving: ' + error
            });
            
            a = false;
        }
    });
}