var a = false;

$(document).ready(function() {

    // ===== Save button click handler =====
    $('#submit').click(function() {
        if (a === true) return;

        var isValid = true;

        // Check required fields (select[required] etc.)
        $('#Form').find('input[required], textarea[required], select[required]').each(function() {
            if (!$(this).val() || !$(this).val().trim()) {
                $(this).addClass('custom-invalid');
                isValid = false;
            } else {
                $(this).removeClass('custom-invalid');
            }
        });

        // Validate that URL has been generated
        var generatedURL = $('#generated_url').val().trim();
        if (!generatedURL) {
            Swal.fire({
                icon: 'warning',
                title: 'Missing URL',
                text: 'Please generate the URL first before saving!'
            });
            isValid = false;
        }

        if (isValid) {
            saveperform();
        }
    });

    // ===== Remove red border on valid input =====
    $('#Form').on('input change', 'input, textarea, select', function() {
        if ($(this).val() && $(this).val().trim() !== '') {
            $(this).removeClass('custom-invalid');
        }
    });

});

// ===== MAIN SAVE / UPDATE FUNCTION =====
function saveperform() {
    var instituteId   = $('#fkInsitute_id_hidden').val();
    var feedbackForId = $('#fkfeedbackforid').val();
    var branchId      = $('#fkbranchid').val();
    var academicYear  = $('#academicyear').val();
    var url           = $('#generated_url').val();
    var urlId         = $('#url_id').val();

    // Debug logs
    console.log('URL ID being sent:', urlId);
    console.log('Institute ID:', instituteId);
    console.log('Feedback For ID:', feedbackForId);
    console.log('Branch ID:', branchId);
    console.log('Academic Year:', academicYear);

    // Validate all fields
    if (!instituteId || !feedbackForId || !academicYear || !url) {
        Swal.fire({
            icon: 'warning',
            title: 'Missing Information',
            text: 'Please fill all required fields and generate URL'
        });
        return;
    }

    a = true;

    // Build FormData
    var formData = new FormData();

    // url_id: only append if editing (update mode)
    if (urlId && urlId.trim() !== '' && urlId.trim() !== '0' && parseInt(urlId) > 0) {
        formData.append('url_id', urlId.trim());
        console.log('Update mode - url_id:', urlId.trim());
    } else {
        console.log('Insert mode - no url_id');
    }

    formData.append('fkInsitute_id',    instituteId);
    formData.append('fkfeedbackforid',  feedbackForId);
    formData.append('fkbranchid',       branchId);
    formData.append('academicyear',     academicYear);
    formData.append('generated_url',    url);
    formData.append('is_active',        $('#is_active').is(':checked') ? 1 : 0);

    // ===== Decide INSERT or UPDATE URL =====
    var ajaxUrl        = base_path + "admin/CollegeFeedback/insertFeedbackURL";
    var successMessage = 'Data Submitted Successfully';
    
    if (urlId && urlId.trim() !== '' && urlId.trim() !== '0' && parseInt(urlId) > 0) {
        ajaxUrl        = base_path + "admin/CollegeFeedback/updateFeedbackURL";
        successMessage = 'Data Updated Successfully';
        console.log('Using UPDATE URL:', ajaxUrl);
    } else {
        console.log('Using INSERT URL:', ajaxUrl);
    }

    // ===== AJAX CALL =====
    $.ajax({
        url:         ajaxUrl,
        type:        "POST",
        data:        formData,
        processData: false,
        contentType: false,
        dataType:    'json',
        beforeSend: function() {
            $('#submit').prop('disabled', true);
            $('#submit').html('<i class="fa-solid fa-spinner fa-spin"></i> Saving...');
        },
        success: function(response) {
            $('#submit').prop('disabled', false);
            $('#submit').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');

            console.log('Server response:', response);

            if (response.status) {
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: '<strong>Success!</strong>',
                    html: successMessage,
                    showConfirmButton: false,
                    timer: 2000,
                    customClass: {
                        popup:        'custom-swal-popup',
                        icon:         'custom-swal-icon',
                        title:        'custom-swal-title',
                        htmlContainer: 'custom-swal-text'
                    }
                }).then(() => {
                    window.location.href = base_path + 'admin/CollegeFeedback/index';
                });
            } else {
                Swal.fire({
                    icon:  'error',
                    title: 'Error',
                    text:  response.message || 'Failed to save data'
                });
            }
            
            a = false;
        },
        error: function(xhr, status, error) {
            $('#submit').prop('disabled', false);
            $('#submit').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
            
            console.error('AJAX Error:', xhr.responseText);
            
            Swal.fire({
                icon:  'error',
                title: 'Error',
                text:  'An error occurred while saving: ' + error
            });
            
            a = false;
        }
    });
}