var a = false;

$(document).ready(function() {

    // ===== Initialize Select2 for Answer Types Multiselect =====
    $('#answertypes').select2({
        placeholder: 'Select Answer Types',
        allowClear: true,
        width: '100%',
        closeOnSelect: false
    });

    // ===== Handle field-wrapper floating label =====
    $('#answertypes').on('select2:select select2:unselect', function() {
        if ($(this).val() && $(this).val().length > 0) {
            $(this).closest('.field-wrapper').addClass('field-active');
            $(this).removeClass('custom-invalid');
        } else {
            $(this).closest('.field-wrapper').removeClass('field-active');
        }
    });

    // Initialize field-active class on page load if values exist
    if ($('#answertypes').val() && $('#answertypes').val().length > 0) {
        $('#answertypes').closest('.field-wrapper').addClass('field-active');
    }

    // ===== Save button click handler =====
    $('#submit').click(function() {
        if (a === true) return;

        var isValid = true;

        // Check required fields
        $('#Form').find('input[required], textarea[required]').each(function() {
            if (!$(this).val() || !$(this).val().trim()) {
                $(this).addClass('custom-invalid');
                isValid = false;
            } else {
                $(this).removeClass('custom-invalid');
            }
        });

        // Check if at least one answer type is selected
        var selectedAnswerTypes = $('#answertypes').val();
        if (!selectedAnswerTypes || selectedAnswerTypes.length === 0) {
            $('#answertypes').next('.select2-container').addClass('custom-invalid-select2');
            Swal.fire({
                icon: 'warning',
                title: 'Missing Selection',
                text: 'Please select at least one Answer Type'
            });
            isValid = false;
        } else {
            $('#answertypes').next('.select2-container').removeClass('custom-invalid-select2');
        }

        if (isValid) {
            saveperform();
        }
    });

    // ===== Remove red border on valid input =====
    $('#Form').on('input change', 'input, textarea', function() {
        if ($(this).val() && $(this).val().trim() !== '') {
            $(this).removeClass('custom-invalid');
        }
    });

});

// ===== MAIN SAVE / UPDATE FUNCTION =====
function saveperform() {
    var feedbackid       = $('#feedbackid').val();
    var feedbackforname  = $('#feedbackforname').val();
    var answertypes      = $('#answertypes').val(); // Array of selected answer type IDs
    var questionperpage  = $('#questionperpage').val();

    // Validate
    if (!feedbackforname) {
        Swal.fire({
            icon: 'warning',
            title: 'Missing Information',
            text: 'Please fill Feedback For Name'
        });
        return;
    }

    if (!answertypes || answertypes.length === 0) {
        Swal.fire({
            icon: 'warning',
            title: 'Missing Information',
            text: 'Please select at least one Answer Type'
        });
        return;
    }

    a = true;

    // Build FormData
    var formData = new FormData();

    // feedbackid: only append if editing (update mode)
    if (feedbackid && feedbackid.trim() !== '' && feedbackid.trim() !== '0' && parseInt(feedbackid) > 0) {
        formData.append('feedbackid', feedbackid.trim());
    }

    formData.append('feedbackforname', feedbackforname);
    formData.append('questionperpage', questionperpage);
    
    // Append each selected answer type
    for (var i = 0; i < answertypes.length; i++) {
        formData.append('answertypes[]', answertypes[i]);
    }

    // ===== Decide INSERT or UPDATE URL =====
    var ajaxUrl        = base_path + "admin/FeedbackFor/insertFeedbackFor";
    var successMessage = 'Feedback For Added Successfully';
    
    if (feedbackid && feedbackid.trim() !== '' && feedbackid.trim() !== '0' && parseInt(feedbackid) > 0) {
        ajaxUrl        = base_path + "admin/FeedbackFor/updateFeedbackFor";
        successMessage = 'Feedback For Updated Successfully';
    }

    // ===== AJAX CALL =====
    $.ajax({
        url:         ajaxUrl,
        type:        "POST",
        data:        formData,
        processData: false,
        contentType: false,
        dataType:    'json',
        beforeSend: function() {
            $('#submit').prop('disabled', true);
            $('#submit').html('<i class="fa-solid fa-spinner fa-spin"></i> Saving...');
        },
        success: function(response) {
            $('#submit').prop('disabled', false);
            $('#submit').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');

            if (response.status) {
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: '<strong>Success!</strong>',
                    html: successMessage,
                    showConfirmButton: false,
                    timer: 2000,
                    customClass: {
                        popup:        'custom-swal-popup',
                        icon:         'custom-swal-icon',
                        title:        'custom-swal-title',
                        htmlContainer: 'custom-swal-text'
                    }
                }).then(() => {
                    window.location.href = base_path + 'admin/FeedbackFor/index';
                });
            } else {
                Swal.fire({
                    icon:  'error',
                    title: 'Error',
                    text:  response.message || 'Failed to save data'
                });
            }
            
            a = false;
        },
        error: function(xhr, status, error) {
            $('#submit').prop('disabled', false);
            $('#submit').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
            
            Swal.fire({
                icon:  'error',
                title: 'Error',
                text:  'An error occurred while saving: ' + error
            });
            
            a = false;
        }
    });
}