var a = false;

$(document).ready(function () {
    $('#submit').click(function () {
        if (a === true) return;

        var isValid = true;

        // Basic required field validation
        $('#Form').find('input[required], textarea[required], select[required]').each(function () {
            if (!$(this).val().trim()) {
                $(this).addClass('custom-invalid');
                isValid = false;
            } else {
                $(this).removeClass('custom-invalid');
            }
        });

        if (isValid) {
            saveperform();
        }
    });

    $('#Form').on('input change', 'input, textarea, select', function () {
        if ($(this).val().trim() !== '') {
            $(this).removeClass('custom-invalid');
        }
    });
});
function saveperform() {
    a = true;
    var form = $("#Form")[0];
    var formData = new FormData(form);

    $.ajax({
        url: base_path + "admin/Import/import_excel",
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function () {
            $('#submit').prop('disabled', true).html('Loading');
            $('#loader').fadeIn(); // Show loader
        },
        success: function (data) {
            $('#submit').prop('disabled', false).html('Save');
            $('#loader').fadeOut(); // Hide loader

            let message = (data === 'success') 
                ? 'Imported Successfully!' 
                : (data === 'no_data' ? 'No data in Excel!' : 'No file selected.');

            Swal.fire({
                position: 'center',
                icon: data === 'success' ? 'success' : 'warning',
                title: '<strong>' + (data === 'success' ? 'Success!' : 'Notice') + '</strong>',
                html: message,
                showConfirmButton: false,
                timer: 2000,
                customClass: {
                    popup: 'custom-swal-popup',
                    icon: 'custom-swal-icon',
                    title: 'custom-swal-title',
                    htmlContainer: 'custom-swal-text'
                }
            }).then(() => {
                if (data === 'success') location.reload();
            });

            a = false;
        },
        error: function () {
            $('#loader').fadeOut(); // Hide loader
            Swal.fire('Error', 'Failed to process the request.', 'error');
            $('#submit').prop('disabled', false).html('Save');
            a = false;
        }
    });
}



