var a = false;

$(document).ready(function () {
    $('#submit').click(function () {
        if (a === true) return;

        var isValid = true;

        // Reset all previous error borders
        $('.custom-invalid').removeClass('custom-invalid');

        // Validate all required fields in form
        $('#Form').find('input[required], textarea[required], select[required]').each(function () {
            if (!$(this).val().trim()) {
                $(this).addClass('custom-invalid');
                isValid = false;
            }
        });

        // Validate dropdowns outside form
        const extraRequiredFields = ['#fkinter_id', '#fkduration_id', '#StartDate', '#EndDate'];
        extraRequiredFields.forEach(function (id) {
            if (!$(id).val().trim()) {
                $(id).addClass('custom-invalid');
                isValid = false;
            }
        });

        // Check internship list table
        if ($('#tabledata tr').length === 0) {
            Swal.fire("Please add at least one internship to the list.");
            isValid = false;
        }

        if (isValid) {
            saveperform();
        } else {
            Swal.fire("Please fill all required fields.");
        }
    });

    // Remove red border on change/input
    $(document).on('input change', 'input, textarea, select', function () {
        if ($(this).val().trim()) {
            $(this).removeClass('custom-invalid');
        }
    });
});

function saveperform() {
    const form = $("#Form")[0];
    const formData = new FormData(form);
    const intern_id = $('#intern_id').val();
    const google_photos = $('#google_photos').val();

let internshipList = [];
    let fileIndex = 0;

    $('#tabledata tr').each(function () {
        const rowDataStr = $(this).attr('data-row');
        if (rowDataStr) {
            const rowData = JSON.parse(rowDataStr);
            
            // Add files to FormData with unique names
            if (rowData.joiningFile) {
                formData.append(`joining_letter_${fileIndex}`, rowData.joiningFile);
            }
            if (rowData.completionFile) {
                formData.append(`completion_letter_${fileIndex}`, rowData.completionFile);
            }
            if (rowData.presentationFile) {
                formData.append(`presentation_letter_${fileIndex}`, rowData.presentationFile);
            }

            internshipList.push({
                fkstudent_id: rowData.student,
                student_name: rowData.studentname,
                stipend: rowData.stipend,
                stipend_amount: rowData.stipendamount,
                file_index: fileIndex // Reference to files
            });

            fileIndex++;
        }
    });





    if (internshipList.length === 0) {
        Swal.fire("Please add at least one internship to the list.");
        return;
    }

    formData.append('internshipList', JSON.stringify(internshipList));

    const url = intern_id === ''
        ? base_path + "admin/Internship/insertInternship"
        : base_path + "admin/Internship/updateInternship";

    $.ajax({
    url: url,
    type: "POST",
    data: formData,
    processData: false,
    contentType: false,
    dataType: "json", // ✅ force JSON parsing
    beforeSend: function () {
        $('#submit').prop('disabled', true).text('Saving...');
    },
    success: function (res) {
        $('#submit').prop('disabled', false).text('Save');

        if (res.status === 'success') {
            Swal.fire({
                icon: 'success',
                title: 'Success!',
                text: res.message || 'Data saved successfully.',
                timer: 2000,
                showConfirmButton: false
            }).then(() => { window.location.href = base_path + 'admin/Internship/index';
 });
        } else {
            Swal.fire('Error', res.message || 'Failed to save data.', 'error');
        }
    },
    error: function (xhr) {
        $('#submit').prop('disabled', false).text('Save');
        console.error('Server error response:', xhr.responseText);
        Swal.fire('Server error. Please try again.');
    }
});

}
