var a = false;

$(document).ready(function () {
    // Auto-fill supplier details when supplier is selected
    $('#fkSupplier_id').change(function() {
        var supplierId = $(this).val();
        
        if (supplierId) {
            $.ajax({
                url: base_path + "admin/Inventory/getSupplierDetails",
                type: "POST",
                data: { supplier_id: supplierId },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        // Fill the supplier details
                        $('#Con_person_name').val(response.data.Con_person_name || '');
                        $('#Phone').val(response.data.Con_person_no || '');
                        $('#GST_no').val(response.data.GST_no || '');
                    } else {
                        console.log('Supplier details not found');
                        // Clear fields if supplier not found
                        $('#Con_person_name').val('');
                        $('#Phone').val('');
                        $('#GST_no').val('');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching supplier details:', error);
                }
            });
        } else {
            // Clear fields if no supplier selected
            $('#Con_person_name').val('');
            $('#Phone').val('');
            $('#GST_no').val('');
        }
    });

    // Calculate total on quantity or rate change
    $(document).on('input', 'input[name="Quantity[]"], input[name="Rate[]"]', function() {
        var row = $(this).closest('tr');
        var quantity = parseFloat(row.find('input[name="Quantity[]"]').val()) || 0;
        var rate = parseFloat(row.find('input[name="Rate[]"]').val()) || 0;
        var total = quantity * rate;
        row.find('input[name="Total[]"]').val(total.toFixed(2));
    });

    $('#submit').click(function () {
        if (a === true) return;

        var isValid = true;

        // Check Date field
        if (!$('#Date').val().trim()) {
            $('#Date').addClass('custom-invalid');
            isValid = false;
        } else {
            $('#Date').removeClass('custom-invalid');
        }

        // Check Supplier field
        if (!$('#fkSupplier_id').val()) {
            $('#fkSupplier_id').next('.select2-container').find('.select2-selection').addClass('custom-invalid');
            isValid = false;
        } else {
            $('#fkSupplier_id').next('.select2-container').find('.select2-selection').removeClass('custom-invalid');
        }

        // Check if at least one row has data
        var hasTableData = false;
        $('#tableBody tr').each(function() {
            var categoryId = $(this).find('select[name="fkCategory_ID[]"]').val();
            var itemId = $(this).find('select[name="fkItem_id[]"]').val();
            
            if (categoryId || itemId) {
                hasTableData = true;
                return false; // break the loop
            }
        });

        if (!hasTableData) {
            Swal.fire({
                position: 'center',
                icon: 'error',
                title: '<strong>Error!</strong>',
                html: 'Please add at least one item in the table',
                showConfirmButton: true,
                customClass: {
                    popup: 'custom-swal-popup',
                    icon: 'custom-swal-icon',
                    title: 'custom-swal-title',
                    htmlContainer: 'custom-swal-text'
                }
            });
            return;
        }

        if (isValid) {
            saveperform();
        } else {
            Swal.fire({
                position: 'center',
                icon: 'error',
                title: '<strong>Error!</strong>',
                html: 'Please fill in all required fields',
                showConfirmButton: true,
                customClass: {
                    popup: 'custom-swal-popup',
                    icon: 'custom-swal-icon',
                    title: 'custom-swal-title',
                    htmlContainer: 'custom-swal-text'
                }
            });
        }
    });

    // Remove red border on valid input
    $('#Form').on('input change', 'input, textarea, select', function () {
        if ($(this).val() && $(this).val().trim() !== '') {
            $(this).removeClass('custom-invalid');
            $(this).next('.select2-container').find('.select2-selection').removeClass('custom-invalid');
        }
    });
});

function saveperform() {
    var Id = $('#Inventory_main_id').val();
    
    if (Id && Id > 0) {
        // UPDATE CASE
        a = true;
        var form = $("#Form")[0];
        var formData = new FormData(form);

        $.ajax({
            url: base_path + "admin/Inventory/updateInventory",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                $('#submit').prop('disabled', true);
                $('#submit').html('<i class="fa fa-spinner fa-spin"></i> Loading...');
            },
            success: function (data) {
                console.log(data);
                $('#submit').prop('disabled', false);
                $('#submit').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
                
                try {
                    var response = JSON.parse(data);
                    if (response.success) {
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            title: '<strong>Success!</strong>',
                            html: response.message,
                            showConfirmButton: false,
                            timer: 2000,
                            customClass: {
                                popup: 'custom-swal-popup',
                                icon: 'custom-swal-icon',
                                title: 'custom-swal-title',
                                htmlContainer: 'custom-swal-text'
                            }
                        }).then(() => { 
                            window.location.href = base_path + 'admin/Inventory/index';
                        });
                    } else {
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: '<strong>Error!</strong>',
                            html: response.message,
                            showConfirmButton: true
                        });
                    }
                } catch (e) {
                    console.error('Error parsing response:', e);
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: '<strong>Success!</strong>',
                        html: 'Inventory Updated Successfully',
                        showConfirmButton: false,
                        timer: 2000
                    }).then(() => { 
                        window.location.href = base_path + 'admin/Inventory/index';
                    });
                }

                a = false;
            },
            error: function(xhr, status, error) {
                console.error(error);
                $('#submit').prop('disabled', false);
                $('#submit').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
                
                var errorMessage = 'Failed to update inventory. Please try again.';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMessage = xhr.responseJSON.message;
                }
                
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: '<strong>Error!</strong>',
                    html: errorMessage,
                    showConfirmButton: true
                });
                
                a = false;
            }
        });
    } else {
        // INSERT CASE
        a = true;
        var form = $("#Form")[0];
        var formData = new FormData(form);

        $.ajax({
            url: base_path + "admin/Inventory/insertInventory",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                $('#submit').prop('disabled', true);
                $('#submit').html('<i class="fa fa-spinner fa-spin"></i> Loading...');
            },
            success: function (data) {
                console.log(data);
                $('#submit').prop('disabled', false);
                $('#submit').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
                
                try {
                    var response = JSON.parse(data);
                    if (response.success) {
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            title: '<strong>Success!</strong>',
                            html: response.message,
                            showConfirmButton: false,
                            timer: 2000,
                            customClass: {
                                popup: 'custom-swal-popup',
                                icon: 'custom-swal-icon',
                                title: 'custom-swal-title',
                                htmlContainer: 'custom-swal-text'
                            }
                        }).then(() => {
                            window.location.href = base_path + 'admin/Inventory/index';
                        });
                    } else {
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: '<strong>Error!</strong>',
                            html: response.message,
                            showConfirmButton: true
                        });
                    }
                } catch (e) {
                    console.error('Error parsing response:', e);
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: '<strong>Success!</strong>',
                        html: 'Inventory Added Successfully',
                        showConfirmButton: false,
                        timer: 2000
                    }).then(() => {
                        window.location.href = base_path + 'admin/Inventory/index';
                    });
                }

                a = false;
            },
            error: function(xhr, status, error) {
                console.error(error);
                $('#submit').prop('disabled', false);
                $('#submit').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
                
                var errorMessage = 'Failed to add inventory. Please try again.';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMessage = xhr.responseJSON.message;
                }
                
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: '<strong>Error!</strong>',
                    html: errorMessage,
                    showConfirmButton: true
                });
                
                a = false;
            }
        });
    }
}