$(document).ready(function() {
    // Handle form submission for both insert and update
    $('#submit').on('click', function(e) {
        e.preventDefault();
        
        // Check if this is update or insert
        var mou_id = $('#mou_id').val();
        var url = mou_id ? base_url + 'admin/Mou/updateMou' : base_url + 'admin/Mou/insertMou';
        
        // Validate required fields
        if (!validateForm()) {
            return false;
        }

        // Create FormData object to handle file uploads
        var formData = new FormData($('#Form')[0]);

        // Show loading indicator
        Swal.fire({
            title: 'Processing...',
            text: 'Please wait',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        // AJAX request
        $.ajax({
            url: url,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function(response) {
                Swal.close();
                
                if (response.status === 'success') {
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: '<strong>Success!</strong>',
                        html: response.message || (mou_id ? 'MOU Updated Successfully' : 'MOU Submitted Successfully'),
                        showConfirmButton: false,
                        timer: 2000,
                        customClass: {
                            popup: 'custom-swal-popup',
                            icon: 'custom-swal-icon',
                            title: 'custom-swal-title',
                            htmlContainer: 'custom-swal-text'
                        }
                    }).then(() => {
                        window.location.href = base_url + 'admin/Mou/index';
                    });
                } else {
                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: '<strong>Error!</strong>',
                        html: response.message || 'Something went wrong!',
                        showConfirmButton: false,
                        timer: 2000,
                        customClass: {
                            popup: 'custom-swal-popup',
                            icon: 'custom-swal-icon',
                            title: 'custom-swal-title',
                            htmlContainer: 'custom-swal-text'
                        }
                    });
                }
            },
            error: function(xhr, status, error) {
                Swal.close();
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: '<strong>Error!</strong>',
                    html: 'Failed to process request: ' + error,
                    showConfirmButton: false,
                    timer: 2000,
                    customClass: {
                        popup: 'custom-swal-popup',
                        icon: 'custom-swal-icon',
                        title: 'custom-swal-title',
                        htmlContainer: 'custom-swal-text'
                    }
                });
                console.error('AJAX Error:', error);
                console.error('Response:', xhr.responseText);
            }
        });
    });

    // Form validation
    function validateForm() {
        var isValid = true;
        var errorMessage = '';

        // Check Industry Name
        if ($('#Indu_Name').val().trim() === '') {
            errorMessage += 'Industry/Organization Name is required.<br>';
            isValid = false;
        }

        // Check Sign Date
        if ($('#SignDate').val() === '') {
            errorMessage += 'MOU Sign Date is required.<br>';
            isValid = false;
        }

        // Check Start Date
        if ($('#StartDate').val() === '') {
            errorMessage += 'MOU Start Date is required.<br>';
            isValid = false;
        }

        // Check End Date
        if ($('#EndDate').val() === '') {
            errorMessage += 'MOU End Date is required.<br>';
            isValid = false;
        }

        // Validate date logic
        if ($('#StartDate').val() && $('#EndDate').val()) {
            var startDate = new Date($('#StartDate').val());
            var endDate = new Date($('#EndDate').val());
            
            if (endDate <= startDate) {
                errorMessage += 'End Date must be after Start Date.<br>';
                isValid = false;
            }
        }

        // Check Duration
        if ($('#fkDuration_id').val() === '' || $('#fkDuration_id').val() === null) {
            errorMessage += 'Duration is required.<br>';
            isValid = false;
        }

        // Check Year
        if ($('#fkYear_id').val() === '' || $('#fkYear_id').val() === null) {
            errorMessage += 'Year is required.<br>';
            isValid = false;
        }

        // Check Branch
        if ($('#Branch_id').val() === '' || $('#Branch_id').val() === null) {
            errorMessage += 'Branch/Department is required.<br>';
            isValid = false;
        }

        // Check Suggestion/Highlight Detail
        if ($('#Suggestion').val().trim() === '') {
            errorMessage += 'MOU Highlight Detail is required.<br>';
            isValid = false;
        }

        // Show validation errors
        if (!isValid) {
            Swal.fire({
                position: 'center',
                icon: 'warning',
                title: '<strong>Validation Error</strong>',
                html: errorMessage,
                showConfirmButton: false,
                timer: 3000,
                customClass: {
                    popup: 'custom-swal-popup',
                    icon: 'custom-swal-icon',
                    title: 'custom-swal-title',
                    htmlContainer: 'custom-swal-text'
                }
            });
        }

        return isValid;
    }

    // Initialize select2 if available
    if ($.fn.select2) {
        $('.select-single').select2({
            width: '100%'
        });
    }
});

// Preview image function for single file upload
function previewImage(input) {
    const preview = document.getElementById('image_preview_container');
    const file = input.files[0];
 
    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);
 
        if (fileType.startsWith('image/')) {
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">
                                 </a>`;
        } else {
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="${base_url}Assets/img/Document_file.png" style="height: 100px;">
                                 </a>`;
        }
    } else {
        preview.innerHTML = `<img src="${base_url}Assets/img/Nodocument_file.png" style="height: 100px;">`;
    }
}

// Gallery preview variables - check if already declared in view
if (typeof selectedFiles === 'undefined') {
    var selectedFiles = [];
}
if (typeof removedExistingPhotos === 'undefined') {
    var removedExistingPhotos = [];
}
 
// Preview gallery function
function previewGallary(input) {
    const previewContainer = document.getElementById('imagePreview');
    const newPhotosContainer = document.getElementById('new-photos-container');
   
    previewContainer.innerHTML = '';
    selectedFiles = [];
 
    if (input.files.length > 0) {
        newPhotosContainer.style.display = 'block';
        selectedFiles = Array.from(input.files);
       
        selectedFiles.forEach((file, index) => {
            const fileUrl = URL.createObjectURL(file);
 
            const wrapper = document.createElement('div');
            wrapper.style.position = 'relative';
            wrapper.style.marginRight = '10px';
            wrapper.style.marginBottom = '10px';
            wrapper.setAttribute('data-index', index);
 
            const img = document.createElement('img');
            img.style.height = '100px';
            img.style.width = '100px';
            img.style.objectFit = 'cover';
            img.style.border = '1px solid #ccc';
            img.style.padding = '2px';
 
            if (file.type.startsWith('image/')) {
                img.src = fileUrl;
            } else {
                img.src = base_url + "Assets/img/Document_file.png";
            }
 
            const removeBtn = document.createElement('button');
            removeBtn.type = 'button';
            removeBtn.innerHTML = '&times;';
            removeBtn.style.position = 'absolute';
            removeBtn.style.top = '5px';
            removeBtn.style.right = '5px';
            removeBtn.style.background = 'rgba(255,0,0,0.8)';
            removeBtn.style.color = 'white';
            removeBtn.style.border = 'none';
            removeBtn.style.borderRadius = '50%';
            removeBtn.style.width = '20px';
            removeBtn.style.height = '20px';
            removeBtn.style.fontSize = '12px';
            removeBtn.style.cursor = 'pointer';
            removeBtn.onclick = function() { removeSelectedPhoto(index); };
 
            wrapper.appendChild(img);
            wrapper.appendChild(removeBtn);
            previewContainer.appendChild(wrapper);
        });
    } else {
        newPhotosContainer.style.display = 'none';
    }
}
 
// Remove selected photo from new uploads
function removeSelectedPhoto(index) {
    selectedFiles.splice(index, 1);
   
    const dt = new DataTransfer();
    selectedFiles.forEach(file => dt.items.add(file));
   
    document.getElementById('AwardGallery').files = dt.files;
    previewGallary(document.getElementById('AwardGallery'));
}
 
// Remove existing photo
function removeExistingPhoto(button, photoPath) {
    if (!removedExistingPhotos.includes(photoPath)) {
        removedExistingPhotos.push(photoPath);
    }
   
    document.getElementById('removed_photos').value = removedExistingPhotos.join(',');
    button.closest('.existing-photo-item').remove();
   
    console.log('Removed existing photo:', photoPath);
}