var a = false;

$(document).ready(function () {
    $('#btn_save').click(function () {
        if (a === true) return;

        var isValid = true;
        var multi_id = $('#multi_id').val();
        
        // Insert mode - check if photos selected
        // if (!multi_id) {
        //     if ($('#photos')[0].files.length === 0) {
        //         Swal.fire({
        //             icon: 'warning',
        //             title: 'No Photos Selected',
        //             text: 'Please select at least one photo to upload',
        //             confirmButtonText: 'OK'
        //         });
        //         isValid = false;
        //     }
        // }

        if (isValid) {
            saveperform();
        }
    });
});

function saveperform() {
    var multi_id = $('#multi_id').val();
    var form = $("#Form").closest("form");
    var formData = new FormData(form[0]);

    if (multi_id > 0) {
        // ========== UPDATE MODE ==========
        a = true;

        $.ajax({
            url: base_path + "admin/Photolink/updatePhotolink",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                $('#btn_save').prop('disabled', true);
                $('#btn_save').html('<i class="fa fa-spinner fa-spin"></i> Updating...');
            },
            success: function (response) {
                console.log("Server response:", response);
                
                let data = typeof response === 'string' ? JSON.parse(response) : response;
                
                $('#btn_save').prop('disabled', false);
                $('#btn_save').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');

                if (data.status === 'success') {
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: '<strong>Success!</strong>',
                        html: `Photos Updated Successfully`,
                        showConfirmButton: false,
                        // confirmButtonText: 'Go to List',
                        timer: 3000,
                        customClass: {
                            popup: 'custom-swal-popup',
                            icon: 'custom-swal-icon',
                            title: 'custom-swal-title',
                            htmlContainer: 'custom-swal-text'
                        }
                    }).then(() => { 
                        window.location.href = base_path + 'admin/Photolink/index'; 
                    });
                } else {
                    Swal.fire('Error!', data.message || 'Update failed', 'error');
                }
                
                a = false;
            },
            error: function(xhr, status, error) {
                console.error("AJAX Error:", error);
                console.error("Response:", xhr.responseText);
                
                $('#btn_save').prop('disabled', false);
                $('#btn_save').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
                
                Swal.fire('Error!', 'Failed to update photos.', 'error');
                a = false;
            }
        });
    } else {
        // ========== INSERT MODE ==========
        a = true;

        $.ajax({
            url: base_path + "admin/Photolink/insertPhotolink",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                $('#btn_save').prop('disabled', true);
                $('#btn_save').html('<i class="fa fa-spinner fa-spin"></i> Uploading...');
            },
            success: function (response) {
                console.log("Server response:", response);
                
                let data = typeof response === 'string' ? JSON.parse(response) : response;
                
                $('#btn_save').prop('disabled', false);
                $('#btn_save').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');

                if (data.status === 'success') {
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: '<strong>Success!</strong>',
                        html: `Photos Uploaded Successfully`,
                        showConfirmButton: false,
                        // confirmButtonText: 'Add More',
                        timer: 3000,
                        customClass: {
                            popup: 'custom-swal-popup',
                            icon: 'custom-swal-icon',
                            title: 'custom-swal-title',
                            htmlContainer: 'custom-swal-text'
                        }
                    }).then(() => {
                        location.reload();
                    });
                } else {
                    Swal.fire('Error!', data.message || 'Upload failed', 'error');
                }

                a = false;
            },
            error: function(xhr, status, error) {
                console.error("AJAX Error:", error);
                console.error("Response:", xhr.responseText);
                
                $('#btn_save').prop('disabled', false);
                $('#btn_save').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
                
                Swal.fire('Error!', 'Failed to upload photos.', 'error');
                a = false;
            }
        });
    }
}