var a = false;

$(document).ready(function() {

    // ===== Save button click handler =====
    $('#submit').click(function() {
        if (a === true) return;

        var isValid = true;

        // Check required fields
        $('#Form').find('input[required], textarea[required], select[required]').each(function() {
            if (!$(this).val() || !$(this).val().trim()) {
                $(this).addClass('custom-invalid');
                isValid = false;
            } else {
                $(this).removeClass('custom-invalid');
            }
        });

        if (isValid) {
            saveperform();
        }
    });

    // ===== Remove red border on valid input =====
    $('#Form').on('input change', 'input, textarea, select', function() {
        if ($(this).val() && $(this).val().trim() !== '') {
            $(this).removeClass('custom-invalid');
        }
    });

});

// ===== MAIN SAVE / UPDATE FUNCTION =====
function saveperform() {
    var questionid     = $('#questionid').val();
    var questionName   = $('#question_name').val();
    var feedbackId     = $('#feedbackid').val();
    var answerOrText   = $('#isanswerortext').val();

    // Validate
    if (!questionName || !feedbackId || !answerOrText) {
        Swal.fire({
            icon: 'warning',
            title: 'Missing Information',
            text: 'Please fill all required fields'
        });
        return;
    }

    a = true;

    // Build FormData
    var formData = new FormData();

    // questionid: only append if editing (update mode)
    if (questionid && questionid.trim() !== '' && questionid.trim() !== '0' && parseInt(questionid) > 0) {
        formData.append('questionid', questionid.trim());
    }

    formData.append('question_name',  questionName);
    formData.append('feedbackid',     feedbackId);
    formData.append('isanswerortext', answerOrText);
    formData.append('is_active',      $('#is_active').is(':checked') ? 1 : 0);

    // ===== Decide INSERT or UPDATE URL =====
    var ajaxUrl        = base_path + "admin/Question/insertQuestion";
    var successMessage = 'Question Added Successfully';
    
    if (questionid && questionid.trim() !== '' && questionid.trim() !== '0' && parseInt(questionid) > 0) {
        ajaxUrl        = base_path + "admin/Question/updateQuestion";
        successMessage = 'Question Updated Successfully';
    }

    // ===== AJAX CALL =====
    $.ajax({
        url:         ajaxUrl,
        type:        "POST",
        data:        formData,
        processData: false,
        contentType: false,
        dataType:    'json',
        beforeSend: function() {
            $('#submit').prop('disabled', true);
            $('#submit').html('<i class="fa-solid fa-spinner fa-spin"></i> Saving...');
        },
        success: function(response) {
            $('#submit').prop('disabled', false);
            $('#submit').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');

            if (response.status) {
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: '<strong>Success!</strong>',
                    html: successMessage,
                    showConfirmButton: false,
                    timer: 2000,
                    customClass: {
                        popup:        'custom-swal-popup',
                        icon:         'custom-swal-icon',
                        title:        'custom-swal-title',
                        htmlContainer: 'custom-swal-text'
                    }
                }).then(() => {
                    window.location.href = base_path + 'admin/Question/index';
                });
            } else {
                Swal.fire({
                    icon:  'error',
                    title: 'Error',
                    text:  response.message || 'Failed to save data'
                });
            }
            
            a = false;
        },
        error: function(xhr, status, error) {
            $('#submit').prop('disabled', false);
            $('#submit').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
            
            Swal.fire({
                icon:  'error',
                title: 'Error',
                text:  'An error occurred while saving: ' + error
            });
            
            a = false;
        }
    });
}