var a = false;

$(document).ready(function () {
    // ✅ Allow only digits, max 10 for mobile
    $('#Stud_mobileNo').on('input', function () {
        this.value = this.value.replace(/\D/g, '').slice(0, 10);
    });

    // ✅ Remove validation error on input/change
    $('#Form').on('input change', 'input, select, textarea', function () {
        if ($(this).val().trim() !== '') {
            $(this).removeClass('custom-invalid');
        }
    });

    $('input[name="fkgender_id"]').on('change', function () {
        $('input[name="fkgender_id"]').removeClass('custom-invalid');
    });

    // ✅ On Save Button Click
    $('#btn_save').click(function () {
        if (a === true) return;

        var isValid = true;
        $('.custom-invalid').removeClass('custom-invalid');

        // ✅ Validate required inputs
        $('#Form').find('input[required], select[required], textarea[required]').each(function () {
            if (!$(this).val().trim()) {
                $(this).addClass('custom-invalid');
                isValid = false;
            }
        });

        // ✅ Validate gender
        if ($('input[name="fkgender_id"]:checked').length === 0) {
            $('input[name="fkgender_id"]').addClass('custom-invalid');
            isValid = false;
        }

        // ✅ Validate Gmail format
        var email = $('#Stud_mailId').val().trim();
        if (!/^[a-zA-Z0-9._%+-]+@gmail\.com$/.test(email)) {
            $('#Stud_mailId').addClass('custom-invalid');
            isValid = false;
        }

        // ✅ Validate 10-digit mobile
        var mobile = $('#Stud_mobileNo').val().trim();
        if (!/^\d{10}$/.test(mobile)) {
            $('#Stud_mobileNo').addClass('custom-invalid');
            isValid = false;
        }

        // ❌ If validation fails
        if (!isValid) return;

        // ✅ Proceed to save
        saveperform();
    });
});

// ✅ Save function
function saveperform() {
    var Id = $('#StudComp_id').val();
    var Stud_name = $('#Stud_name').val();
    var Stud_mailId = $('#Stud_mailId').val();
    var Comp_Desp = $('#Comp_Desp').val();

    if (Stud_name === "" || Stud_mailId === "" || Comp_Desp === "") return;

    var form = $("#Form")[0];
    var formData = new FormData(form);
    var url = Id > 0 ? base_path + "admin/StudComp/updateBrand" : base_path + "admin/StudComp/insertStudentComplaint";

    a = true;

    $.ajax({
        url: url,
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function () {
            $('#btn_save').prop('disabled', true).text('Loading...');
        },
        success: function (data) {
            $('#btn_save').prop('disabled', false).text('Save');
            a = false;

            try {
                var response = (typeof data === 'string') ? JSON.parse(data) : data;

                if (response.status === 'success') {
                    // ✅ Show SweetAlert
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: '<strong>Success!</strong>',
                        html: 'Data Submitted Successfully',
                        showConfirmButton: false,
                        timer: 2000,
                        customClass: {
                            popup: 'custom-swal-popup',
                            icon: 'custom-swal-icon',
                            title: 'custom-swal-title',
                            htmlContainer: 'custom-swal-text'
                        }
                    });

                    // ✅ Reset the form
                    $("#Form").trigger("reset");

                    // ✅ Open print view after short delay
                    if (response.id) {
                        setTimeout(() => {
                            $('#loading-wrapper').css('display', 'flex');

                            setTimeout(() => {
                                window.open(base_path + "admin/StudComp/printComplaint/" + response.id, '_self');

                                setTimeout(() => {
                                    $('#loading-wrapper').css('display', 'none');
                                }, 3000);
                            }, 1000);
                        }, 1500);
                    }
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Something went wrong. Please try again.',
                    });
                }
            } catch (e) {
                console.error('Invalid JSON:', data);
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Server returned unexpected response!',
                });
            }
        },
        error: function () {
            $('#btn_save').prop('disabled', false).text('Save');
            a = false;

            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Something went wrong while saving data!',
            });
        }
    });
}
