var a = false;

$(document).ready(function () {
    // Prevent navigation to disabled tabs
    $('.nav-tabs a[data-toggle="tab"]').on('click', function (e) {
        if ($(this).closest('li').hasClass('disabled')) {
            e.preventDefault();
            return false;
        }
    });
    
    
    $('#btn_save').click(function () {
    if (a === true) return;

    var isValid = true;
    var firstInvalid = null;

    // ✅ check if update (Student_id > 0)
    var isUpdate = $('#Student_id').val() > 0;

    if (!isUpdate) {
        // === Run required field validation only for insert ===
        var requiredFields = [
            '#FullName','#fkClass_id', '#EMail', '#Mobile'
        ];

        requiredFields.forEach(function (selector) {
            var input = $(selector);
            var value = input.val().trim();

            if (!value) {
                markInvalid(input);
                isValid = false;
                if (!firstInvalid) firstInvalid = input;
            } else {
                clearInvalid(input);
            }
        });

        // ✅ Gmail validation
        var email = $('#EMail').val().trim();
        var gmailRegex = /^[a-zA-Z0-9._%+-]+@gmail\.com$/;

        if (!gmailRegex.test(email)) {
            markInvalid($('#EMail'));
            isValid = false;
            if (!firstInvalid) firstInvalid = $('#EMail');
        } else {
            clearInvalid($('#EMail'));
        }

        // ❌ Stop if invalid
        if (!isValid && firstInvalid) {
            $('html, body').animate({ scrollTop: firstInvalid.offset().top - 100 }, 500);
            return;
        }
    }

    // ✅ Proceed (insert or update)
    savePersonalInfo();
});


    // === INPUT/SELECT CHANGE HANDLER ===
    $('form').on('input change', 'input, textarea, select', function () {
        if ($(this).val().trim() !== '') {
            clearInvalid($(this));
        }
    });

    // === GENDER SELECT ===
    $('input[name="fkGender_id"]').on('change', function () {
        $('input[name="fkGender_id"]').removeClass('custom-invalid');
    });

    // === PREVIOUS STEP BUTTON ===
    $('.prev-step').click(function () {
        var $activeTab = $('.wizard .nav-tabs li.active');
        var $prevTab = $activeTab.prev('li:not(.disabled)');

        if ($prevTab.length > 0) {
            $activeTab.removeClass('active');
            $prevTab.addClass('active');
            $prevTab.find('a[data-toggle="tab"]').tab('show');
            $activeTab.removeClass('completed');
            updateProgressBar();
        }
    });

    // === AUTO UPDATE FULL NAME ===
    $('#FisrtName, #MiddleName, #LastName').on('input', updateFullName);

    // === INSTITUTE & DEPARTMENT VALIDATION CLEAR ===
    // $('#fkInstitute, #fkdep_id').on('change', function () {
    //     if ($(this).val() !== '') {
    //         clearInvalid($(this));
    //     }
    // });

    // === OTHER FORM SUBMITS ===
    $('#btn_address_submit').click(function () {
        if (a === true) return;
        saveAddressInfo();
    });

    $('#btn_submit').click(function () {
        if (a === true) return;
        saveEducationInfo();
    });

    $('#btn_doc_submit').click(function () {
        if (a === true) return;
        saveDocumentInfo();
    });

    // $('#btn_department_submit').click(function () {
    //     if (a === true) return;
    //     saveDepartmentInfo();
    // });
});

// === HELPER FUNCTIONS ===
function markInvalid(input) {
    input.addClass('custom-invalid');

    // Bootstrap Select
    if (input.hasClass('selectpicker') || input.hasClass('select-single') || input.hasClass('js-states')) {
        input.parent().find('.dropdown-toggle').css('border', '1px solid red');
    }

    // Select2
    if (input.next('.select2').length) {
        input.next('.select2').find('.select2-selection').css('border', '1px solid red');
    }
}

function clearInvalid(input) {
    input.removeClass('custom-invalid');

    if (input.hasClass('selectpicker') || input.hasClass('select-single') || input.hasClass('js-states')) {
        input.parent().find('.dropdown-toggle').css('border', '');
    }

    if (input.next('.select2').length) {
        input.next('.select2').find('.select2-selection').css('border', '');
    }
}

function updateFullName() {
    var FisrtName = $('#FisrtName').val().trim();
    var MiddleName = $('#MiddleName').val().trim();
    var LastName = $('#LastName').val().trim();

    var fullName = [FisrtName, MiddleName, LastName].filter(name => name.length > 0).join(' ');
    $('#FullName').val(fullName);
}

function updateProgressBar() {
    const totalSteps = $('.wizard .nav-tabs li').length;
    const completedSteps = $('.wizard .nav-tabs li.completed').length;

    const progressPercent = (completedSteps / totalSteps) * 100;
    $('#stepProgress').css('width', progressPercent + '%');
}

function enableNextStep(currentStepId, nextStepId) {
    const $currentTab = $('a[href="#' + currentStepId + '"]').closest('li');
    const $nextTab = $('a[href="#' + nextStepId + '"]').closest('li');

    $('.wizard .nav-tabs li').removeClass('active');

    $currentTab.removeClass('active').addClass('completed');
    $nextTab.removeClass('disabled').addClass('active');
    $nextTab.find('a').tab('show');

    updateProgressBar();
}

function parseResponse(response) {
    try {
        return JSON.parse(response);
    } catch (e) {
        Swal.fire('Oops!', 'Invalid server response.', 'error');
        return null;
    }
}


// === PROGRESS BAR UPDATE ===
function updateProgressBar() {
    const totalSteps = $('.wizard .nav-tabs li').length;
    const completedSteps = $('.wizard .nav-tabs li.completed').length;

    const progressPercent = (completedSteps / totalSteps) * 100;
    $('#stepProgress').css('width', progressPercent + '%');
}


// === RESPONSE PARSER ===
function parseResponse(response) {
    try {
        return JSON.parse(response);
    } catch (e) {
        Swal.fire('Oops!', 'Invalid server response.', 'error');
        return null;
    }
}
function savePersonalInfo() {
    a = true;
    const Id = $('#Student_id').val();
    const base_path = $('#base_path').val();
    const form = $("#Form")[0];
    const formData = new FormData(form);

    const postUrl = (Id > 0)
        ? base_path + "admin/StudentReg/updatePersonalInfo"
        : base_path + "admin/StudentReg/insertPersonalInfo";

    $.ajax({
        url: postUrl,
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function () {
            $('#btn_save').prop('disabled', true).text('Loading...');
        },
        success: function (response) {
            $('#btn_save').prop('disabled', false).text('Submit');
            const res = parseResponse(response);

            if (!res) return;

            if (res.status === 'success') {
                $('#Student_id').val(res.Student_id);
                $('#Student_id_add').val(res.Student_id);
                $('#Student_id_edu').val(res.Student_id);
                $('#Student_id_doc').val(res.Student_id);

                // ✅ Custom SweetAlert Success
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: '<strong>Success!</strong>',
                    html: 'Data Submitted Successfully',
                    showConfirmButton: false,
                    timer: 2000,
                    customClass: {
                        popup: 'custom-swal-popup',
                        icon: 'custom-swal-icon',
                        title: 'custom-swal-title',
                        htmlContainer: 'custom-swal-text'
                    }
                }).then(() => {
                    enableNextStep('step1', 'step2'); // ✅ keep your step navigation
                });

            } else if (res.status === 'error' && res.message === 'Mobile number already exists.') {
                $('#Mobile').addClass('custom-invalid');
                Swal.fire('Duplicate Entry', res.message, 'warning');
            } else {
                Swal.fire('Oops!', res.message || 'Something went wrong.', 'error');
            }

            a = false;
        },
        error: function () {
            Swal.fire('Oops!', 'Failed to save Personal Info!', 'error');
            $('#btn_save').prop('disabled', false).text('Submit');
            a = false;
        }
    });
}

// === AJAX: ADDRESS INFO ===

function saveAddressInfo() {
    a = true;
    const base_path = $('#base_path').val();
    const form = $("#Form3")[0];
    const formData = new FormData(form);
    formData.append("Student_id", $('#Student_id_add').val());

    $.ajax({
        url: base_path + "admin/StudentReg/insertAddressInfo",
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function () {
            $('#btn_address_submit').prop('disabled', true).text('Loading...');
        },
        success: function (response) {
            $('#btn_address_submit').prop('disabled', false).text('Submit');
            const res = parseResponse(response);
            if (!res) return;

            if (res.status === 'success') {
                // ✅ Custom SweetAlert Success
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: '<strong>Success!</strong>',
                    html: 'Address Info Submitted Successfully',
                    showConfirmButton: false,
                    timer: 2000,
                    customClass: {
                        popup: 'custom-swal-popup',
                        icon: 'custom-swal-icon',
                        title: 'custom-swal-title',
                        htmlContainer: 'custom-swal-text'
                    }
                }).then(() => {
                    enableNextStep('step2', 'step3'); // ✅ keep your step navigation
                });
            } else {
                Swal.fire('Oops!', res.message || 'Update failed.', 'error');
            }

            a = false;
        },
        error: function () {
            Swal.fire('Oops!', 'Failed to save Address Info!', 'error');
            $('#btn_address_submit').prop('disabled', false).text('Submit');
            a = false;
        }
    });
}


// === AJAX: EDUCATION INFO ===
function saveEducationInfo() {
    a = true;
    const base_path = $('#base_path').val();
    const form = $("#Form1")[0];
    const formData = new FormData(form);
    formData.append("Student_id", $('#Student_id_edu').val());

    $.ajax({
        url: base_path + "admin/StudentReg/insertEducationInfo",
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function () {
            $('#btn_submit').prop('disabled', true).text('Loading...');
        },
        success: function (response) {
            $('#btn_submit').prop('disabled', false).text('Submit');

            // ✅ Custom SweetAlert Success
            Swal.fire({
                position: 'center',
                icon: 'success',
                title: '<strong>Success!</strong>',
                html: 'Education Info Submitted Successfully',
                showConfirmButton: false,
                timer: 2000,
                customClass: {
                    popup: 'custom-swal-popup',
                    icon: 'custom-swal-icon',
                    title: 'custom-swal-title',
                    htmlContainer: 'custom-swal-text'
                }
            }).then(() => {
                enableNextStep('step3', 'step4'); // ✅ keep your step navigation
            });

            a = false;
        },
        error: function () {
            Swal.fire('Oops!', 'Failed to save Education Info!', 'error');
            $('#btn_submit').prop('disabled', false).text('Submit');
            a = false;
        }
    });
}

// Document Info
function saveDocumentInfo() {
    a = true;
    const base_path = $('#base_path').val();
    const form = $("#Form2")[0];
    const formData = new FormData(form);
    formData.append("Student_id", $('#Student_id_doc').val());

    $.ajax({
        url: base_path + "admin/StudentReg/insertDocumentInfo",
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function () {
            $('#btn_doc_submit').prop('disabled', true).text('Loading...');
        },
        success: function (response) {
            $('#btn_doc_submit').prop('disabled', false).text('Submit');

            // ✅ Custom SweetAlert Success
            Swal.fire({
                position: 'center',
                icon: 'success',
                title: '<strong>Success!</strong>',
                html: 'Document Info Submitted Successfully',
                showConfirmButton: false,
                timer: 2000,
                customClass: {
                    popup: 'custom-swal-popup',
                    icon: 'custom-swal-icon',
                    title: 'custom-swal-title',
                    htmlContainer: 'custom-swal-text'
                }
            }).then(() => {
                // ✅ Keep your final redirect
                window.location.href = base_path + "admin/StudentReg/index";
            });

            a = false;
        },
        error: function () {
            Swal.fire('Oops!', 'Failed to save Document Info!', 'error');
            $('#btn_doc_submit').prop('disabled', false).text('Submit');
            a = false;
        }
    });
}


