var a = false;

$(document).ready(function () {
    $('#btn_save').click(function () {
        if (a === true) return;
        saveperform();
    });
});

function saveperform() {
    var Id = $('#id').val();
    var fk_rootmaster = $('#fk_rootmaster').val();

    // Route validation
    if (fk_rootmaster == "" || fk_rootmaster == null) {
        Swal.fire({
            position: 'center',
            icon: 'warning',
            title: '<strong>Required!</strong>',
            html: 'Please select Route',
            showConfirmButton: false,
            timer: 2000
        });
        return;
    }

    if (Id > 0) {
        // UPDATE MODE
        updateData();
    } else {
        // INSERT MODE
        insertData();
    }
}

function insertData() {
    a = true;
    
    // Manual FormData banao
    var formData = new FormData();
    
    // Foreign keys
    formData.append('fk_rootmaster', $('#fk_rootmaster').val());
    formData.append('fk_stopname', $('#fk_stopname').val());
    formData.append('fk_vehiclenames', $('#fk_vehiclenames').val());
    formData.append('fk_usertype', $('#fk_usertype').val());
    formData.append('fk_finalyear', $('#fk_finalyear').val());
    
    // Student arrays
    var rowCount = 0;
    $('#studentParentTbody tr').each(function() {
        var prn = $(this).find('input[name="prn[]"]').val() || '';
        var name = $(this).find('input[name="student_name[]"]').val() || '';
        var branch = $(this).find('input[name="branch[]"]').val() || '';
        var cls = $(this).find('input[name="class[]"]').val() || '';
        var div = $(this).find('input[name="division[]"]').val() || '';
        var contact = $(this).find('input[name="contact_no[]"]').val() || '';
        var address = $(this).find('input[name="address[]"]').val() || '';
        var aadhar = $(this).find('input[name="aadhar_no[]"]').val() || '';
        var portal = $(this).find('input[name="portal_mobile[]"]').val() || '';
        
        // Skip empty rows
        if (prn.trim() === '' && name.trim() === '') {
            return true; // continue
        }
        
        formData.append('prn[]', prn);
        formData.append('student_name[]', name);
        formData.append('branch[]', branch);
        formData.append('class[]', cls);
        formData.append('division[]', div);
        formData.append('contact_no[]', contact);
        formData.append('address[]', address);
        formData.append('aadhar_no[]', aadhar);
        formData.append('portal_mobile[]', portal);
        
        rowCount++;
    });
    
    if (rowCount === 0) {
        Swal.fire({
            position: 'center',
            icon: 'warning',
            title: '<strong>Required!</strong>',
            html: 'Please add at least one student',
            showConfirmButton: false,
            timer: 2000
        });
        a = false;
        return;
    }

    $.ajax({
        url: base_path + "admin/Student_transfortfrom/insertsoftware",
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function () {
            $('#btn_save').prop('disabled', true);
            $('#btn_save').html('Loading...');
        },
        success: function (data) {
            console.log("Response:", data);
            $('#btn_save').prop('disabled', false);
            $('#btn_save').html('Save');

            var response = typeof data === 'string' ? JSON.parse(data) : data;

            if (response.status === 'success') {
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: '<strong>Success!</strong>',
                    html: 'Data Submitted Successfully',
                    showConfirmButton: false,
                    timer: 2000,
                    customClass: {
                        popup: 'custom-swal-popup',
                        icon: 'custom-swal-icon',
                        title: 'custom-swal-title',
                        htmlContainer: 'custom-swal-text'
                    }
                }).then(() => {
                    window.location.href = base_path + 'admin/Student_transfortfrom/index';
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: response.msg || 'Failed to save data'
                });
            }
            a = false;
        },
        error: function(xhr, status, error) {
            console.error("Error:", error);
            console.log("Response Text:", xhr.responseText);
            $('#btn_save').prop('disabled', false);
            $('#btn_save').html('Save');
            Swal.fire({
                icon: 'error',
                title: 'Error!',
                text: 'Something went wrong. Check console for details.'
            });
            a = false;
        }
    });
}

function updateData() {
    a = true;
    
    // Manual FormData banao
    var formData = new FormData();
    
    // Hidden ID field
    formData.append('id', $('#id').val());
    
    // Foreign keys
    formData.append('fk_rootmaster', $('#fk_rootmaster').val());
    formData.append('fk_stopname', $('#fk_stopname').val());
    formData.append('fk_vehiclenames', $('#fk_vehiclenames').val());
    formData.append('fk_usertype', $('#fk_usertype').val());
    formData.append('fk_finalyear', $('#fk_finalyear').val());
    
    // Student data (single row but in array format)
    var rowCount = 0;
    $('#studentParentTbody tr').each(function() {
        var prn = $(this).find('input[name="prn[]"]').val() || '';
        var name = $(this).find('input[name="student_name[]"]').val() || '';
        
        if (prn.trim() === '' && name.trim() === '') {
            return true; // skip empty
        }
        
        formData.append('prn', prn);
        formData.append('student_name', name);
        formData.append('branch', $(this).find('input[name="branch[]"]').val() || '');
        formData.append('class', $(this).find('input[name="class[]"]').val() || '');
        formData.append('division', $(this).find('input[name="division[]"]').val() || '');
        formData.append('contact_no', $(this).find('input[name="contact_no[]"]').val() || '');
        formData.append('address', $(this).find('input[name="address[]"]').val() || '');
        formData.append('aadhar_no', $(this).find('input[name="aadhar_no[]"]').val() || '');
        formData.append('portal_mobile', $(this).find('input[name="portal_mobile[]"]').val() || '');
        
        rowCount++;
    });
    
    if (rowCount === 0) {
        Swal.fire({
            position: 'center',
            icon: 'warning',
            title: '<strong>Required!</strong>',
            html: 'Please fill student details',
            showConfirmButton: false,
            timer: 2000
        });
        a = false;
        return;
    }

    $.ajax({
        url: base_path + "admin/Student_transfortfrom/updatesoftware",
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function () {
            $('#btn_save').prop('disabled', true);
            $('#btn_save').html('Loading...');
        },
        success: function (data) {
            console.log(data);
            $('#btn_save').prop('disabled', false);
            $('#btn_save').html('Update');

            Swal.fire({
                position: 'center',
                icon: 'success',
                title: '<strong>Success!</strong>',
                html: 'Data Updated Successfully',
                showConfirmButton: false,
                timer: 2000,
                customClass: {
                    popup: 'custom-swal-popup',
                    icon: 'custom-swal-icon',
                    title: 'custom-swal-title',
                    htmlContainer: 'custom-swal-text'
                }
            }).then(() => {
                window.location.href = base_path + 'admin/Student_transfortfrom/index';
            });
            a = false;
        },
        error: function(xhr, status, error) {
            console.error("Error:", error);
            $('#btn_save').prop('disabled', false);
            $('#btn_save').html('Update');
            Swal.fire({
                icon: 'error',
                title: 'Error!',
                text: 'Something went wrong. Please try again.'
            });
            a = false;
        }
    });
}