var a = false;

$(document).ready(function () {
    // ⭐ Check if in UPDATE mode
    let isUpdateMode = $('#conslt_id').val() ? true : false;
    
    $('#btn_save').click(function () {
        if (a === true) return;

        var isValid = true;

        // Check required input, select, textarea
        $('#Form').find('input[required], textarea[required]').each(function () {
            if (!$(this).val().trim()) {
                $(this).addClass('custom-invalid');
                isValid = false;
            } else {
                $(this).removeClass('custom-invalid');
            }
        });

        if (isValid) {
            saveperform();
        }
    });

    // Remove red border on valid input
    $('#Form').on('input change', 'input, textarea', function () {
        if ($(this).val().trim() !== '') {
            $(this).removeClass('custom-invalid');
        }
    });

    // ⭐ CRITICAL: Remove Row functionality - Check minimum 1 row in UPDATE mode
    $(document).on("click", ".removeRow", function () {
        if (isUpdateMode) {
            // In UPDATE mode, at least 1 row must remain
            if ($("#tableBody tr").length <= 1) {
                Swal.fire("Warning", "At least one row is required!", "warning");
                return;
            }
        }
        $(this).closest("tr").remove();
        updateSerialNumbers();
    });

    // Update serial numbers
    function updateSerialNumbers() {
        let rowCount = 0;
        $("#tableBody tr").each(function () {
            rowCount++;
            $(this).find("td:first").text(rowCount);
        });
    }
});

// ⭐ HELPER FUNCTION: Find ID by name or return NEW::name
function findOrCreateOption(name, optionsArray, idField, nameField) {
    if (!name || name.trim() === '') return '';
    
    name = name.toString().trim();
    
    // Search in existing options
    for (let i = 0; i < optionsArray.length; i++) {
        if (optionsArray[i][nameField].toLowerCase() === name.toLowerCase()) {
            return optionsArray[i][idField];
        }
    }
    
    // If not found, return NEW::name format
    return 'NEW::' + name;
}

// ⭐ HELPER FUNCTION: Collect new branches
function collectNewBranches() {
    let newBranches = [];
    
    $('select[name="fk_branch[]"]').each(function() {
        let val = $(this).val();
        
        if (val && val.startsWith('NEW::')) {
            let branchName = val.replace('NEW::', '');
            
            if (branchName && newBranches.indexOf(branchName) === -1) {
                newBranches.push(branchName);
            }
        }
    });
    
    console.log("New branches collected:", newBranches);
    return newBranches;
}

// ⭐ HELPER FUNCTION: Collect new faculties
function collectNewFaculties() {
    let newFaculties = [];
    
    $('select[name="fk_fac[]"]').each(function() {
        let val = $(this).val();
        
        if (val && val.startsWith('NEW::')) {
            let facultyName = val.replace('NEW::', '');
            
            if (facultyName && newFaculties.indexOf(facultyName) === -1) {
                newFaculties.push(facultyName);
            }
        }
    });
    
    console.log("New faculties collected:", newFaculties);
    return newFaculties;
}

// ⭐ HELPER FUNCTION: Collect new years
function collectNewYears() {
    let newYears = [];
    
    $('select[name="Financial_year[]"]').each(function() {
        let val = $(this).val();
        
        if (val && val.startsWith('NEW::')) {
            let yearLabel = val.replace('NEW::', '');
            
            if (yearLabel && newYears.indexOf(yearLabel) === -1) {
                newYears.push(yearLabel);
            }
        }
    });
    
    console.log("New years collected:", newYears);
    return newYears;
}

function saveperform() {
    var Id = $('#conslt_id').val();
    
    // ⭐ CRITICAL: Validate conslt_id in UPDATE mode
    if (!Id || Id.toString().trim() === '') {
        // Try to get from URL if hidden field is empty
        var urlParts = window.location.href.split('/');
        var urlId = urlParts[urlParts.length - 1];
        
        if (urlId && !isNaN(urlId)) {
            Id = urlId;
            $('#conslt_id').val(Id); // Set it back to hidden field
            console.log("Retrieved conslt_id from URL:", Id);
        }
    }
    
    console.log("Final conslt_id for save:", Id);
    
    // ⭐ Check if at least 1 row exists
    var tableRowCount = $('#tableBody tr').length;
    
    if (tableRowCount === 0) {
        Swal.fire('Warning!', 'At least one row is required!', 'warning');
        return;
    }

    var form = $("#Form").closest("form");
    var formData = new FormData(form[0]);
    
    // ⭐ CRITICAL: Ensure conslt_id is in formData for UPDATE mode
    if (Id && Id > 0) {
        formData.set('conslt_id', Id);
    }

    // ⭐ CRITICAL: Always collect and add new branches, faculties, and years
    let newBranches = collectNewBranches();
    let newFaculties = collectNewFaculties();
    let newYears = collectNewYears();
    
    formData.append('new_branches', JSON.stringify(newBranches));
    formData.append('new_faculties', JSON.stringify(newFaculties));
    formData.append('new_years', JSON.stringify(newYears));

    if (Id > 0) {
        // ========== UPDATE MODE ==========
        a = true;

        console.log("UPDATE MODE - conslt_id:", Id);
        console.log("Table row count:", tableRowCount);
        console.log("New branches being sent:", newBranches);
        console.log("New faculties being sent:", newFaculties);
        console.log("New years being sent:", newYears);

        $.ajax({
            url: base_path + "admin/Consultancy/updateConsultancy",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                $('#btn_save').prop('disabled', true);
                $('#btn_save').html('<i class="fa fa-spinner fa-spin"></i> Loading');
            },
            success: function (response) {
                console.log("Server response:", response);
                
                let data = typeof response === 'string' ? JSON.parse(response) : response;
                
                $('#btn_save').prop('disabled', false);
                $('#btn_save').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');

                if (data.status === 'success') {
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: '<strong>Success!</strong>',
                        html: data.message || 'Data Updated Successfully',
                        showConfirmButton: false,
                        timer: 2000,
                        customClass: {
                            popup: 'custom-swal-popup',
                            icon: 'custom-swal-icon',
                            title: 'custom-swal-title',
                            htmlContainer: 'custom-swal-text'
                        }
                    }).then(() => { 
                        window.location.href = base_path + 'admin/Consultancy/index'; 
                    });
                } else {
                    Swal.fire('Error!', data.message || 'Update failed', 'error');
                }
                
                a = false;
            },
            error: function(xhr, status, error) {
                console.error("AJAX Error:", error);
                console.error("Status:", status);
                console.error("Response:", xhr.responseText);
                
                $('#btn_save').prop('disabled', false);
                $('#btn_save').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
                
                Swal.fire('Error!', 'Failed to update data. Check console for details.', 'error');
                a = false;
            }
        });
    } else {
        // ========== INSERT MODE ==========
        a = true;

        console.log("INSERT MODE");
        console.log("New branches being sent:", newBranches);
        console.log("New faculties being sent:", newFaculties);
        console.log("New years being sent:", newYears);

        $.ajax({
            url: base_path + "admin/Consultancy/insertConsultancy",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                $('#btn_save').prop('disabled', true);
                $('#btn_save').html('<i class="fa fa-spinner fa-spin"></i> Loading');
            },
            success: function (response) {
                console.log("Server response:", response);
                
                let data = typeof response === 'string' ? JSON.parse(response) : response;
                
                $('#btn_save').prop('disabled', false);
                $('#btn_save').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');

                if (data.status === 'success') {
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: '<strong>Success!</strong>',
                        html: 'Data Submitted Successfully',
                        showConfirmButton: false,
                        timer: 2000,
                        customClass: {
                            popup: 'custom-swal-popup',
                            icon: 'custom-swal-icon',
                            title: 'custom-swal-title',
                            htmlContainer: 'custom-swal-text'
                        }
                    }).then(() => {
                        location.reload();
                    });
                } else {
                    Swal.fire('Error!', data.message || 'Submission failed', 'error');
                }

                a = false;
            },
            error: function(xhr, status, error) {
                console.error("AJAX Error:", error);
                console.error("Status:", status);
                console.error("Response:", xhr.responseText);
                
                $('#btn_save').prop('disabled', false);
                $('#btn_save').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
                
                Swal.fire('Error!', 'Failed to save data. Check console for details.', 'error');
                a = false;
            }
        });
    }
}