var a = false;
 
$(document).ready(function () {
    
    // Country change event - State load karo
    $('#fk_Country').on('change', function () {
        var countryId = $(this).val();
        
        // State dropdown reset karo
        $('#fk_State').html('<option value="">Select State</option>');
        
        if(countryId != '') {
            $.ajax({
                url: base_path + 'admin/Districtmaster/get_states_by_country',
                type: 'POST',
                data: {country_id: countryId},
                dataType: 'json',
                success: function(response) {
                    if(response.status == 'success') {
                        var options = '<option value="">Select State</option>';
                        $.each(response.data, function(key, value) {
                            options += '<option value="' + value.stateId + '">' + value.stateName + '</option>';
                        });
                        $('#fk_State').html(options);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error loading states:', error);
                }
            });
        }
    });
    
    $('#btn_save').click(function () {
        if (a === true) return;
 
        var isValid = true;
 
        // Check required input, select, textarea
        $('#Form').find('input[required], textarea[required], select[required]').each(function () {
            if (!$(this).val() || $(this).val().trim() === '') {
                $(this).addClass('custom-invalid');
                isValid = false;
            } else {
                $(this).removeClass('custom-invalid');
            }
        });

        if (isValid) {
            saveperform();
        } else {
            Swal.fire({
                position: 'center',
                icon: 'warning',
                title: 'Required Fields',
                html: 'Please fill all required fields',
                showConfirmButton: true
            });
        }
    });
 
    // Remove red border on valid input
    $('#Form').on('input change', 'input, textarea, select', function () {
        if ($(this).val() && $(this).val().trim() !== '') {
            $(this).removeClass('custom-invalid');
        }
    });

});
 
function saveperform() {
    var Id = $('#district_id').val();
    var name = $('#district_name').val();
    var country = $('#fk_Country').val();
    var state = $('#fk_State').val();
      
    
    if (name == "" || country == "" || state == "") {
        Swal.fire({
            position: 'center',
            icon: 'warning',
            title: 'Required Fields',
            html: 'Please fill all required fields',
            showConfirmButton: true
        });
        return;
    } else {
        if (Id > 0) {
            a = true;
 
            var form = $("#Form").closest("form");
            var formData = new FormData(form[0]);
 
            $.ajax({
                url: base_path + "admin/Districtmaster/updatesoftware",
                type: "POST",
                data: formData,
                processData: false,
                contentType: false,
                beforeSend: function () {
                    $('#btn_save').prop('disabled', true);
                    $('#btn_save').html('Loading');
                },
                success: function (data) {
                    console.log(data);
                    $('#btn_save').prop('disabled', false);
                    $('#btn_save').html('Save');
 
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: '<strong>Success!</strong>',
                        html: 'Data Updated Successfully',
                        showConfirmButton: false,
                        timer: 2000,
                        customClass: {
                            popup: 'custom-swal-popup',
                            icon: 'custom-swal-icon',
                            title: 'custom-swal-title',
                            htmlContainer: 'custom-swal-text'
                        }
                    }).then(() => { 
                        window.location.href = base_path + 'admin/Districtmaster/index'; 
                    });
                    a = false;
                },
                error: function(xhr, status, error) {
                    console.error('Error:', error);
                    $('#btn_save').prop('disabled', false);
                    $('#btn_save').html('Save');
                    a = false;
                }
            });
        } else {
            a = true;
            var form = $("#Form").closest("form");
            var formData = new FormData(form[0]);
 
            $.ajax({
                url: base_path + "admin/Districtmaster/insertsoftware",
                type: "POST",
                data: formData,
                processData: false,
                contentType: false,
                beforeSend: function () {
                    $('#btn_save').prop('disabled', true);
                    $('#btn_save').html('Loading');
                },
                success: function (data) {
                    console.log(data);
                    $('#btn_save').prop('disabled', false);
                    $('#btn_save').html('Save');

                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: '<strong>Success!</strong>',
                        html: 'Data Submitted Successfully',
                        showConfirmButton: false,
                        timer: 2000,
                        customClass: {
                            popup: 'custom-swal-popup',
                            icon: 'custom-swal-icon',
                            title: 'custom-swal-title',
                            htmlContainer: 'custom-swal-text'
                        }
                    }).then(() => {
                        location.reload();
                    });

                    a = false;
                },
                error: function(xhr, status, error) {
                    console.error('Error:', error);
                    $('#btn_save').prop('disabled', false);
                    $('#btn_save').html('Save');
                    a = false;
                }
            });
        }
    }
}