$(document).ready(function(){

    // Save Button Click Event
    $('#btn_save').click(function(){
        var honor_minor_id = $('#honor_minor_id').val();
        var fk_honor_minor_type = $('#fk_honor_minor_type').val();
        var student_name = $('#student_name').val();
        var fk_department = $('#fk_department').val();
        var fk_year = $('#fk_year').val();
        var honor_minor_date = $('#honor_minor_date').val();

        // Validation
        if(!fk_honor_minor_type){
            Swal.fire({
                icon: 'warning',
                title: 'Validation Error',
                text: 'Please select Honor/Minor Type!',
            });
            return false;
        }

        if(!student_name){
            Swal.fire({
                icon: 'warning',
                title: 'Validation Error',
                text: 'Please enter Student Name!',
            });
            return false;
        }



        if(!fk_year){
            Swal.fire({
                icon: 'warning',
                title: 'Validation Error',
                text: 'Please select Academic Year!',
            });
            return false;
        }

    

        // Check if at least one course detail is added
        var hasCourseData = false;
        $('input[name="course_name[]"]').each(function(){
            if($(this).val().trim() !== ''){
                hasCourseData = true;
                return false;
            }
        });

        if(!hasCourseData){
            Swal.fire({
                icon: 'warning',
                title: 'Validation Error',
                text: 'Please add at least one course detail!',
            });
            return false;
        }

        var formData = new FormData($('#Form')[0]);

        if(honor_minor_id > 0){
            // Update Mode
            $.ajax({
                url: base_path + "/admin/Honor_Minor/updatehonorminor",
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                dataType: 'JSON',
                success: function(data){
                    if(data.status == 'success'){
                        Swal.fire({
  position: 'center',
  icon: 'success',
  title: '<strong>Success!</strong>',
  html: 'Data Updated Successfully',
  showConfirmButton: false,
  timer: 2000,
  customClass: {
    popup: 'custom-swal-popup',
    icon: 'custom-swal-icon',
    title: 'custom-swal-title',
    htmlContainer: 'custom-swal-text'
  }
})
.then(() => { window.location.href = base_path + 'admin/Honor_Minor/index'; 
 });
// .then(function(){ window.location.href = base_url + '/admin/Honor_Minor/index';
//                         });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: data.message || 'Failed to update Honor & Minor!',
                        });
                    }
                },
                error: function(xhr, status, error){
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred: ' + error,
                    });
                }
            });
        } else {
            // Insert Mode
            $.ajax({
                url: base_path + "admin/Honor_Minor/inserthonorminor",
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                dataType: 'JSON',
                success: function(data){
                    if(data.status == 'success'){
                      Swal.fire({
  position: 'center',
  icon: 'success',
  title: '<strong>Success!</strong>',
  html: 'Data Submitted Successfully',
  showConfirmButton: false,
  timer: 2000,
  customClass: {
    popup: 'custom-swal-popup',
    icon: 'custom-swal-icon',
    title: 'custom-swal-title',
    htmlContainer: 'custom-swal-text'
  }
})
.then(() => {
        location.reload();
    });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: data.message || 'Failed to save Honor & Minor!',
                        });
                    }
                },
                error: function(xhr, status, error){
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred: ' + error,
                    });
                }
            });
        }
    });

    // For Honor/Minor Type Master
    $('#btn_save_type').click(function(){
        var honor_minor_type_name = $('#honor_minor_type_name').val();

        if(!honor_minor_type_name){
            Swal.fire({
                icon: 'warning',
                title: 'Validation Error',
                text: 'Please enter Honor/Minor Type Name!',
            });
            return false;
        }

        var formData = new FormData($('#TypeForm')[0]);

        $.ajax({
            url: base_path + "admin/Honor_Minor/insert_honor_minor_type",
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'JSON',
            success: function(data){
                if(data.status == 'success'){
             Swal.fire({
  position: 'center',
  icon: 'success',
  title: '<strong>Success!</strong>',
  html: 'Data Updated Successfully',
  showConfirmButton: false,
  timer: 2000,
  customClass: {
    popup: 'custom-swal-popup',
    icon: 'custom-swal-icon',
    title: 'custom-swal-title',
    htmlContainer: 'custom-swal-text'
  }
})
.then(() => { window.location.href = base_path + 'admin/Honor_Minor/index';
 });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: data.message || 'Failed to save Honor/Minor Type!',
                    });
                }
            },
            error: function(xhr, status, error){
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'An error occurred: ' + error,
                });
            }
        });
    });
});