var a = false;
 
 $(document).ready(function () {
    $('#submit').click(function () {
        if (a === true) return;
 
        var isValid = true;
 
        // Check required input, select, textarea
        $('#Form').find('input[required], textarea[required], select[required]').each(function () {
            if (!$(this).val().trim()) {
                $(this).addClass('custom-invalid');
                isValid = false;
            } else {
                $(this).removeClass('custom-invalid');
            }
        });
 
        if (isValid) {
            saveperform();
        }
    });
 
    // Remove red border on valid input
    $('#Form').on('input change', 'input, textarea, select', function () {
        if ($(this).val().trim() !== '') {
            $(this).removeClass('custom-invalid');
        }
    });
});
 
function saveperform() {
    var Id = $('#main_NPTL_id').val(); // Fixed: Use the correct ID field
    var Domain_branch = $('#Domain_branch').val();
    var Domain_name = $('#Domain_name').val();
    var Faculty_name = $('#Faculty_name').val();
    var Faculty_id = $('#Faculty_id').val();
    var finicial_Year = $('#finicial_Year').val();
    var Date = $('#Date').val();
    var Photo_url = $('#Photo_url').val();
    
    // Basic validation - check if at least Domain Branch is filled
    if (!Domain_branch) {
        Swal.fire({
            position: 'center',
            icon: 'error',
            title: '<strong>Error!</strong>',
            html: 'Please fill in the required fields',
            showConfirmButton: true,
            customClass: {
                popup: 'custom-swal-popup',
                icon: 'custom-swal-icon',
                title: 'custom-swal-title',
                htmlContainer: 'custom-swal-text'
            }
        });
        return;
    }

    if (Id > 0) {
        // UPDATE CASE
        a = true;
        var form = $("#Form")[0];
        var formData = new FormData(form);
 
        $.ajax({
            url: base_path + "admin/NPTL/updateData", // Fixed: Use the correct controller method
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                $('#submit').prop('disabled', true);
                $('#submit').html('Loading...');
            },
            success: function (data) {
                console.log(data);
                $('#submit').prop('disabled', false);
                $('#submit').html('Save');
                
                try {
                    var response = JSON.parse(data);
                    if (response.success) {
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            title: '<strong>Success!</strong>',
                            html: response.message,
                            showConfirmButton: false,
                            timer: 2000,
                            customClass: {
                                popup: 'custom-swal-popup',
                                icon: 'custom-swal-icon',
                                title: 'custom-swal-title',
                                htmlContainer: 'custom-swal-text'
                            }
                        }).then(() => { 
                            window.location.href = base_path + 'admin/NPTL/index';
                        });
                    } else {
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: '<strong>Error!</strong>',
                            html: response.message,
                            showConfirmButton: true
                        });
                    }
                } catch (e) {
                    console.error('Error parsing response:', e);
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: '<strong>Success!</strong>',
                        html: 'Data Updated Successfully',
                        showConfirmButton: false,
                        timer: 2000
                    }).then(() => { 
                        window.location.href = base_path + 'admin/NPTL/index';
                    });
                }
 
                a = false;
            },
            error: function(xhr, status, error) {
                console.error(error);
                $('#submit').prop('disabled', false);
                $('#submit').html('Save');
                
                // Show more detailed error information
                var errorMessage = 'Failed to update data. Please try again.';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMessage = xhr.responseJSON.message;
                } else if (xhr.responseText) {
                    try {
                        var errorData = JSON.parse(xhr.responseText);
                        if (errorData.message) {
                            errorMessage = errorData.message;
                        }
                    } catch (e) {
                        errorMessage = 'Server error: ' + xhr.status + ' ' + xhr.statusText;
                    }
                }
                
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: '<strong>Error!</strong>',
                    html: errorMessage,
                    showConfirmButton: true
                });
                
                a = false;
            }
        });
    } else {
        // INSERT CASE
        a = true;
        var form = $("#Form")[0];
        var formData = new FormData(form);
 
        $.ajax({
            url: base_path + "admin/NPTL/insert", // Fixed: Use the correct controller method
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                $('#submit').prop('disabled', true);
                $('#submit').html('Loading...');
            },
            success: function (data) {
                console.log(data);
                $('#submit').prop('disabled', false);
                $('#submit').html('Save');
                
                try {
                    var response = JSON.parse(data);
                    if (response.success) {
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            title: '<strong>Success!</strong>',
                            html: response.message,
                            showConfirmButton: false,
                            timer: 2000,
                            customClass: {
                                popup: 'custom-swal-popup',
                                icon: 'custom-swal-icon',
                                title: 'custom-swal-title',
                                htmlContainer: 'custom-swal-text'
                            }
                        }).then(() => {
                            // Redirect to list page instead of reload
                            window.location.href = base_path + 'admin/NPTL/index';
                        });
                    } else {
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: '<strong>Error!</strong>',
                            html: response.message,
                            showConfirmButton: true
                        });
                    }
                } catch (e) {
                    console.error('Error parsing response:', e);
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: '<strong>Success!</strong>',
                        html: 'Data Submitted Successfully',
                        showConfirmButton: false,
                        timer: 2000
                    }).then(() => {
                        // Redirect to list page instead of reload
                        window.location.href = base_path + 'admin/NPTL/index';
                    });
                }

                a = false;
            },
            error: function(xhr, status, error) {
                console.error(error);
                $('#submit').prop('disabled', false);
                $('#submit').html('Save');
                
                // Show more detailed error information
                var errorMessage = 'Failed to submit data. Please try again.';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMessage = xhr.responseJSON.message;
                } else if (xhr.responseText) {
                    try {
                        var errorData = JSON.parse(xhr.responseText);
                        if (errorData.message) {
                            errorMessage = errorData.message;
                        }
                    } catch (e) {
                        errorMessage = 'Server error: ' + xhr.status + ' ' + xhr.statusText;
                    }
                }
                
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: '<strong>Error!</strong>',
                    html: errorMessage,
                    showConfirmButton: true
                });
                
                a = false;
            }
        });
    }
}