var a = false;
 
$(document).ready(function () {
    $('#submit').click(function () {
        if (a === true) return;
 
        var isValid = true;
 
        // Check required input, select, textarea
        $('#Form').find('input[required], textarea[required], select[required]').each(function () {
            if (!$(this).val().trim()) {
                $(this).addClass('custom-invalid');
                isValid = false;
            } else {
                $(this).removeClass('custom-invalid');
            }
        });
 
        if (isValid) {
            saveperform();
        }
    });
 
    // Remove red border on valid input
    $('#Form').on('input change', 'input, textarea, select', function () {
        if ($(this).val().trim() !== '') {
            $(this).removeClass('custom-invalid');
        }
    });
});
 
function saveperform() {
    var Id = $('#Practiced_id').val();
    var fkmainuser_id = $('#fkmainuser_id').val();
    var StartDate = $('#StartDate').val();
    var EndDate = $('#EndDate').val();
    
    // Basic validation - check if at least mainuser is selected
    if (!fkmainuser_id) {
        Swal.fire({
            position: 'center',
            icon: 'error',
            title: '<strong>Error!</strong>',
            html: 'Please select Applicant Type',
            showConfirmButton: true,
            customClass: {
                popup: 'custom-swal-popup',
                icon: 'custom-swal-icon',
                title: 'custom-swal-title',
                htmlContainer: 'custom-swal-text'
            }
        });
        return;
    }

    if (Id > 0) {
        // UPDATE CASE
        a = true;
        var form = $("#Form").closest("form");
        var formData = new FormData(form[0]);
 
        $.ajax({
            url: base_path + "admin/Practiced/updatePracticed",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                $('#submit').prop('disabled', true);
                $('#submit').html('Loading...');
            },
            success: function (data) {
                console.log(data);
                $('#submit').prop('disabled', false);
                $('#submit').html('Save');
 
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: '<strong>Success!</strong>',
                    html: 'Data Updated Successfully',
                    showConfirmButton: false,
                    timer: 2000,
                    customClass: {
                        popup: 'custom-swal-popup',
                        icon: 'custom-swal-icon',
                        title: 'custom-swal-title',
                        htmlContainer: 'custom-swal-text'
                    }
                }).then(() => { 
                    window.location.href = base_path + 'admin/Practiced/index';
                });
 
                a = false;
            },
            error: function(xhr, status, error) {
                console.error(error);
                $('#submit').prop('disabled', false);
                $('#submit').html('Save');
                
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: '<strong>Error!</strong>',
                    html: 'Failed to update data. Please try again.',
                    showConfirmButton: true
                });
                
                a = false;
            }
        });
    } else {
        // INSERT CASE
        a = true;
        var form = $("#Form").closest("form");
        var formData = new FormData(form[0]);
 
        $.ajax({
            url: base_path + "admin/Practiced/insertPracticed",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                $('#submit').prop('disabled', true);
                $('#submit').html('Loading...');
            },
            success: function (data) {
                console.log(data);
                $('#submit').prop('disabled', false);
                $('#submit').html('Save');
                
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: '<strong>Success!</strong>',
                    html: 'Data Submitted Successfully',
                    showConfirmButton: false,
                    timer: 2000,
                    customClass: {
                        popup: 'custom-swal-popup',
                        icon: 'custom-swal-icon',
                        title: 'custom-swal-title',
                        htmlContainer: 'custom-swal-text'
                    }
                }).then(() => {
                    // Redirect to list page instead of reload
                    window.location.href = base_path + 'admin/Practiced/index';
                });

                a = false;
            },
            error: function(xhr, status, error) {
                console.error(error);
                $('#submit').prop('disabled', false);
                $('#submit').html('Save');
                
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: '<strong>Error!</strong>',
                    html: 'Failed to submit data. Please try again.',
                    showConfirmButton: true
                });
                
                a = false;
            }
        });
    }
}