var a = false;

$(document).ready(function () {
    $('#btn_save').click(function () {
        if (a === true) return;

        var isValid = true;

        // Check required input, select, textarea
        $('#Form').find('input[required], textarea[required]').each(function () {
            if (!$(this).val().trim()) {
                $(this).addClass('custom-invalid');
                isValid = false;
            } else {
                $(this).removeClass('custom-invalid');
            }
        });

        if (isValid) {
            saveperform();
        }
    });

    // Remove red border on valid input
    $('#Form').on('input change', 'input, textarea', function () {
        if ($(this).val().trim() !== '') {
            $(this).removeClass('custom-invalid');
        }
    });
});

// ⭐ HELPER FUNCTION: Collect new branches
function collectNewBranches() {
    let newBranches = [];
    
    $('select[name="fk_branch[]"]').each(function() {
        let val = $(this).val();
        
        if (val && val.startsWith('NEW::')) {
            let branchName = val.replace('NEW::', '');
            
            if (branchName && newBranches.indexOf(branchName) === -1) {
                newBranches.push(branchName);
            }
        }
    });
    
    console.log("New branches collected:", newBranches);
    return newBranches;
}

function saveperform() {
    var Id = $('#ass_id').val();
    var year = $('#year').val();
    var objectives = $("#objectives").val();
    var goals = $("#goals").val();

    if (year == "") {
        Swal.fire('Warning!', 'Please select a year', 'warning');
        return;
    }

    var form = $("#Form").closest("form");
    var formData = new FormData(form[0]);

    // ⭐ CRITICAL: Always collect and add new branches for both insert and update
    let newBranches = collectNewBranches();
    formData.append('new_branches', JSON.stringify(newBranches));

    if (Id > 0) {
        // ========== UPDATE MODE ==========
        a = true;

        console.log("UPDATE MODE - ass_id:", Id);
        console.log("New branches being sent:", newBranches);

        $.ajax({
            url: base_path + "admin/StudAssociation/updateAssociation",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                $('#btn_save').prop('disabled', true);
                $('#btn_save').html('<i class="fa fa-spinner fa-spin"></i> Loading');
            },
            success: function (response) {
                console.log("Server response:", response);
                
                // ⭐ Parse JSON response if it's a string
                let data = typeof response === 'string' ? JSON.parse(response) : response;
                
                $('#btn_save').prop('disabled', false);
                $('#btn_save').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');

                if (data.status === 'success') {
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: '<strong>Success!</strong>',
                        html: data.message || 'Data Updated Successfully',
                        showConfirmButton: false,
                        timer: 2000,
                        customClass: {
                            popup: 'custom-swal-popup',
                            icon: 'custom-swal-icon',
                            title: 'custom-swal-title',
                            htmlContainer: 'custom-swal-text'
                        }
                    }).then(() => { 
                        window.location.href = base_path + 'admin/StudAssociation/index'; 
                    });
                } else {
                    Swal.fire('Error!', data.message || 'Update failed', 'error');
                }
                
                a = false;
            },
            error: function(xhr, status, error) {
                console.error("AJAX Error:", error);
                console.error("Status:", status);
                console.error("Response:", xhr.responseText);
                
                $('#btn_save').prop('disabled', false);
                $('#btn_save').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
                
                Swal.fire('Error!', 'Failed to update data. Check console for details.', 'error');
                a = false;
            }
        });
    } else {
        // ========== INSERT MODE ==========
        a = true;

        console.log("INSERT MODE");
        console.log("New branches being sent:", newBranches);

        $.ajax({
            url: base_path + "admin/StudAssociation/insertAssociation",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                $('#btn_save').prop('disabled', true);
                $('#btn_save').html('<i class="fa fa-spinner fa-spin"></i> Loading');
            },
            success: function (response) {
                console.log("Server response:", response);
                
                // ⭐ Parse JSON response if it's a string
                let data = typeof response === 'string' ? JSON.parse(response) : response;
                
                $('#btn_save').prop('disabled', false);
                $('#btn_save').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');

                if (data.status === 'success') {
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: '<strong>Success!</strong>',
                        html: 'Data Submitted Successfully',
                        showConfirmButton: false,
                        timer: 2000,
                        customClass: {
                            popup: 'custom-swal-popup',
                            icon: 'custom-swal-icon',
                            title: 'custom-swal-title',
                            htmlContainer: 'custom-swal-text'
                        }
                    }).then(() => {
                        location.reload();
                    });
                } else {
                    Swal.fire('Error!', data.message || 'Submission failed', 'error');
                }

                a = false;
            },
            error: function(xhr, status, error) {
                console.error("AJAX Error:", error);
                console.error("Status:", status);
                console.error("Response:", xhr.responseText);
                
                $('#btn_save').prop('disabled', false);
                $('#btn_save').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
                
                Swal.fire('Error!', 'Failed to save data. Check console for details.', 'error');
                a = false;
            }
        });
    }
}