var a = false;

$(document).ready(function() {
    // Save button click handler
    $('#submit').click(function() {
        if (a === true) return;

        var isValid = true;

        // Check required fields
        $('#Form').find('input[required], textarea[required], select[required]').each(function() {
            if (!$(this).val() || !$(this).val().trim()) {
                $(this).addClass('custom-invalid');
                isValid = false;
            } else {
                $(this).removeClass('custom-invalid');
            }
        });

        // Validate that URL has been generated
        var generatedURL = $('#AwardedBy').val().trim();
        if (!generatedURL) {
            Swal.fire({
                icon: 'warning',
                title: 'Missing URL',
                text: 'Please generate the URL first before saving!'
            });
            isValid = false;
        }

        if (isValid) {
            saveperform();
        }
    });

    // Remove red border on valid input
    $('#Form').on('input change', 'input, textarea, select', function() {
        if ($(this).val() && $(this).val().trim() !== '') {
            $(this).removeClass('custom-invalid');
        }
    });

    // Generate URL button handler
    $('#generateURL').click(function() {
        var hostelType = $('#fkHostelType_id').val();
        var year = $('#FiniYear').val();
        var instituteId = $('input[name="fkInsitute_id"]').val();
        var baseUrl = base_path + 'admin/Survey/create';
        
        if (!instituteId || instituteId == '') {
            Swal.fire({
                icon: 'warning',
                title: 'Missing Selection',
                text: 'Please select Institute first!'
            });
            return;
        }
        
        if (!hostelType || hostelType == '') {
            Swal.fire({
                icon: 'warning',
                title: 'Missing Selection',
                text: 'Please select Hostel Type first!'
            });
            return;
        }
        
        if (!year || year == '') {
            Swal.fire({
                icon: 'warning',
                title: 'Missing Selection',
                text: 'Please select Academic Year first!'
            });
            return;
        }
        
        // Generate URL with parameters
        var generatedUrl = baseUrl + '/' + instituteId + '/' + hostelType + '/' + year;
        
        $('#AwardedBy').val(generatedUrl);
        
        Swal.fire({
            icon: 'success',
            title: 'URL Generated!',
            text: 'The survey URL has been generated. Click Save to store it.',
            showConfirmButton: true
        });
    });

    // Copy URL to clipboard
    $('#AwardedBy').click(function() {
        if ($(this).val()) {
            $(this).select();
            document.execCommand('copy');
            
            Swal.fire({
                icon: 'success',
                title: 'Copied!',
                text: 'URL copied to clipboard',
                timer: 1500,
                showConfirmButton: false
            });
        }
    });
});

function saveperform() {
    var instituteId = $('input[name="fkInsitute_id"]').val();
    var hostelType = $('#fkHostelType_id').val();
    var year = $('#FiniYear').val();
    var url = $('#AwardedBy').val();
    var urlId = $('#url_id').val(); // Get url_id value

    // **CRITICAL FIX**: Log to debug
    console.log('URL ID being sent:', urlId);
    console.log('URL ID type:', typeof urlId);
    console.log('URL ID length:', urlId ? urlId.length : 0);

    if (!instituteId || !hostelType || !year || !url) {
        Swal.fire({
            icon: 'warning',
            title: 'Missing Information',
            text: 'Please fill all required fields and generate URL'
        });
        return;
    }

    a = true;
    var form = $("#Form").closest("form");
    var formData = new FormData(form[0]);

    // **CRITICAL FIX**: Ensure url_id is properly appended
    if (urlId && urlId.trim() !== '' && urlId.trim() !== '0') {
        formData.append('url_id', urlId.trim());
        console.log('Update mode - url_id:', urlId.trim());
    } else {
        console.log('Insert mode - no url_id');
    }

    formData.append('fkInsitute_id', instituteId);
    formData.append('fkHostelType_id', hostelType);
    formData.append('FiniYear', year);
    formData.append('AwardedBy', url);
    formData.append('is_active', $('#is_active').is(':checked') ? 1 : 0);

    // **CRITICAL FIX**: Determine URL based on urlId
    var ajaxUrl = base_path + "admin/StudentFeedback/insertFeedbackURL";
    var successMessage = 'Data Submitted Successfully';
    
    // Check if urlId exists and is valid (not empty, not '0')
    if (urlId && urlId.trim() !== '' && urlId.trim() !== '0' && parseInt(urlId) > 0) {
        ajaxUrl = base_path + "admin/StudentFeedback/updateFeedbackURL";
        successMessage = 'Data Updated Successfully';
        console.log('Using UPDATE URL:', ajaxUrl);
    } else {
        console.log('Using INSERT URL:', ajaxUrl);
    }

    $.ajax({
        url: ajaxUrl,
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        dataType: 'json',
        beforeSend: function() {
            $('#submit').prop('disabled', true);
            $('#submit').html('<i class="fa-solid fa-spinner fa-spin"></i> Saving...');
        },
        success: function(response) {
            $('#submit').prop('disabled', false);
            $('#submit').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');

            console.log('Server response:', response);

            if (response.status) {
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: '<strong>Success!</strong>',
                    html: successMessage,
                    showConfirmButton: false,
                    timer: 2000,
                    customClass: {
                        popup: 'custom-swal-popup',
                        icon: 'custom-swal-icon',
                        title: 'custom-swal-title',
                        htmlContainer: 'custom-swal-text'
                    }
                }).then(() => {
                    window.location.href = base_path + 'admin/StudentFeedback/index';
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: response.message || 'Failed to save data'
                });
            }
            
            a = false;
        },
        error: function(xhr, status, error) {
            $('#submit').prop('disabled', false);
            $('#submit').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
            
            console.error('AJAX Error:', xhr.responseText);
            
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'An error occurred while saving: ' + error
            });
            
            a = false;
        }
    });
}