$(document).ready(function(){


    // Save Button Click Event
    $('#btn_save').click(function(){
        var stud_counseling_id = $('#stud_counseling_id').val();
        var fk_counseling_type = $('#fk_counseling_type').val();
        var counseling_date = $('#counseling_date').val();
        var fk_department = $('#fk_department').val();
        var fk_year = $('#fk_year').val();

        // Validation
        if(!fk_counseling_type){
            Swal.fire({
                icon: 'warning',
                title: 'Validation Error',
                text: 'Please select Counseling Type!',
            });
            return false;
        }

        if(!counseling_date){
            Swal.fire({
                icon: 'warning',
                title: 'Validation Error',
                text: 'Please select Counseling Date!',
            });
            return false;
        }

        if(!fk_department){
            Swal.fire({
                icon: 'warning',
                title: 'Validation Error',
                text: 'Please select Department!',
            });
            return false;
        }

        if(!fk_year){
            Swal.fire({
                icon: 'warning',
                title: 'Validation Error',
                text: 'Please select Academic Year!',
            });
            return false;
        }

        // Check if at least one student detail is added
        var hasStudentData = false;
        $('input[name="student_name[]"]').each(function(){
            if($(this).val().trim() !== ''){
                hasStudentData = true;
                return false;
            }
        });

        if(!hasStudentData){
            Swal.fire({
                icon: 'warning',
                title: 'Validation Error',
                text: 'Please add at least one student detail!',
            });
            return false;
        }

        var formData = new FormData($('#Form')[0]);

        if(stud_counseling_id > 0){
            // Update Mode
            $.ajax({
                url: base_path + "/admin/Student_Counseling/updatecounseling",
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                dataType: 'JSON',
                success: function(data){
                    if(data.status == 'success'){
                     Swal.fire({
  position: 'center',
  icon: 'success',
  title: '<strong>Success!</strong>',
  html: 'Data Updated Successfully',
  showConfirmButton: false,
  timer: 2000,
  customClass: {
    popup: 'custom-swal-popup',
    icon: 'custom-swal-icon',
    title: 'custom-swal-title',
    htmlContainer: 'custom-swal-text'
  }
})
.then(() => { window.location.href = base_path + 'admin/Student_Counseling/index';
 });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Failed to update Student Counseling!',
                        });
                    }
                },
                error: function(xhr, status, error){
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred: ' + error,
                    });
                }
            });
        } else {
            // Insert Mode
            $.ajax({
               url: base_path + "admin/Student_Counseling/insertcounseling",
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                dataType: 'JSON',
                success: function(data){
                    if(data.status == 'success'){
                       Swal.fire({
  position: 'center',
  icon: 'success',
  title: '<strong>Success!</strong>',
  html: 'Data saved Successfully',
  showConfirmButton: false,
  timer: 2000,
  customClass: {
    popup: 'custom-swal-popup',
    icon: 'custom-swal-icon',
    title: 'custom-swal-title',
    htmlContainer: 'custom-swal-text'
  }
})
.then(() => { window.location.href = base_path + 'admin/Student_Counseling/index';
 });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Failed to save Student Counseling!',
                        });
                    }
                },
                error: function(xhr, status, error){
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred: ' + error,
                    });
                }
            });
        }
    });

    // For Counseling Type Master
    $('#btn_save_type').click(function(){
        var counseling_name = $('#counseling_name').val();

        if(!counseling_name){
            Swal.fire({
                icon: 'warning',
                title: 'Validation Error',
                text: 'Please enter Counseling Type Name!',
            });
            return false;
        }

        var formData = new FormData($('#TypeForm')[0]);

        $.ajax({
            url: base_path + "admin/Student_Counseling/insert_counseling_type",
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'JSON',
            success: function(data){
                if(data.status == 'success'){
                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: 'Counseling Type saved successfully!',
                        showConfirmButton: false,
                        timer: 1500
                    }).then(function(){
                        location.reload();
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Failed to save Counseling Type!',
                    });
                }
            },
            error: function(xhr, status, error){
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'An error occurred: ' + error,
                });
            }
        });
    });
});