var a = false;

$(document).ready(function () {
    // Initialize Summernote editors
    initializeSummernote();
    
    // CRITICAL: Load existing content AFTER Summernote initialization
    // This ensures images, videos, and HTML are properly rendered
    loadExistingContent();
    
    // Form submit handler
    $('#submit').click(function (e) {
        e.preventDefault();
        
        if (a === true) return;

        var isValid = validateForm();

        if (isValid) {
            saveperform();
        } else {
            Swal.fire({
                icon: 'warning',
                title: 'Validation Error',
                text: 'Please fill all required fields',
                customClass: {
                    popup: 'custom-swal-popup'
                }
            });
        }
    });

    // Remove validation errors on input
    $('#Form').on('input change', 'input, textarea, select', function () {
        if ($(this).val().trim() !== '') {
            $(this).removeClass('custom-invalid');
        }
    });
});

/**
 * Initialize Summernote WYSIWYG Editor
 */
function initializeSummernote() {
    $('#Vision, #Mission').summernote({
        height: 300,
        minHeight: 200,
        maxHeight: 500,
        toolbar: [
            ['style', ['style']],
            ['font', ['bold', 'italic', 'underline', 'strikethrough', 'clear']],
            ['fontname', ['fontname']],
            ['fontsize', ['fontsize']],
            ['color', ['color']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['height', ['height']],
            ['table', ['table']],
            ['insert', ['link', 'picture', 'video']],
            ['view', ['fullscreen', 'codeview', 'help']]
        ],
        fontNames: ['Arial', 'Arial Black', 'Comic Sans MS', 'Courier New', 'Helvetica', 'Impact', 'Tahoma', 'Times New Roman', 'Verdana'],
        fontSizes: ['8', '9', '10', '11', '12', '14', '16', '18', '20', '24', '30', '36', '48'],
        placeholder: 'Enter content here...',
        callbacks: {
            onChange: function(contents, $editable) {
                // Remove validation error when content changes
                $(this).next('.note-editor').removeClass('custom-invalid');
            },
            onInit: function() {
                console.log('Summernote initialized');
            }
        }
    });
}

/**
 * Load Existing Content from Hidden Holders
 * This function loads content AFTER Summernote is initialized
 * ensuring proper rendering of images, videos, and other HTML elements
 */
function loadExistingContent() {
    // Small delay to ensure Summernote is fully initialized
    setTimeout(function() {
        // Load Vision content
        var visionContent = $('#vision-content-holder').html();
        if (visionContent && visionContent.trim() !== '') {
            $('#Vision').summernote('code', visionContent);
            console.log('Vision content loaded');
        }
        
        // Load Mission content
        var missionContent = $('#mission-content-holder').html();
        if (missionContent && missionContent.trim() !== '') {
            $('#Mission').summernote('code', missionContent);
            console.log('Mission content loaded');
        }
    }, 100);
}

/**
 * Validate Form Fields
 */
function validateForm() {
    var isValid = true;

    // Check required input and select fields
    $('#Form').find('input[required], select[required]').each(function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $(this).addClass('custom-invalid');
            isValid = false;
        } else {
            $(this).removeClass('custom-invalid');
        }
    });

    // Validate Vision field
    var visionContent = $('#Vision').summernote('code');
    var visionText = $('<div>').html(visionContent).text().trim();
    
    if (!visionText || visionText === '' || visionText === '<br>') {
        $('#Vision').next('.note-editor').addClass('custom-invalid');
        isValid = false;
    } else {
        $('#Vision').next('.note-editor').removeClass('custom-invalid');
    }

    // Validate Mission field
    var missionContent = $('#Mission').summernote('code');
    var missionText = $('<div>').html(missionContent).text().trim();
    
    if (!missionText || missionText === '' || missionText === '<br>') {
        $('#Mission').next('.note-editor').addClass('custom-invalid');
        isValid = false;
    } else {
        $('#Mission').next('.note-editor').removeClass('custom-invalid');
    }

    return isValid;
}

/**
 * Save Form Data (Insert or Update)
 */
function saveperform() {
    // Get form values
    var Id = $('#Vision_id').val();
    var fkbranch_id = $('#fkbranch_id').val();
    var finicial_Year = $('#finicial_Year').val();
    var Vision = $('#Vision').summernote('code');
    var Mission = $('#Mission').summernote('code');
    var fk_submenuId = $('#fk_submenuId').val();

    // Check if branch is selected
    if (!fkbranch_id || fkbranch_id == "") {
        Swal.fire({
            icon: 'warning',
            title: 'Required Field',
            text: 'Please select a branch/department'
        });
        return;
    }

    // Create FormData
    var formData = new FormData();
    formData.append('Vision_id', Id);
    formData.append('fkbranch_id', fkbranch_id);
    formData.append('finicial_Year', finicial_Year);
    formData.append('Vision', Vision);
    formData.append('Mission', Mission);
    formData.append('fk_submenuId', fk_submenuId);

    // Determine if this is an update or insert operation
    var isUpdate = (Id && Id > 0);
    var url = base_path + (isUpdate ? "admin/Vision/updateVision" : "admin/Vision/insertVision");
    var successMessage = isUpdate ? "Data Updated Successfully" : "Data Submitted Successfully";
    var buttonText = isUpdate ? "Update" : "Save";

    // Set flag to prevent double submission
    a = true;

    $.ajax({
        url: url,
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function () {
            $('#submit').prop('disabled', true);
            $('#submit').html('<i class="fa fa-spinner fa-spin"></i> Loading...');
        },
        success: function (response) {
            console.log('Response:', response);
            
            // Reset button
            $('#submit').prop('disabled', false);
            $('#submit').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;' + buttonText);

            // Parse response if it's a string
            var data = response;
            if (typeof response === 'string') {
                try {
                    data = JSON.parse(response);
                } catch (e) {
                    data = { status: 'success' };
                }
            }

            // Show success message
            Swal.fire({
                position: 'center',
                icon: 'success',
                title: '<strong>Success!</strong>',
                html: successMessage,
                showConfirmButton: false,
                timer: 2000,
                customClass: {
                    popup: 'custom-swal-popup',
                    icon: 'custom-swal-icon',
                    title: 'custom-swal-title',
                    htmlContainer: 'custom-swal-text'
                }
            }).then(() => {
                // Redirect to list page
                window.location.href = base_path + 'admin/Vision/index';
            });
            
            a = false;
        },
        error: function (xhr, status, error) {
            console.error('Error:', error);
            console.error('Response:', xhr.responseText);
            
            // Reset button
            $('#submit').prop('disabled', false);
            $('#submit').html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;' + buttonText);
            
            // Parse error response
            var errorMessage = 'Failed to save data. Please try again.';
            if (xhr.responseText) {
                try {
                    var errorData = JSON.parse(xhr.responseText);
                    if (errorData.message) {
                        errorMessage = errorData.message;
                    }
                } catch (e) {
                    errorMessage = xhr.responseText;
                }
            }
            
            Swal.fire({
                icon: 'error',
                title: 'Error!',
                text: errorMessage,
                customClass: {
                    popup: 'custom-swal-popup'
                }
            });
            
            a = false;
        }
    });
}

/**
 * Get Content from Summernote
 */
function getEditorContent(elementId) {
    return $('#' + elementId).summernote('code');
}

/**
 * Set Content to Summernote
 * Use this function when you need to programmatically set content
 */
function setEditorContent(elementId, content) {
    $('#' + elementId).summernote('code', content);
}

/**
 * Clear Form
 */
function clearForm() {
    $('#Form')[0].reset();
    $('#Vision').summernote('reset');
    $('#Mission').summernote('reset');
    $('#Vision_id').val('');
    
    // Remove all validation errors
    $('#Form').find('.custom-invalid').removeClass('custom-invalid');
}

/**
 * Load Vision Data for Edit via AJAX (Alternative method)
 * Use this if you want to load data via AJAX instead of PHP
 */
function loadVisionData(visionId) {
    if (!visionId || visionId <= 0) return;
    
    $.ajax({
        url: base_path + 'admin/Vision/getVisionDetails/' + visionId,
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data) {
                // Set form values
                $('#Vision_id').val(data.Vision_id);
                $('#fkbranch_id').val(data.fkbranch_id).trigger('change');
                $('#finicial_Year').val(data.finicial_Year).trigger('change');
                
                // Set editor content - this will properly render HTML including images and videos
                $('#Vision').summernote('code', data.Vision || '');
                $('#Mission').summernote('code', data.Mission || '');
                
                console.log('Vision data loaded via AJAX');
            }
        },
        error: function(xhr, status, error) {
            console.error('Error loading data:', error);
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Failed to load data'
            });
        }
    });
}