<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Leave extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Leave_model');
        
    }


   
     public function index()
	{
        $login_fac_id = $this->session->userdata('fac_id'); 
    $data['alldata'] = $this->Leave_model->getdetailview($login_fac_id); 
    $designation_id = $this->session->userdata('designation');
$data['designation'] = $designation_id; 

        
        
		$this->load->view('Leave/header_view');
        $this->load->view('Leave/Leave_detailview',$data);
		$this->load->view('Leave/footer_view');
	

	}

    
    public function Report()
{

      $login_fac_id = $this->session->userdata('fac_id');
        $data['facultyid'] = $this->Leave_model->getLoggedInFaculty($login_fac_id); 
            $data['yeardata']=$this->Leave_model->getyear();
 
    $this->load->view('Leave/header_view');
    $this->load->view('Leave/Leave_Report_view.php',$data);
    $this->load->view('Leave/footer_view');

}
         public function Verify()
	{
        $login_fac_id = $this->session->userdata('fac_id'); 
    $data['alldata'] = $this->Leave_model->getverifydetailview($login_fac_id); 
        
        
		$this->load->view('Leave/header_view');
        $this->load->view('Leave/Leave_verify',$data);
		$this->load->view('Leave/footer_view');
	

	}
    public function RegVerify()
	{
        $login_fac_id = $this->session->userdata('fac_id'); 
    $data['alldata'] = $this->Leave_model->getRegverifydetailview($login_fac_id); 
        
        
		$this->load->view('Leave/header_view');
        $this->load->view('Leave/Leave_RegVerify',$data);
		$this->load->view('Leave/footer_view');
	

	}
    public function PrincipleVerify()
	{
        $login_fac_id = $this->session->userdata('fac_id'); 
    $data['alldata'] = $this->Leave_model->getPrincipleverifydetailview($login_fac_id); 
        
        
		$this->load->view('Leave/header_view');
        $this->load->view('Leave/Leave_Principle',$data);
		$this->load->view('Leave/footer_view');
	

	}
public function create()
{
    $login_fac_id = $this->session->userdata('fac_id');
    $branch_id    = $this->session->userdata('branch_id'); // ✅ already set in login

    $data['facultyid'] = $this->Leave_model->getLoggedInFaculty($login_fac_id); 
    $data['faculty']   = $this->Leave_model->getBranchFaculty($branch_id, $login_fac_id); // ✅ Only same-branch faculty, exclude self
    $data['leave']     = $this->Leave_model->getallLeave();

    $this->load->view('Leave/header_view');
    $this->load->view('Leave/Leave_view', $data);
    $this->load->view('Leave/footer_view');
}
public function getfacLeaveData()
{
    $fac_id = $this->input->post('fac_id');
    $hod_status = $this->input->post('hod_status'); // 0, 1, 2 or null

    $this->load->model('Leave_model');
    $monthly_leave = $this->Leave_model->getfacLeaveData($fac_id, $hod_status);

    $html = '';
      $sr_no = 1; // initialize serial number

    if (!empty($monthly_leave)) {
        foreach ($monthly_leave as $row) {
            $html .= '<tr>
            <td>' . $sr_no++ . '</td>
            <td>' . $row->LeaveApp_id  . '</td>
                <td>' . $row->altFaculty . '</td>
                <td>' . $row->leave_name . '</td>
                <td>' . date('d-m-Y', strtotime($row->Leave_from)) . '</td>
                <td>' . date('d-m-Y', strtotime($row->Leave_to)) . '</td>
                <td>' . $row->No_of_days . '</td>
                <td>' . $row->ApprovedDays . '</td>
                <td>' . date('d-m-Y', strtotime($row->created_date)) . '</td>
                <td style="text-align:center; background-color:' . $row->hod_color . ';">' . $row->hod_status . '</td>
                <td style="text-align:center; background-color:' . $row->reg_color . ';">' . $row->reg_status . '</td>
                <td style="text-align:center; background-color:' . $row->princ_color . ';">' . $row->princ_status . '</td>
            </tr>';
        }
    } else {
        $html .= '<tr><td colspan="11" class="text-center text-danger">No leave records found for selected condition.</td></tr>';
    }

    echo $html;
}

public function fetchMonthlyLeaveTable()
{
    $fac_id = $this->input->post('fac_id');
    $month = $this->input->post('month'); // format: YYYY-
     $hod_status = $this->input->post('hod_status'); 

    $this->load->model('Leave_model');
    $monthly_leave = $this->Leave_model->getMonthlyLeaveData($fac_id, $month,$hod_status);

    $html = '';
      $sr_no = 1; // initialize serial number

    if (!empty($monthly_leave)) {
        foreach ($monthly_leave as $row) {
        
        

            $html .= '<tr>
               <td>' . $sr_no++ . '</td>
                <td>' . $row->LeaveApp_id  . '</td>
                <td>' . $row->altFaculty . '</td>
                <td>' . $row->leave_name . '</td>
                <td>' . date('d-m-Y', strtotime($row->Leave_from)) . '</td>
                <td>' . date('d-m-Y', strtotime($row->Leave_to)) . '</td>
                <td>' . $row->No_of_days . '</td>
                <td>' . $row->ApprovedDays . '</td>
                <td>' . date('d-m-Y', strtotime($row->created_date)) . '</td>
         <td style="text-align:center; background-color:' . $row->hod_color . ';">' . $row->hod_status . '</td>
<td style="text-align:center; background-color:' . $row->reg_color . ';">' . $row->reg_status . '</td>
<td style="text-align:center; background-color:' . $row->princ_color . ';">' . $row->princ_status . '</td>
 
            </tr>';
        }
    } else {
        $html .= '<tr><td colspan="11" class="text-center text-danger">No leave records found for selected month.</td></tr>';
    }

    echo $html;
}

public function fetchDatewiseLeaveTable()
{
    $fac_id = $this->input->post('fac_id');
    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
     $hod_status = $this->input->post('hod_status'); // 0, 1, 2 or null

    $this->load->model('Leave_model');
    $datewise_leave = $this->Leave_model->getDatewiseLeaveData($fac_id, $start_date, $end_date,$hod_status);

    $html = '';
      $sr_no = 1; // initialize serial number

    if (!empty($datewise_leave)) {
        foreach ($datewise_leave as $row) {
          
     

            $html .= '<tr>
            <td>' . $sr_no++ . '</td>
            <td>' . $row->LeaveApp_id  . '</td>
                <td>' . $row->altFaculty . '</td>
                <td>' . $row->leave_name . '</td>
                <td>' . date('d-m-Y', strtotime($row->Leave_from)) . '</td>
                <td>' . date('d-m-Y', strtotime($row->Leave_to)) . '</td>
                <td>' . $row->No_of_days . '</td>
                <td>' . $row->ApprovedDays . '</td>
                <td>' . date('d-m-Y', strtotime($row->created_date)) . '</td>
        <td style="text-align:center; background-color:' . $row->hod_color . ';">' . $row->hod_status . '</td>
<td style="text-align:center; background-color:' . $row->reg_color . ';">' . $row->reg_status . '</td>
<td style="text-align:center; background-color:' . $row->princ_color . ';">' . $row->princ_status . '</td>
 
            </tr>';
        }
    } else {
        $html .= '<tr><td colspan="11" class="text-center text-danger">No leave records found for selected date range.</td></tr>';
    }

    echo $html;
}

public function fetchYearlyLeaveTable()
{
    $fac_id = $this->input->post('fac_id');
    $year_id = $this->input->post('year_id');
    $hod_status = $this->input->post('hod_status'); // 0, 1, 2 or null

    $this->load->model('Leave_model');
    $yearly_leave = $this->Leave_model->getYearlyLeaveData($fac_id, $year_id, $hod_status);

    $html = '';
    $sr_no = 1; // initialize serial number

    if (!empty($yearly_leave)) {
        foreach ($yearly_leave as $row) {
            $html .= '<tr>
                <td>' . $sr_no++ . '</td>
                <td>' . $row->LeaveApp_id  . '</td>
                <td>' . $row->altFaculty . '</td>
                <td>' . $row->leave_name . '</td>
                <td>' . date('d-m-Y', strtotime($row->Leave_from)) . '</td>
                <td>' . date('d-m-Y', strtotime($row->Leave_to)) . '</td>
                <td>' . $row->No_of_days . '</td>
                <td>' . $row->ApprovedDays . '</td>
                <td>' . date('d-m-Y', strtotime($row->created_date)) . '</td>
                <td style="text-align:center; background-color:' . $row->hod_color . ';">' . $row->hod_status . '</td>
                <td style="text-align:center; background-color:' . $row->reg_color . ';">' . $row->reg_status . '</td>
                <td style="text-align:center; background-color:' . $row->princ_color . ';">' . $row->princ_status . '</td>
            </tr>';
        }
    } else {
        $html .= '<tr><td colspan="12" class="text-center text-danger">No leave records found for selected financial year.</td></tr>';
    }

    echo $html;
}



public function insertLeave() 
{ 
    $fkfac_id    = $this->input->post('fkfac_id'); 
    $LeaveType   = $this->input->post('LeaveType'); 
    $No_of_days  = (int)$this->input->post('No_of_days'); 

    // Get current active financial year
    $finiYear = $this->db->select('finiYear_id')
                         ->from('finiyear_master')
                         ->where('Active_Deactive', 1)
                         ->get()
                         ->row();

    if (!$finiYear) {
        echo json_encode(['status' => false, 'message' => 'No active financial year found.']);
        return;
    }

    $finiYear_id = $finiYear->finiYear_id;

    // Count used leave from leaveapp_master for the same year
    $this->db->select('SUM(No_of_days) as total'); 
    $this->db->from('leaveapp_master'); 
    $this->db->where('fkfac_id', $fkfac_id); 
    $this->db->where('LeaveType', $LeaveType); 
    $this->db->where('HOD_Approval !=', 2); 
    $this->db->where('REG_Approval !=', 2); 
    $this->db->where('Princ_Approval !=', 2); 
    $this->db->where('finicial_Year', $finiYear_id);  // 👈 Year-wise filter
    $used_from_leaveapp = (int)($this->db->get()->row()->total ?? 0); 

    // Count from reg_fac_leave_master for same year
    $this->db->select('SUM(no_of_LeaveDays) as total'); 
    $this->db->from('reg_fac_leave_master'); 
    $this->db->where('fkfac_id', $fkfac_id); 
    $this->db->where('fkleaveCat_id', $LeaveType); 
    $this->db->where('fkfiniYear_id', $finiYear_id);  // 👈 Year-wise filter
    $used_from_reg_master = (int)($this->db->get()->row()->total ?? 0); 

    $total_used = $used_from_leaveapp + $used_from_reg_master;

    // Max allowed for this faculty (based on joining month logic — same as before)
    $this->db->select('f.joining_date, fy.Active_Deactive'); 
    $this->db->from('faculty_master f'); 
    $this->db->join('finiyear_master fy', 'f.finicial_Year = fy.finiYear_id', 'left'); 
    $this->db->where('f.fac_id', $fkfac_id); 
    $faculty = $this->db->get()->row(); 

    $joiningMonth = null; 
    if ($faculty && $faculty->Active_Deactive == 1 && $faculty->joining_date) { 
        $joiningMonth = date('n', strtotime($faculty->joining_date));   
    } 

    $monthColumn = 'July';  
    if ($joiningMonth) { 
        $months = [1=>'January', 2=>'February', 3=>'March', 4=>'April', 5=>'May', 6=>'June', 7=>'July', 8=>'August', 9=>'September', 10=>'October', 11=>'November', 12=>'December']; 
        $monthColumn = $months[$joiningMonth] ?? 'July'; 
    } 

    $cat = $this->db 
                ->select("leave_name, `$monthColumn` AS max_leave") 
                ->where('leaveCat_id', $LeaveType) 
                ->get('leavecat_master') 
                ->row(); 

    $max = (int)($cat->max_leave ?? 0); 
    $leaveName = ($cat->leave_name ?? 'This'); 

    if ($max > 0 && ($total_used + $No_of_days) > $max) {
        $remaining = $max - $total_used;
        echo json_encode([
            'status'  => false,
            'message' => "{$leaveName} limit exceeded. You have used {$total_used} out of {$max} days. Only {$remaining} days remaining."
        ]);
        return;
    }

    // Set all insert fields
    $fields = [ 
        'fkfac_id'         => $fkfac_id, 
        'LeaveType'        => $LeaveType, 
        'fkAlternative_id' => $this->input->post('fkAlternative_id'), 
        'Leave_from'       => $this->input->post('Leave_from'), 
        'Leave_to'         => $this->input->post('Leave_to'), 
        'No_of_days'       => 0, 
        'ApprovedDays'     => $No_of_days, 
        'Leave_Reas'       => $this->input->post('Leave_Reas'), 
        'created_date'     => date('Y-m-d H:i:s'), 
        'created_by'       => $this->session->userdata('fac_id'),
        'finicial_Year'    => $finiYear_id 
    ]; 

    // Upload file if exists
    if (!empty($_FILES['Leave_Document']['name'])) { 
        $config['upload_path']   = './Assets/Leaveapplication/'; 
        $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf|doc|docx|xls|xlsx';
        $config['max_size']      = 2048; 
        $config['file_name']     = time() . '_' . $_FILES['Leave_Document']['name']; 

        $this->load->library('upload', $config); 

        if ($this->upload->do_upload('Leave_Document')) { 
            $uploadData = $this->upload->data(); 
            $fields['Leave_Document'] = $uploadData['file_name']; 
        } else { 
            echo json_encode([ 
                'status'  => false, 
                'message' => 'Document upload failed: Max 2 MB allowed.'
            ]); 
            return; 
        } 
    } 

    $this->Leave_model->insertdata($fields); 

    echo json_encode([ 
        'status'  => true, 
        'message' => 'Leave applied successfully!' 
    ]); 
}


    public function update()
	{
		$id=$this->uri->segment(4);
       	$data['data']=$this->Leave_model->getbyid($id);
      $login_fac_id = $this->session->userdata('fac_id');
    $branch_id    = $this->session->userdata('branch_id'); 

    $data['facultyid'] = $this->Leave_model->getLoggedInFaculty($login_fac_id); 
    $data['faculty']   = $this->Leave_model->getBranchFaculty($branch_id, $login_fac_id); // ✅ Only same-branch faculty, exclude self
    $data['leave']     = $this->Leave_model->getallLeave();

         
        //  echo "<pre>";
        // print_r($data);
	$this->load->view('Leave/header_view');
		$this->load->view('Leave/Leave_view',$data);
		$this->load->view('Leave/footer_view');
       
           
	}
    public function updateverify()
	{
		$id=$this->uri->segment(3);
       	$data['data']=$this->Leave_model->getbyiddata($id);
     $login_fac_id = $this->session->userdata('fac_id');
    $branch_id    = $this->session->userdata('branch_id'); // ✅ already set in login
    
    $data['hod_approved'] = ($data['data'][0]->HOD_Approval == 1);
$data['reg_approved'] = ($data['data'][0]->REG_Approval == 1);

    
//    $data['facultyid'] = $this->Leave_model->getLoggedInFacultydata($branch_id,$login_fac_id); 
//     $data['faculty']   = $this->Leave_model->getBranchFaculty($branch_id, $login_fac_id); // ✅ Only same-branch faculty, exclude self
//     $data['leave']     = $this->Leave_model->getallLeave();

// print_r($data['data']);
         
        //  echo "<pre>";
        // print_r($data);
	$this->load->view('Leave/header_view');
		$this->load->view('Leave/Leave_verifyupdate',$data);
		$this->load->view('Leave/footer_view');
       
           
	}
    public function updateRegverify()
	{
		$id=$this->uri->segment(3);
       	$data['data']=$this->Leave_model->getbyiddata($id);
     $login_fac_id = $this->session->userdata('fac_id');
    $branch_id    = $this->session->userdata('branch_id'); // ✅ already set in login
    
    $data['hod_approved'] = ($data['data'][0]->HOD_Approval == 1);
$data['reg_approved'] = ($data['data'][0]->REG_Approval == 1);

    
//    $data['facultyid'] = $this->Leave_model->getLoggedInFacultydata($branch_id,$login_fac_id); 
//     $data['faculty']   = $this->Leave_model->getBranchFaculty($branch_id, $login_fac_id); // ✅ Only same-branch faculty, exclude self
//     $data['leave']     = $this->Leave_model->getallLeave();

// print_r($data['data']);
         
        //  echo "<pre>";
        // print_r($data);
	$this->load->view('Leave/header_view');
		$this->load->view('Leave/Leave_Regverifyupdate',$data);
		$this->load->view('Leave/footer_view');
       
           
	}
       public function updatePricipleverify()
	{
		$id=$this->uri->segment(3);
       	$data['data']=$this->Leave_model->getbyiddata($id);
     $login_fac_id = $this->session->userdata('fac_id');
    $branch_id    = $this->session->userdata('branch_id'); // ✅ already set in login
    
    $data['hod_approved'] = ($data['data'][0]->HOD_Approval == 1);
$data['reg_approved'] = ($data['data'][0]->REG_Approval == 1);

    
//    $data['facultyid'] = $this->Leave_model->getLoggedInFacultydata($branch_id,$login_fac_id); 
//     $data['faculty']   = $this->Leave_model->getBranchFaculty($branch_id, $login_fac_id); // ✅ Only same-branch faculty, exclude self
//     $data['leave']     = $this->Leave_model->getallLeave();

// print_r($data['data']);
         
        //  echo "<pre>";
        // print_r($data);
	$this->load->view('Leave/header_view');
		$this->load->view('Leave/Leave_Principleverify',$data);
		$this->load->view('Leave/footer_view');
       
           
	}


public function updateLeave()
{
    $LeaveApp_id    = $this->input->post('LeaveApp_id');
    $fkfac_id       = $this->input->post('fkfac_id');
    $LeaveType      = $this->input->post('LeaveType');
    $No_of_days     = (int)$this->input->post('No_of_days');

    // Get current active financial year
    $finiYear = $this->db->select('finiYear_id')
                         ->from('finiyear_master')
                         ->where('Active_Deactive', 1)
                         ->get()
                         ->row();

    if (!$finiYear) {
        echo json_encode(['status' => false, 'message' => 'No active financial year found.']);
        return;
    }

    $finiYear_id = $finiYear->finiYear_id;

    // Get previous leave days to exclude them from re-calculation
    $previousData = $this->db->select('No_of_days')
        ->where('LeaveApp_id', $LeaveApp_id)
        ->get('leaveapp_master')
        ->row();
    $old_days = (int)($previousData->No_of_days ?? 0);

    // Leave used in current year from leaveapp_master
    $this->db->select('SUM(No_of_days) as total');
    $this->db->from('leaveapp_master');
    $this->db->where('fkfac_id', $fkfac_id);
    $this->db->where('LeaveType', $LeaveType);
    $this->db->where('LeaveApp_id !=', $LeaveApp_id);
    $this->db->where('finicial_Year', $finiYear_id); // 👈 financial year filter
    $this->db->where('HOD_Approval !=', 2);
    $this->db->where('REG_Approval !=', 2);
    $this->db->where('Princ_Approval !=', 2);
    $used_from_leaveapp = (int)($this->db->get()->row()->total ?? 0);

    // Leave used in current year from reg_fac_leave_master
    $this->db->select('SUM(no_of_LeaveDays) as total');
    $this->db->from('reg_fac_leave_master');
    $this->db->where('fkfac_id', $fkfac_id);
    $this->db->where('fkleaveCat_id', $LeaveType);
    $this->db->where('fkfiniYear_id', $finiYear_id); // 👈 financial year filter
    $used_from_reg_master = (int)($this->db->get()->row()->total ?? 0);

    $used = $used_from_leaveapp + $used_from_reg_master;

    // Joining month logic
    $this->db->select('f.joining_date, fy.Active_Deactive');
    $this->db->from('faculty_master f');
    $this->db->join('finiyear_master fy', 'f.finicial_Year = fy.finiYear_id', 'left');
    $this->db->where('f.fac_id', $fkfac_id);
    $faculty = $this->db->get()->row();

    $joiningMonth = null;
    if ($faculty && $faculty->Active_Deactive == 1 && $faculty->joining_date) {
        $joiningMonth = date('n', strtotime($faculty->joining_date));
    }

    $monthColumn = 'July'; 
    if ($joiningMonth) {
        $months = [1=>'January', 2=>'February', 3=>'March', 4=>'April', 5=>'May', 6=>'June', 7=>'July', 8=>'August', 9=>'September', 10=>'October', 11=>'November', 12=>'December'];
        $monthColumn = $months[$joiningMonth] ?? 'July';
    }

    $cat = $this->db
        ->select("leave_name, `$monthColumn` AS max_leave")
        ->where('leaveCat_id', $LeaveType)
        ->get('leavecat_master')
        ->row();

    $max = (int)($cat->max_leave ?? 0);
    $leaveName = ($cat->leave_name ?? 'This Leave');

    $totalAfterUpdate = $used + $No_of_days;

    if ($max > 0 && $totalAfterUpdate > $max) {
        $remaining = $max - $used;
        echo json_encode([
            'status'  => false,
            'message' => "{$leaveName} limit exceeded. You have used {$used} out of {$max} days. Only {$remaining} days remaining."
        ]);
        return;
    }

    // Prepare fields to update
    $fields = [
        'LeaveApp_id'      => $LeaveApp_id,
        'fkfac_id'         => $fkfac_id,
        'LeaveType'        => $LeaveType,
        'fkAlternative_id' => $this->input->post('fkAlternative_id'),
        'Leave_from'       => $this->input->post('Leave_from'),
        'Leave_to'         => $this->input->post('Leave_to'),
        'No_of_days'       => 0,
        'ApprovedDays'     => $No_of_days, 
        'Leave_Reas'       => $this->input->post('Leave_Reas'),
        'modified_date'    => date('Y-m-d H:i:s'),
        'modified_by'      => $this->session->userdata('fac_id'),
        'finicial_Year'    => $finiYear_id // 👈 added year to update also
    ];

    // Approval updates
    if ($this->input->post('hod_approval') !== null) {
        $fields['HOD_Approval'] = $this->input->post('hod_approval');
        $fields['HOD_date']     = date('Y-m-d H:i:s');
        $fields['HOD_RejReas']  = $this->input->post('HOD_RejReas');
    }
    if ($this->input->post('reg_approval') !== null) {
        $fields['REG_Approval'] = $this->input->post('reg_approval');
        $fields['REG_date']     = date('Y-m-d H:i:s');
        $fields['REG_RejReas']  = $this->input->post('REG_RejReas');
    }
    if ($this->input->post('princ_approval') !== null) {
        $fields['Princ_Approval'] = $this->input->post('princ_approval');
        $fields['Princ_date']     = date('Y-m-d H:i:s');
        $fields['Princ_RejReas']  = $this->input->post('Princ_RejReas');
    }

    // File upload (same as insert)
    if (!empty($_FILES['Leave_Document']['name'])) {
        $config['upload_path']   = './Assets/Leaveapplication/';
        $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf|doc|docx|xls|xlsx';
        $config['max_size']      = 2048;
        $config['file_name']     = time() . '_' . $_FILES['Leave_Document']['name'];

        $this->load->library('upload', $config);

        if ($this->upload->do_upload('Leave_Document')) {
            $uploadData = $this->upload->data();
            $fields['Leave_Document'] = $uploadData['file_name'];
        } else {
            echo json_encode([
                'status'  => false,
                'message' => 'Document upload failed: Maximum file size allowed is 2 MB.'
            ]);
            return;
        }
    }

    $this->Leave_model->update($fields);

    echo json_encode([
        'status'  => true,
        'message' => 'Leave updated successfully!'
    ]);
}


public function getleavedata() {
    $fac_id = $this->input->post('fkfac_id');
    $data = $this->Leave_model->getAllLeaveStatus($fac_id);


$extraDays = $this->Leave_model->getExtraLeaveDays($fac_id);

foreach ($data as $group) {


    $mainLeaveCount = $group['used'];


    $extraLeaveCount = 0;
    if (!empty($extraDays[$group['id']])) {
        foreach ($extraDays[$group['id']] as $row) {
            $extraLeaveCount += (int)$row->no_of_LeaveDays;
        }
    }

    $totalUsed = $mainLeaveCount + $extraLeaveCount;

    echo "<div class='table-responsive'><table class='table table-bordered'>";
    echo "<tr><td colspan='8'>
            <h5 style='background-color:#d4edda;padding:8px;border:1px solid green;'>
                {$group['name']} - No Of Leaves ({$totalUsed}/{$group['max']})
            </h5>
          </td></tr>";

    echo "<thead>
            <tr>
                <th style='border-bottom:1px solid black !important'>Alternative Faculty</th>
                <th style='border-bottom:1px solid black !important'>Apply Date</th>
                <th style='border-bottom:1px solid black !important'>From Date</th>
                <th style='border-bottom:1px solid black !important'>To Date</th>
                <th style='border-bottom:1px solid black !important'>Approve Days</th>
                <th style='border-bottom:1px solid black !important'>Apply Days</th>
                <th style='border-bottom:1px solid black !important'>Leave Reason</th>
                <th style='border-bottom:1px solid black !important'>Status</th>
            </tr>
          </thead><tbody>";

    if (empty($group['records'])) {
        echo "<tr><td colspan='8' class='text-center'>No Records</td></tr>";
    } else {
        foreach ($group['records'] as $rec) {

            $status = '';
            if ($rec->HOD_Approval == 0) $status = 'HOD_Processing';
            elseif ($rec->HOD_Approval == 1) $status = 'HOD_Approved';
            elseif ($rec->HOD_Approval == 2) $status = 'HOD_Rejected';

            if ($rec->HOD_Approval == 1) {
                if ($rec->REG_Approval == 0) $status = 'Registrar_Processing';
                elseif ($rec->REG_Approval == 1) $status = 'Registrar_Approved';
                elseif ($rec->REG_Approval == 2) $status = 'Registrar_Rejected';
            }

            if ($rec->HOD_Approval == 1 && $rec->REG_Approval == 1) {
                if ($rec->Princ_Approval == 0) $status = 'Principal_Processing';
                elseif ($rec->Princ_Approval == 1) $status = 'Principal_Approved';
                elseif ($rec->Princ_Approval == 2) $status = 'Principal_Rejected';
            }

            $rowStyle = ($rec->HOD_Approval == 0) ? "style='background-color:#fff3cd;'" :
                         (($rec->HOD_Approval == 2 || $rec->REG_Approval == 2 || $rec->Princ_Approval == 2) ? "style='background-color:#f8d7da;'" : "");

            echo "<tr $rowStyle>";
            echo "<td>{$rec->altFaculty}</td>";
            echo "<td>" . date("d-m-Y", strtotime($rec->created_date)) . "</td>";
            echo "<td>" . date("d-m-Y", strtotime($rec->Leave_from)) . "</td>";
            echo "<td>" . date("d-m-Y", strtotime($rec->Leave_to)) . "</td>";
            echo "<td>{$rec->No_of_days}</td>";
            echo "<td>{$rec->ApprovedDays}</td>";

            echo "<td>{$rec->Leave_Reas}</td>";
            echo "<td><b>{$status}</b></td>";
            echo "</tr>";
        }
    }

    if (!empty($extraDays[$group['id']])) {
     echo "<tr><td colspan='8'>
        <h5 style='margin-top:10px;color:red;'>
           Late Mark Leave Details-({$group['name']}) 
        </h5>
      </td></tr>";


        echo "<tr>
          <th style='border-bottom:1px solid black !important'>Leave Date</th>
           <th style='border-bottom:1px solid black !important'>Late Day</th>
                <th style='border-bottom:1px solid black !important'>No. of Days</th>
    
                <th colspan='2' style='border-bottom:1px solid black !important'>Remark</th>
               
    
                <th colspan='3' style='border-bottom:1px solid black !important'>Status</th>
              </tr>";

        foreach ($extraDays[$group['id']] as $row) {
            echo "<tr style='background-color:#f0f8ff;'>";
              echo "<td>" . date("d-m-Y", strtotime($row->Leave_date)) . "</td>";
               echo "<td>" . (!empty($row->Lateday) ? $row->Lateday : '-') . "</td>";
            echo "<td>{$row->no_of_LeaveDays}</td>";
          
            echo "<td colspan='2'>" . (!empty($row->LateMark) ? $row->LateMark : '-') . "</td>";
    
            echo "<td colspan='3'>This leave added by Registrar</td>";
            echo "</tr>";
        }
    }

    echo "</tbody></table></div><br>";
}



}


public function getTotalLeaveSummary()
{
    $fac_id = $this->input->post('fac_id');
    $data = $this->Leave_model->getAllLeaveStatus($fac_id);
    $extraDays = $this->Leave_model->getExtraLeaveDays($fac_id);

    $summary = [];

    foreach ($data as $group) {
        $mainLeaveCount = $group['used'];
        $extraLeaveCount = 0;

        if (!empty($extraDays[$group['id']])) {
            foreach ($extraDays[$group['id']] as $row) {
                $extraLeaveCount += (int)$row->no_of_LeaveDays;
            }
        }

        $totalUsed = $mainLeaveCount + $extraLeaveCount;
        $availableLeaves = $group['max'] - $totalUsed;

        $summary[] = [
            'leave_name'        => $group['name'],
            'total_leaves'      => $group['max'],
            'used_leaves'       => $mainLeaveCount,
            'late_mark_leaves'  => $extraLeaveCount,
            'available_leaves'  => max(0, $availableLeaves)
        ];
    }

    echo json_encode($summary);
}





public function getLeaveByStatus()
{
    $fkfac_id = $this->input->post('fkfac_id');
    $status_type = $this->input->post('status_type');

    $this->load->model('Leave_model');
    $leaves = $this->Leave_model->getLeavesByStatus($fkfac_id, $status_type);

    if (!empty($leaves)) {
        echo '<div class="table-responsive"><table class="table table-bordered">
                <thead>
                    <tr>
                        <th>From Date</th>
                        <th>To Date</th>
                       
                        <th>Approve Days</th>
                         <th>Apply Days</th>
                        <th>Leave Type</th>
                        <th>Reason</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>';

        foreach ($leaves as $rec) {
            $status = '';
            if ($rec->HOD_Approval == 0) $status = 'HOD_Processing';
            elseif ($rec->HOD_Approval == 1) $status = 'HOD_Approved';
            elseif ($rec->HOD_Approval == 2) $status = 'HOD_Rejected';

            if ($rec->HOD_Approval == 1) {
                if ($rec->REG_Approval == 0) $status = 'Registrar_Processing';
                elseif ($rec->REG_Approval == 1) $status = 'Registrar_Approved';
                elseif ($rec->REG_Approval == 2) $status = 'Registrar_Rejected';
            }

            if ($rec->HOD_Approval == 1 && $rec->REG_Approval == 1) {
                if ($rec->Princ_Approval == 0) $status = 'Principal_Processing';
                elseif ($rec->Princ_Approval == 1) $status = 'Principal_Approved';
                elseif ($rec->Princ_Approval == 2) $status = 'Principal_Rejected';
            }

            // Row coloring same like existing code
            $rowStyle = ($rec->HOD_Approval == 0) ? "style='background-color:#fff3cd;'" :
                        (($rec->HOD_Approval == 2 || $rec->REG_Approval == 2 || $rec->Princ_Approval == 2) ? "style='background-color:#f8d7da;'" : "");

            echo "<tr $rowStyle>";
            echo "<td>" . date("d-m-Y", strtotime($rec->Leave_from)) . "</td>";
            echo "<td>" . date("d-m-Y", strtotime($rec->Leave_to)) . "</td>";
            echo "<td>{$rec->No_of_days}</td>";
            echo "<td>{$rec->ApprovedDays}</td>";
            echo "<td>{$rec->leave_name}</td>";
            echo "<td>{$rec->Leave_Reas}</td>";
            echo "<td><b>{$status}</b></td>";
            echo "</tr>";
        }

        echo '</tbody></table></div>';

    } else {
        echo '<p class="text-center">Entry Not Found</p>';
    }
}
}

	
	
   
   

   
