<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class HOD_branchleave extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('HOD_branchleave_model');
        
    }


   
   
    public function create()
	{
        // $data['facdata']=$this->HOD_branchleave_model->getfaculty();

        $data['yeardata']=$this->HOD_branchleave_model->getyear();

         $active_id = $this->session->userdata('active_id');
    $branchInfo = $this->HOD_branchleave_model->getActiveBranchFromSession($active_id);
        $data['facdata'] = $this->HOD_branchleave_model->getfaculty($branchInfo['branch_id']);

    $data['branch_id'] = $branchInfo['branch_id'];
    $data['branch_name'] = $branchInfo['branch_name'];

        //  echo "<pre>";
        // print_r($data);

		$this->load->view('Heads/header_view');
		$this->load->view('Heads/HOD_branchleave_view',$data);
		$this->load->view('Heads/footer_view');
	

	}


 
public function fetchLeaveReport()
{
    $faculty_id = $this->input->post('fkfac');
    $branch_id  = $this->input->post('fkbranch_id');
    $month      = $this->input->post('month');
    $year       = $this->input->post('year');
    $from_date  = $this->input->post('from_date');
    $to_date    = $this->input->post('to_date');

    // Step 1: Only branch is mandatory
    if (!empty($branch_id)) {

        // Step 2: Decide which filter to use
        if (!empty($month)) {
            $data = $this->HOD_branchleave_model->getLeaveMonthly($faculty_id, $branch_id, $month);
        } elseif (!empty($year)) {
            $data = $this->HOD_branchleave_model->getLeaveYearly($faculty_id, $branch_id, $year);
        } elseif (!empty($from_date) && !empty($to_date)) {
            $data = $this->HOD_branchleave_model->getLeaveDateRange($faculty_id, $branch_id, $from_date, $to_date);
        } else {
            // No filter — show all for branch (optional step)
            $data = $this->HOD_branchleave_model->getAllLeaveByBranch($branch_id); 
        }

        echo json_encode(['status' => 1, 'data' => $data]);

    } else {
        echo json_encode(['status' => 0, 'message' => 'Branch not selected']);
    }
}


public function getTotalLeaveSummary()
{
    $fac_id = $this->input->post('fkfac');
   
    if (!$fac_id) {
        echo json_encode(['error' => 'Invalid faculty ID']);
        return;
    }
 
    $data = $this->HOD_branchleave_model->getAllLeaveStatus($fac_id);
    $extraDays = $this->HOD_branchleave_model->getExtraLeaveDays($fac_id);
 
    $summary = [];
 
    foreach ($data as $group) {
        $mainLeaveCount = $group['used'];
        $extraLeaveCount = 0;
 
        if (!empty($extraDays[$group['id']])) {
            foreach ($extraDays[$group['id']] as $row) {
                $extraLeaveCount += (int)$row->no_of_LeaveDays;
            }
        }
 
        $totalUsed = $mainLeaveCount + $extraLeaveCount;
        $availableLeaves = $group['max'] - $totalUsed;
 
        $summary[] = [
            'leave_name'        => $group['name'],
            'total_leaves'      => $group['max'],
            'used_leaves'       => $mainLeaveCount,
            'late_mark_leaves'  => $extraLeaveCount,
            'available_leaves'  => max(0, $availableLeaves)
        ];
    }
 
    echo json_encode($summary);
}

}
