<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class New_login extends CI_Controller {
    
    public function __construct()
    {
        parent::__construct();
        // Load the model that contains the login logic
        $this->load->model('New_login_model');
    }
    
    // Default function to show the login form
    public function index()
    {
        $this->load->view('New_login_view');
    }
    
public function login_validate()
{
    $this->output->set_content_type('application/json');

    $username = $this->input->post('username');
    $password = $this->input->post('password');

    $data = $this->New_login_model->AdminLogin($username, $password);

    if (!empty($data)) {
        $newdata = array(
            'active_id' => $data->active_id,
            'Username' => $data->Username,
            'logged_in' => TRUE,
            'branch_id' => $data->fkbranch_id,
            'institute_id' => $data->fkInstitu_id,
            'department_id' => $data->fkdep_id,
            'designation' => $data->desig_id,
            'fac_id'        => $data->fkfac_id 
        );
        $this->session->set_userdata($newdata);

        echo json_encode([
            'status' => 1,
            'active_id' => $data->active_id,
            'designation' => $data->desig_id,
              'Institute' => $data->fkInstitu_id,
                'Branch' => $data->fkbranch_id,
                  'Department' => $data->fkdep_id,
                  'fac_id'        => $data->fkfac_id, 
            'message' => 'Login successful'
        ]);
    } else {
        echo json_encode([
            'status' => 2,
            'message' => 'Invalid username or password'
        ]);
    }
}



    
    // Function to log out and destroy session
    public function logout()
    {
        // Destroy session data
        $this->session->sess_destroy();
        // Redirect to login page
        redirect('New_login/index');
    }
}
?>