<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Academic_report extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Academic_report_model');
        if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
        
    }

   
   
    public function create()
	{
  $data['branchdata'] = $this->Academic_report_model->getbranch();
 $data['semdata'] = $this->Academic_report_model->getsem();
 $data['typedata'] = $this->Academic_report_model->gettype();
  $data['institutedata'] = $this->Academic_report_model->getinstitu();
$data['yeardata'] = $this->Academic_report_model->getyear();
$data['evendata'] = $this->Academic_report_model->geteven();

$activeYear = $this->db
    ->select('finiYear_id')
    ->from('finiyear_master')
    ->where('Active_Deactive', 1)
    ->get()
    ->row();

$data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
        
        //  echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
		$this->load->view('admin/Academic_report_view',$data);
		$this->load->view('admin/footer_view');
	

	}



public function showDataByInstitute()
{
    $institute_id = $this->input->post('fk_institu');
    $branch_ids = $this->input->post('fkbranch_id');
    $ids = $this->input->post('fk_even'); 
    $IDs = $this->input->post('fk_auditType');
    $year = $this->input->post('year');
$startdate    = $this->input->post('startdate');
    $enddate      = $this->input->post('enddate');
  $SemIDs = $this->input->post('fk_sem'); 

    $data = $this->Academic_report_model->getDataByInstitute(
        $institute_id,
        $year,
        $branch_ids,
        $ids,
        $IDs,
        $SemIDs,
         $startdate,
        $enddate
        
    );

    echo json_encode($data);
}

// for print
public function getPrintHeadings()
{
    $data = $this->Academic_report_model->getPrintHeadings();
    echo json_encode($data);
}


// year and branch chart
 
 
// public function getYearwiseData()
// {
//     $year = $this->input->post('year');
 
//     if ($year == "0" || empty($year)) {
//         // All years
//         $summary = $this->Academic_report_model->getAllYearsData();
//         $types   = [];
//     } else {
//         // Single year
//         $summary = $this->Academic_report_model->getSingleYearData($year);
//         $types   = $this->Academic_report_model->getYearwiseTypes($year);
//     }
 
//     echo json_encode([
//         "status"  => "success",
//         "summary" => $summary,
//         "types"   => $types
//     ]);
// }

 public function getYearwiseData()
{
    $year      = $this->input->post('year');
    $branches  = $this->input->post('branches');   // may be an array
    
 
    if ($year == "0" || empty($year)) {
        // All years
        $summary = $this->Academic_report_model->getAllYearsData();
        $types   = [];
    } else {
        // Single year — pass all filters
        $summary = $this->Academic_report_model->getSingleYearData($year, $branches);
        $types   = $this->Academic_report_model->getYearwiseTypes($year,$branches);
    }
 
    echo json_encode([
        "status"  => "success",
        "summary" => $summary,
        "types"   => $types
    ]);
}
 
 
 
// Add these methods to your VAPReport controller
 
public function getBranchwiseData()
{
    $institu   = $this->input->post('fk_institu'); // match JS
    $branches  = $this->input->post('fkBranchName_id'); // match JS
    $year      = $this->input->post('year');
   
 
    $result = $this->Academic_report_model->getBranchwiseCount($institu, $branches, $year);
    echo json_encode($result);
}
 
public function getBranchDetails()
{
    $branch_id = $this->input->post('branch_id'); // correct
    $institu   = $this->input->post('fkBranchName_id'); // match JS
    $year      = $this->input->post('year');
  
    $result = $this->Academic_report_model->getBranchDetailsData($branch_id, $institu, $year);
    echo json_encode($result);
}
 
 
public function getCombinedData()
{
    $institu   = $this->input->post('fk_institu');
    $branches  = $this->input->post('branches');   // array
    $years     = $this->input->post('years');      // array
  
    $result = $this->Academic_report_model->getCombinedData($institu, $branches, $years);
 
    echo json_encode([
        "status"      => "success",
        "branchData"  => $result['branchData'],
        "yearData"    => $result['yearData']
    ]);
}
 
public function getStudentList()
{
    $fk_auditID = $this->input->post('fk_auditID');
    if (!$fk_auditID) {
        echo json_encode([]);
        return;
    }
 
    // $this->load->model('ParentMeet_model');
    $students = $this->Academic_report_model->getStudentsByMeetId($fk_auditID);
 
    echo json_encode($students);
}
 

}
