<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class AnswerType extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('AnswerType_model');

        if (empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
        }
    }

    // ==================== PAGE LOAD FUNCTIONS ====================

    // List page
    public function index()
    {
        $data['alldata'] = $this->AnswerType_model->getAllAnswerTypes();

        $this->load->view('admin/header_view');
        $this->load->view('admin/AnswerType_detailview', $data);
        $this->load->view('admin/footer_view');
    }

    // Create (Add new) page
    public function create()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/AnswerType_view');
        $this->load->view('admin/footer_view');
    }

    // Edit (Update) page
    public function update()
    {
        $id = $this->uri->segment(4);
        $data['data'] = $this->AnswerType_model->getbyid($id);

        $this->load->view('admin/header_view');
        $this->load->view('admin/AnswerType_view', $data);
        $this->load->view('admin/footer_view');
    }

    // ==================== INSERT ====================
public function insertAnswerType()
{
    $answerTypeName = trim($this->input->post('answertypename'));
    $orderNo        = $this->input->post('orderno');
    $isDefault      = $this->input->post('is_default');
    $isOn           = $this->input->post('is_on');
    $isActive       = $this->input->post('is_active');
    
    // Validate
    if (!$answerTypeName || !$orderNo) {
        echo json_encode(array(
            'status'  => false,
            'message' => 'Answer Type Name and Order Number are required'
        ));
        return;
    }
    
    // Check duplicate name
    if ($this->AnswerType_model->checkDuplicateAnswerType($answerTypeName)) {
        echo json_encode(array(
            'status'  => false,
            'message' => 'This Answer Type already exists'
        ));
        return;
    }
    
    // Check duplicate order number
    $duplicateOrders = $this->AnswerType_model->checkDuplicateOrderNumber($orderNo);
    if (!empty($duplicateOrders)) {
        foreach ($duplicateOrders as $order) {
            if ($order->is_active == 1) {
                echo json_encode(array(
                    'status'  => false,
                    'message' => 'This order number already exists and is active'
                ));
                return;
            }
        }
        // If we reach here, all duplicates are inactive, so we can proceed
    }
    
    $data = array(
        'answertypename' => $answerTypeName,
        'orderno'        => $orderNo,
        'is_default'     => ($isDefault == 1) ? 1 : 0,
        'is_on'          => ($isOn == 1) ? 1 : 0,
        'is_active'      => ($isActive == 1) ? 1 : 0
    );
    
    $result = $this->AnswerType_model->insertAnswerType($data);
    
    if ($result['status']) {
        echo json_encode(array(
            'status'  => true,
            'message' => 'Answer Type added successfully',
            'id'      => $result['answertypeid']
        ));
    } else {
        echo json_encode(array(
            'status'  => false,
            'message' => 'Failed to add Answer Type'
        ));
    }
}

    // ==================== UPDATE ====================

  public function updateAnswerType()
{
    $answertypeid   = $this->input->post('answertypeid');
    $answerTypeName = trim($this->input->post('answertypename'));
    $orderNo        = $this->input->post('orderno');
    $isDefault      = $this->input->post('is_default');
    $isOn           = $this->input->post('is_on');
    $isActive       = $this->input->post('is_active');
    
    if (empty($answertypeid)) {
        echo json_encode(['status' => false, 'message' => 'Invalid ID']);
        return;
    }

    // Validate
    if (!$answerTypeName || !$orderNo) {
        echo json_encode(array(
            'status'  => false,
            'message' => 'Answer Type Name and Order Number are required'
        ));
        return;
    }
    
    // Check duplicate name
    if ($this->AnswerType_model->checkDuplicateAnswerType($answerTypeName, $answertypeid)) {
        echo json_encode(array(
            'status'  => false,
            'message' => 'This Answer Type already exists'
        ));
        return;
    }
    
    // Check duplicate order number
    $duplicateOrders = $this->AnswerType_model->checkDuplicateOrderNumber($orderNo, $answertypeid);
    if (!empty($duplicateOrders)) {
        foreach ($duplicateOrders as $order) {
            if ($order->is_active == 1) {
                echo json_encode(array(
                    'status'  => false,
                    'message' => 'This order number already exists and  active'
                ));
                return;
            }
        }
        // If we reach here, all duplicates are inactive, so we can proceed
    }

    $data = array(
        'answertypename' => $answerTypeName,
        'orderno'        => $orderNo,
        'is_default'     => ($isDefault == 1) ? 1 : 0,
        'is_on'          => ($isOn == 1) ? 1 : 0,
        'is_active'      => ($isActive == 1) ? 1 : 0
    );
    
    $result = $this->AnswerType_model->updateAnswerType($answertypeid, $data);
    
    if ($result) {
        echo json_encode(['status' => true, 'message' => 'Answer Type updated successfully']);
    } else {
        echo json_encode(['status' => false, 'message' => 'Failed to update Answer Type']);
    }
}
// Add this method to your AnswerType controller
public function checkDuplicateOrderNumber()
{
    $orderno     = $this->input->post('orderno');
    $answertypeid = $this->input->post('answertypeid');
    
    if (!$orderno) {
        echo json_encode(['status' => false, 'message' => 'Order number is required']);
        return;
    }
    
    $duplicateOrders = $this->AnswerType_model->checkDuplicateOrderNumber($orderno, $answertypeid);
    
    $hasActiveDuplicate = false;
    if (!empty($duplicateOrders)) {
        foreach ($duplicateOrders as $order) {
            if ($order->is_active == 1) {
                $hasActiveDuplicate = true;
                break;
            }
        }
    }
    
    echo json_encode([
        'status' => true,
        'hasActiveDuplicate' => $hasActiveDuplicate
    ]);
}
    // ==================== TOGGLE ACTIVE STATUS ====================

    public function toggleActiveStatus()
    {
        $answertypeid = $this->input->post('answertypeid');
        $is_active    = $this->input->post('is_active');
        
        if (!isset($answertypeid)) {
            echo json_encode(array(
                'status'  => false,
                'message' => 'ID is required'
            ));
            return;
        }
        
        $result = $this->AnswerType_model->toggleActiveStatus($answertypeid, $is_active);
        
        if ($result) {
            echo json_encode(array(
                'status'  => true,
                'message' => 'Status updated successfully'
            ));
        } else {
            echo json_encode(array(
                'status'  => false,
                'message' => 'Failed to update status'
            ));
        }
    }
}
?>