<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Award extends CI_Controller {
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Award_model');
         $this->load->model('Log_model');
        $this->load->helper('log');
           if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
    }

    public function index()
    {
        $data['alldata']=$this->Award_model->getdetailview();
        $this->load->view('admin/header_view');
        $this->load->view('admin/Award_detailview',$data);
        $this->load->view('admin/footer_view');
    }

    public function dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/Award_dash_view');
        $this->load->view('admin/footer_view');
    }

    public function create()
    {
        $data['awarddata'] = $this->Award_model->get_all_AwardType();
        $data['institutedata'] = $this->Award_model->get_all_institute();
        
        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/Award_view',$data);
        $this->load->view('admin/footer_view');
    }

    public function insertAward()
    {
        $Award_name      = $this->input->post('Award_name');
        $fkAwardType_id  = $this->input->post('fkAwardType_id');
        $AwardAmt        = $this->input->post('AwardAmt');
        $AwardedBy       = $this->input->post('AwardedBy');
        $fkInsitute_id   = $this->input->post('fkInsitute_id');
$fk_submenuId = $this->input->post('fk_submenuId');
        $AwardCertify = $this->input->post('hidden_photo');

        if (!empty($_FILES['AwardCertify']['name'])) {
            $config['upload_path']   = FCPATH . 'uploads/awards/';
            $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf';
            $config['max_size']      = 2048;
            $config['file_name']     = time() . '_' . $_FILES['AwardCertify']['name'];

            $this->load->library('upload', $config);

            if ($this->upload->do_upload('AwardCertify')) {
                $uploadData   = $this->upload->data();
                $AwardCertify = 'uploads/awards/' . $uploadData['file_name'];
            } else {
                echo $this->upload->display_errors();
                return;
            }
        }

        $fields = array(
            'Award_name'      => $Award_name,
            'fkAwardType_id'  => $fkAwardType_id,
            'AwardCertify'    => $AwardCertify,
            'AwardAmt'        => $AwardAmt,
            'AwardedBy'       => $AwardedBy,
            'fkInsitute_id'   => $fkInsitute_id,
            'created_by'=>$_SESSION['userID']
        );

        $finiYear = $this->db
                    ->select('finiYear_id')
                    ->from('finiyear_master')
                    ->where('Active_Deactive', 1)
                    ->get()
                    ->row();
     
        if ($finiYear) {
            $fields['FiniYear'] = $finiYear->finiYear_id;
        }

        // $this->Award_model->insertdata($fields);
        // $award_id = $this->db->insert_id();
        // Insert into award master via model
$inserted_id = $this->Award_model->insertdata($fields);
$award_id    = $inserted_id;

// 🔐 Insert log - Action 1 (Insert)
$action      = 1; // Insert
$record_id  = $inserted_id;
$excel_name = null;
$Fk_branch  = null; // pass branch if available

insert_log(
    $this,
    $fk_submenuId,
    $action,
    $record_id,
    $excel_name,
    $Fk_branch,
    $_SESSION['userID']
);


        if (!empty($_FILES['AwardGallery']['name'][0])) {
            $this->load->library('upload');

            $filesCount = count($_FILES['AwardGallery']['name']);

            for ($i = 0; $i < $filesCount; $i++) {
                $_FILES['file']['name']     = $_FILES['AwardGallery']['name'][$i];
                $_FILES['file']['type']     = $_FILES['AwardGallery']['type'][$i];
                $_FILES['file']['tmp_name'] = $_FILES['AwardGallery']['tmp_name'][$i];
                $_FILES['file']['error']    = $_FILES['AwardGallery']['error'][$i];
                $_FILES['file']['size']     = $_FILES['AwardGallery']['size'][$i];

                $config['upload_path']   = FCPATH . 'uploads/awardgallery/';
                $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf|doc|docx|webp';
                $config['max_size']      = 2048;
                $config['file_name']     = uniqid() . '_' . $_FILES['file']['name'];

                $this->upload->initialize($config);

                if ($this->upload->do_upload('file')) {
                    $uploadData = $this->upload->data();
                    $filePath   = 'uploads/awardgallery/' . $uploadData['file_name'];

                    $this->db->insert('award_gallery', [
                        'fkAward_id' => $award_id,
                        'file_path'  => $filePath
                    ]);
                } else {
                    log_message('error', $this->upload->display_errors());
                }
            }
        }

        echo json_encode(['status' => 'success', 'data' => $fields]);
    }

    public function update()
    {
        $id=$this->uri->segment(4);
        $data['data']=$this->Award_model->getbyid($id);
        $data['awarddata'] = $this->Award_model->get_all_AwardType();
        $data['institutedata'] = $this->Award_model->get_all_institute();
        $data['selectedGallary'] = $this->Award_model->getAwardGallery($id);

$current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/Award_view',$data);
        $this->load->view('admin/footer_view');
    }

    public function updateAward()
    {
        $Award_id       = $this->input->post('Award_id');  
        $Award_name     = $this->input->post('Award_name');
        $fkAwardType_id = $this->input->post('fkAwardType_id');
        $AwardAmt       = $this->input->post('AwardAmt');
        $AwardedBy      = $this->input->post('AwardedBy');
        $fkInsitute_id  = $this->input->post('fkInsitute_id');
        $fk_submenuId = $this->input->post('fk_submenuId');

        $AwardCertify = $this->input->post('hidden_photo');

        if (!empty($_FILES['AwardCertify']['name'])) {
            $config['upload_path']   = FCPATH . 'uploads/awards/';
            $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf';
            $config['max_size']      = 2048;
            $config['file_name']     = time() . '_' . $_FILES['AwardCertify']['name'];

            $this->load->library('upload', $config);

            if ($this->upload->do_upload('AwardCertify')) {
                $uploadData   = $this->upload->data();
                $AwardCertify = 'uploads/awards/' . $uploadData['file_name'];
            } else {
                echo $this->upload->display_errors();
                return;
            }
        }

        $removed_photos = $this->input->post('removed_photos');
        if (!empty($removed_photos)) {
            $removed_photos_array = explode(',', $removed_photos);
            $this->Award_model->deleteExistingPhotos($Award_id, $removed_photos_array);

            foreach ($removed_photos_array as $photo) {
                $file_path = FCPATH . $photo;
                if (file_exists($file_path)) {
                    unlink($file_path);
                }
            }
        }

        $fields = array(
            'Award_id'      => $Award_id,
            'Award_name'    => $Award_name,
            'fkAwardType_id'=> $fkAwardType_id,
            'AwardCertify'  => $AwardCertify,
            'AwardAmt'      => $AwardAmt,
            'AwardedBy'     => $AwardedBy,
            'fkInsitute_id' => $fkInsitute_id,
            'modified_by'=>$_SESSION['userID']
        );

        $finiYear = $this->db
                        ->select('finiYear_id')
                        ->from('finiyear_master')
                        ->where('Active_Deactive', 1)
                        ->get()
                        ->row();

        if ($finiYear) {
            $fields['FiniYear'] = $finiYear->finiYear_id;
        }

        $this->Award_model->update($fields);
        // 🔐 Insert log - Action 2 (Update)
$action      = 2; // Update
$record_id  = $Award_id;   // MUST be Award_id
$excel_name = null;
$Fk_branch  = null;        // pass branch if you have it

insert_log(
    $this,
    $fk_submenuId,
    $action,
    $record_id,
    $excel_name,
    $Fk_branch,
    $_SESSION['userID']
);


        if (!empty($_FILES['AwardGallery']['name'][0])) {
            $this->load->library('upload');

            $filesCount = count($_FILES['AwardGallery']['name']);
            for ($i = 0; $i < $filesCount; $i++) {
                $_FILES['file']['name']     = $_FILES['AwardGallery']['name'][$i];
                $_FILES['file']['type']     = $_FILES['AwardGallery']['type'][$i];
                $_FILES['file']['tmp_name'] = $_FILES['AwardGallery']['tmp_name'][$i];
                $_FILES['file']['error']    = $_FILES['AwardGallery']['error'][$i];
                $_FILES['file']['size']     = $_FILES['AwardGallery']['size'][$i];

                $config['upload_path']   = FCPATH . 'uploads/awardgallery/';
                $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf|doc|docx|webp';
                $config['max_size']      = 2048;
                $config['file_name']     = uniqid() . '_' . $_FILES['file']['name'];

                $this->upload->initialize($config);

                if ($this->upload->do_upload('file')) {
                    $uploadData = $this->upload->data();
                    $filePath   = 'uploads/awardgallery/' . $uploadData['file_name'];

                    $this->db->insert('award_gallery', [
                        'fkAward_id' => $Award_id,
                        'file_path'  => $filePath
                    ]);
                } else {
                    log_message('error', $this->upload->display_errors());
                }
            }
        }

        echo json_encode(['status' => 'success', 'data' => $fields]);
    }

    public function Report()
    {
        // Removed institutedata
        $data['awarddata'] = $this->Award_model->get_all_AwardType();
        $data['yeardata'] = $this->Award_model->getyear();
        
        $activeYear = $this->db
            ->select('finiYear_id')
            ->from('finiyear_master')
            ->where('Active_Deactive', 1)
            ->get()
            ->row();
     
        $data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;

        $this->load->view('admin/header_view');
        $this->load->view('admin/Award_Report',$data);
        $this->load->view('admin/footer_view');
    }

    // NEW METHOD - Replaced showDataByInstitute
    public function showAllData()
    {
        $fkAwardType_id = $this->input->post('fkAwardType_id');
        $year           = $this->input->post('year');

        $data = $this->Award_model->getAllAwardData(
            $year,
            $fkAwardType_id
        );

        echo json_encode($data);
    }

    public function getPrintHeadings()
    {
        $data = $this->Award_model->getPrintHeadings();
        echo json_encode($data);
    }

    public function getYearwiseData()
    {
        $year = $this->input->post('year');
     
        if ($year == "0" || empty($year)) {
            $summary = $this->Award_model->getAllYearsData();
            $types   = [];
        } else {
            $summary = $this->Award_model->getSingleYearData($year);
            $types   = $this->Award_model->getYearwiseTypes($year);
        }
     
        echo json_encode([
            "status"  => "success",
            "summary" => $summary,
            "types"   => $types
        ]);
    }

    // UPDATED METHOD - Removed institu parameter
    public function getCombinedData()
    {
        $years     = $this->input->post('years');
        $startDate = $this->input->post('StartDate');
        $endDate   = $this->input->post('EndDate');

        $result = $this->Award_model->getCombinedData($years, $startDate, $endDate);

        echo json_encode([
            "status"   => "success",
            "yearData" => $result['yearData']
        ]);
    }
}