<?php
defined('BASEPATH') OR exit('No direct script access allowed');
 
class Budgetuti extends CI_Controller {
   
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Budgetuti_model');
        $this->load->library('upload');
         $this->load->model('Log_model');
        $this->load->helper('log');
           if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
    }
    

    public function Dashboard()
    {
     
 
        // echo "<pre>";
        // print_r($data);
 
       
        $this->load->view('admin/header_view');
        $this->load->view('admin/Budgetuti_dash_view.php');
        $this->load->view('admin/footer_view');
   
   
 
    }


    public function create()
    {
        $data['branchdata'] = $this->Budgetuti_model->getbranch();
         $data['allocationdata'] = $this->Budgetuti_model->getallocationData();
        $data['yeardata'] = $this->Budgetuti_model->getYearData();
         $data['activeYear'] = $this->Budgetuti_model->getActiveYear();
        $data['expensivedata'] = $this->Budgetuti_model->getExpensiveData(); // ADD THIS LINE
        $data['active_year_id'] = date('Y');
        
        $data['mainData'] = null;
        $data['childData'] = [];
        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/Budgetuti_view.php', $data);
        $this->load->view('admin/footer_view');
    }

     public function index()
    {
        // Load list view
        $data['alldata'] = $this->Budgetuti_model->getAllInternships();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Budgetuti_detailview.php', $data);
        $this->load->view('admin/footer_view');
    }

 public function insertbugetuti()
{
    try {
        $this->output->set_content_type('application/json');
        
        $posted_data = $this->input->post();
        
        // Validation
        if (empty($posted_data['finicial_Year']) || $posted_data['finicial_Year'] == '0') {
            echo json_encode(['status' => 'error', 'message' => 'Financial Year is required']);
            return;
        }
        
        // UPDATED: Check for fkexpentype_id instead of expensive_name
        if (empty($posted_data['fkexpentype_id']) || !is_array($posted_data['fkexpentype_id'])) {
            echo json_encode(['status' => 'error', 'message' => 'At least one expense record is required']);
            return;
        }
        
        $finicial_Year = $posted_data['finicial_Year'];
        $fkbranch_id = $posted_data['fkbranch_id'] ?? null;
        $budgetuti_date = $posted_data['budgetuti_date'] ?? date('Y-m-d');
        $Desscription_main = $posted_data['Desscription_main'] ?? '';
        $fk_submenuId = $posted_data['fk_submenuId'] ?? '';
// $fk_submenuId = $this->input->post('fk_submenuId');

        $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
        $institute_id = $institute ? $institute->Institu_id : null;
        
        // Handle excel file upload
        $excel_name = null;
        if (!empty($_FILES['excel_file']['name'])) {
            $upload_path = './uploads/excel/';
            
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777, true);
            }
            
            $config['upload_path'] = $upload_path;
            $config['allowed_types'] = 'xlsx|xls';
            $config['max_size'] = 10240;
            $config['file_name'] = 'budgetuti_excel_' . time() . '_' . $_FILES['excel_file']['name'];
            $config['overwrite'] = FALSE;
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('excel_file')) {
                $upload_data = $this->upload->data();
                $excel_name = $upload_data['file_name'];
            }
        }

        // Save parent data
        $parentData = array(
            'fkbranch_id' => $fkbranch_id,
            'finicial_Year' => $finicial_Year,
            'budgetuti_date' => $budgetuti_date,
            'Desscription_main' => $Desscription_main,
            'institute' => $institute_id,
            'excel_file' => $excel_name,
            'created_by'=>$_SESSION['userID']
        );
        
        $budgetmain_id = $this->Budgetuti_model->insertMain($parentData);

 
        // Insert log - Action 1 (Insert)

        $action = 1;

        $record_id = $budgetmain_id;

        $excel_name = null;

        $Fk_branch = $fkbranch_id;

        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);

 

        
        if (!$budgetmain_id) {
            echo json_encode(['status' => 'error', 'message' => 'Failed to insert main record']);
            return;
        }

        // UPDATED: Get expensive type IDs instead of names
        $fkexpentype_id = $this->input->post('fkexpentype_id');
        $fkallocationtype_id = $this->input->post('fkallocationtype_id');
        $expensive_date = $this->input->post('expensive_date');
        $amount = $this->input->post('amount');
        $desscription = $this->input->post('desscription');

        

        $inserted_count = 0;

        // Process invoice files
        $invioces = [];
        if (!empty($_FILES['invioce']['name'])) {
            foreach ($_FILES['invioce']['name'] as $key => $filename) {
                if (!empty($filename) && $_FILES['invioce']['error'][$key] == 0) {
                    $_FILES['temp_file'] = array(
                        'name' => $_FILES['invioce']['name'][$key],
                        'type' => $_FILES['invioce']['type'][$key],
                        'tmp_name' => $_FILES['invioce']['tmp_name'][$key],
                        'error' => $_FILES['invioce']['error'][$key],
                        'size' => $_FILES['invioce']['size'][$key]
                    );
                    
                    $config['upload_path'] = './uploads/letters/invioce/';
                    $config['allowed_types'] = 'pdf|doc|docx';
                    $config['file_name'] = 'invoice_' . time() . '_' . $key . '_' . $filename;
                    $config['max_size'] = 5120;
                    
                    if (!is_dir($config['upload_path'])) {
                        mkdir($config['upload_path'], 0777, true);
                    }
                    
                    $this->upload->initialize($config);
                    
                    if ($this->upload->do_upload('temp_file')) {
                        $invioces[$key] = $this->upload->data('file_name');
                    } else {
                        $invioces[$key] = null;
                    }
                } else {
                    $invioces[$key] = null;
                }
            }
        }

        // Insert child records - UPDATED to use fkexpentype_id
        if (!empty($fkexpentype_id)) {
            foreach ($fkexpentype_id as $i => $expen_id) {
                // Skip if empty
                if (empty($expen_id)) continue;
                
                $invioce_file = isset($invioces[$i]) ? $invioces[$i] : null;
                $allocation_id = $fkallocationtype_id[$i] ?? null;
                
                // Insert into budgetutilazation_master with expensive type ID
                $childData = array(
                    'fkbudgetmain_id' => $budgetmain_id,
                    'fkexpentype_id' => $expen_id, // CHANGED: Now storing ID instead of name
                    'fkallocationtype_id' => $allocation_id,
                    'expensive_date' => !empty($expensive_date[$i]) ? $expensive_date[$i] : null,
                    'amount' => $amount[$i] ?? null,
                    'desscription' => $desscription[$i] ?? null,
                    'finicial_Year' => $finicial_Year,
                    'invioce' => $invioce_file
                );

                if ($this->Budgetuti_model->insertChild($childData)) {
                    $inserted_count++;
                }
            }
        }

        if ($inserted_count > 0) {
            echo json_encode([
                'status' => 'success', 
                'main_id' => $budgetmain_id,
                'inserted_count' => $inserted_count,
                'message' => "Successfully saved {$inserted_count} expense records"
            ]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'No expense records were saved']);
        }
        
    } catch (Exception $e) {
        log_message('error', 'Budget insertion error: ' . $e->getMessage());
        echo json_encode(['status' => 'error', 'message' => 'Server error: ' . $e->getMessage()]);
    }
}


public function update($id)
{
    // Load all required data for dropdowns
    $data['branchdata'] = $this->Budgetuti_model->getbranch();
    $data['allocationdata'] = $this->Budgetuti_model->getallocationData();
    $data['yeardata'] = $this->Budgetuti_model->getYearData();
    $data['expensivedata'] = $this->Budgetuti_model->getExpensiveData(); // ADD THIS LINE
    
    // Load existing data
    $data['mainData'] = $this->Budgetuti_model->getMainById($id);
    $data['childData'] = $this->Budgetuti_model->getChildByMainId($id);
    
    // IMPORTANT: Pass the data array to view
    $data['data'] = $data['childData']; // This creates the $data[0] variable in view
    $data['active_year_id'] = $data['mainData']->finicial_Year ?? date('Y');
    
$current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);

    $this->load->view('admin/header_view');
    $this->load->view('admin/Budgetuti_view.php', $data);
    $this->load->view('admin/footer_view');
}


  public function updatebudgetuti()
{
    try {
        $this->output->set_content_type('application/json');
        
        $posted_data = $this->input->post();
        
        // Validation
        $budgetmain_id = $posted_data['budgetmain_id'] ?? null;
        
        if (empty($budgetmain_id)) {
            echo json_encode(['status' => 'error', 'message' => 'Budget Main ID is required']);
            return;
        }
        
        if (empty($posted_data['finicial_Year']) || $posted_data['finicial_Year'] == '0') {
            echo json_encode(['status' => 'error', 'message' => 'Financial Year is required']);
            return;
        }
        
        // UPDATED: Check for fkexpentype_id instead of expensive_name
        if (empty($posted_data['fkexpentype_id']) || !is_array($posted_data['fkexpentype_id'])) {
            echo json_encode(['status' => 'error', 'message' => 'At least one expense record is required']);
            return;
        }
        
        $finicial_Year = $posted_data['finicial_Year'];
        $fkbranch_id = $posted_data['fkbranch_id'] ?? null;
        $budgetuti_date = $posted_data['budgetuti_date'] ?? date('Y-m-d');
        $Desscription_main = $posted_data['Desscription_main'] ?? '';
        $fk_submenuId = $posted_data['fk_submenuId'] ?? '';
        // $fk_submenuId = $this->input->post('fk_submenuId');

        $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
        $institute_id = $institute ? $institute->Institu_id : null;
        
        // Get existing main data
        $existingMain = $this->Budgetuti_model->getMainById($budgetmain_id);
        $excel_name = $existingMain->excel_file ?? null;
        
        // Handle excel file upload (if new file uploaded)
        if (!empty($_FILES['excel_file']['name'])) {
            $upload_path = './uploads/excel/';
            
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777, true);
            }
            
            // Delete old excel file if exists
            if (!empty($excel_name) && file_exists($upload_path . $excel_name)) {
                unlink($upload_path . $excel_name);
            }
            
            $config['upload_path'] = $upload_path;
            $config['allowed_types'] = 'xlsx|xls';
            $config['max_size'] = 10240;
            $config['file_name'] = 'budgetuti_excel_' . time() . '_' . $_FILES['excel_file']['name'];
            $config['overwrite'] = FALSE;
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('excel_file')) {
                $upload_data = $this->upload->data();
                $excel_name = $upload_data['file_name'];
            }
        }

        // Update parent data
        $parentData = array(
            'fkbranch_id' => $fkbranch_id,
            'finicial_Year' => $finicial_Year,
            'budgetuti_date' => $budgetuti_date,
            'Desscription_main' => $Desscription_main,
            'institute' => $institute_id,
            'excel_file' => $excel_name,
            'modified_by'=>$_SESSION['userID']
        );
        
if ($this->Budgetuti_model->updateMain($budgetmain_id, $parentData)) {

    // Insert log - Action 2 (Update)
    $action = 2;
    $record_id = $budgetmain_id;
    $excel_name = null;
    $Fk_branch = $fkbranch_id;

    insert_log(
        $this,
        $fk_submenuId,
        $action,
        $record_id,
        $excel_name,
        $Fk_branch,
        $_SESSION['userID']
    );

} else {

    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to update main record'
    ]);
    return;
}


//         if (!$this->Budgetuti_model->updateMain($budgetmain_id, $parentData)) {

// // Insert log - Action 2 (Update)
//         $action = 2;
//         $record_id = $budgetmain_id;
//         $excel_name = null;
//         $Fk_branch = $fkbranch_id;
//         insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);

//             echo json_encode(['status' => 'error', 'message' => 'Failed to update main record']);
//             return;
//         }

        // Delete existing child records
        $this->Budgetuti_model->deleteChildByMainId($budgetmain_id);

        // UPDATED: Get expensive type IDs instead of names
        $fkexpentype_id = $this->input->post('fkexpentype_id');
        $fkallocationtype_id = $this->input->post('fkallocationtype_id');
        $expensive_date = $this->input->post('expensive_date');
        $amount = $this->input->post('amount');
        $desscription = $this->input->post('desscription');
        $existing_invioce = $this->input->post('existing_invioce');

        

        $inserted_count = 0;

        // Process invoice files
        $invioces = [];
        if (!empty($_FILES['invioce']['name'])) {
            foreach ($_FILES['invioce']['name'] as $key => $filename) {
                if (!empty($filename) && $_FILES['invioce']['error'][$key] == 0) {
                    $_FILES['temp_file'] = array(
                        'name' => $_FILES['invioce']['name'][$key],
                        'type' => $_FILES['invioce']['type'][$key],
                        'tmp_name' => $_FILES['invioce']['tmp_name'][$key],
                        'error' => $_FILES['invioce']['error'][$key],
                        'size' => $_FILES['invioce']['size'][$key]
                    );
                    
                    $config['upload_path'] = './uploads/letters/invioce/';
                    $config['allowed_types'] = 'pdf|doc|docx';
                    $config['file_name'] = 'invoice_' . time() . '_' . $key . '_' . $filename;
                    $config['max_size'] = 5120;
                    
                    if (!is_dir($config['upload_path'])) {
                        mkdir($config['upload_path'], 0777, true);
                    }
                    
                    $this->upload->initialize($config);
                    
                    if ($this->upload->do_upload('temp_file')) {
                        $invioces[$key] = $this->upload->data('file_name');
                    } else {
                        // Keep existing invoice if new upload fails
                        $invioces[$key] = $existing_invioce[$key] ?? null;
                    }
                } else {
                    // Keep existing invoice if no new file uploaded
                    $invioces[$key] = $existing_invioce[$key] ?? null;
                }
            }
        } else {
            // No new files, keep existing invoices
            if (!empty($existing_invioce)) {
                foreach ($existing_invioce as $key => $existing) {
                    $invioces[$key] = $existing;
                }
            }
        }

        // Insert updated child records - UPDATED to use fkexpentype_id
        if (!empty($fkexpentype_id)) {
            foreach ($fkexpentype_id as $i => $expen_id) {
                // Skip if empty
                if (empty($expen_id)) continue;
                
                $invioce_file = isset($invioces[$i]) ? $invioces[$i] : null;
                $allocation_id = $fkallocationtype_id[$i] ?? null;
                
                // Insert into budgetutilazation_master with expensive type ID
                $childData = array(
                    'fkbudgetmain_id' => $budgetmain_id,
                    'fkexpentype_id' => $expen_id, // CHANGED: Now storing ID instead of name
                    'fkallocationtype_id' => $allocation_id,
                    'expensive_date' => !empty($expensive_date[$i]) ? $expensive_date[$i] : null,
                    'amount' => $amount[$i] ?? null,
                    'desscription' => $desscription[$i] ?? null,
                    'finicial_Year' => $finicial_Year,
                    'invioce' => $invioce_file
                );

                if ($this->Budgetuti_model->insertChild($childData)) {
                    $inserted_count++;
                }
            }
        }

        if ($inserted_count > 0) {
            echo json_encode([
                'status' => 'success', 
                'main_id' => $budgetmain_id,
                'updated_count' => $inserted_count,
                'message' => "Successfully updated with {$inserted_count} expense records"
            ]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'No expense records were saved']);
        }
        
    } catch (Exception $e) {
        log_message('error', 'Budget update error: ' . $e->getMessage());
        echo json_encode(['status' => 'error', 'message' => 'Server error: ' . $e->getMessage()]);
    }
}

// Add this method in your budgetulti controller
public function createAllocationType()
{
    $this->output->set_content_type('application/json');
    
    $name = $this->input->post('name');
    
    if (empty($name)) {
        echo json_encode(['status' => 'error', 'message' => 'Allocation type name is required']);
        return;
    }
    
    // Check if already exists (case-insensitive)
    $this->db->where('LOWER(name)', strtolower($name));
    $existing = $this->db->get('allocationtype_master')->row();
    
    if ($existing) {
        echo json_encode([
            'status' => 'success',
            'id' => $existing->allocationtype_id,
            'message' => 'Allocation type already exists'
        ]);
        return;
    }
    
    // Insert new allocation type
    $data = array('name' => trim($name));
    $this->db->insert('allocationtype_master', $data);
    $insert_id = $this->db->insert_id();
    
    if ($insert_id) {
        echo json_encode([
            'status' => 'success',
            'id' => $insert_id,
            'message' => 'New allocation type created successfully'
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Failed to create allocation type'
        ]);
    }
}


public function createExpensiveType()
{
    $this->output->set_content_type('application/json');
    
    $name = $this->input->post('name');
    $allocation_id = $this->input->post('allocation_id');
    
    if (empty($name)) {
        echo json_encode(['status' => 'error', 'message' => 'Expensive name is required']);
        return;
    }
    
    // Check if already exists (case-insensitive)
    $this->db->where('LOWER(expen_name)', strtolower($name));
    if (!empty($allocation_id)) {
        $this->db->where('fkallocationtype_id', $allocation_id);
    }
    $existing = $this->db->get('expensivetype_master')->row();
    
    if ($existing) {
        echo json_encode([
            'status' => 'success',
            'id' => $existing->expentype_id,
            'name' => $existing->expen_name,
            'allocation_id' => $existing->fkallocationtype_id,
            'message' => 'Expensive type already exists'
        ]);
        return;
    }
    
    // Insert new expensive type
    $data = array(
        'expen_name' => trim($name),
        'fkallocationtype_id' => !empty($allocation_id) ? $allocation_id : null
    );
    $this->db->insert('expensivetype_master', $data);
    $insert_id = $this->db->insert_id();
    
    if ($insert_id) {
        echo json_encode([
            'status' => 'success',
            'id' => $insert_id,
            'name' => trim($name),
            'allocation_id' => !empty($allocation_id) ? $allocation_id : null,
            'message' => 'New expensive type created successfully'
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Failed to create expensive type'
        ]);
    }
}

}