<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class BudgetutiReport extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('BudgetutiReport_model');
           if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
    }

    public function Report()
    {
        $data['yeardata'] = $this->BudgetutiReport_model->getyear();
        $data['institutedata'] = $this->BudgetutiReport_model->getinstitu();
        $data['branchdata'] = $this->BudgetutiReport_model->getbranch();
        
        // Get active year
        // $activeYear = $this->db
        //     ->select('finiYear_id')
        //     ->from('finiyear_master')
        //     ->where('Active_Deactive', 1)
        //     ->get()
        //     ->row();
        
        // $data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/BudgetutiReport_view.php', $data);
        $this->load->view('admin/footer_view');
    }

    // Main table data from budgetuti_main_master
    public function getReportData()
    {
        $institu   = $this->input->post('fk_institu');
        $branches  = $this->input->post('fkbranch_id');
        $year_id   = $this->input->post('year'); 
        $startDate = $this->input->post('startdate');
        $endDate   = $this->input->post('enddate');

        $data = $this->BudgetutiReport_model->getFilteredData($institu, $branches, $year_id, $startDate, $endDate);
        echo json_encode($data);
    }

    // Modal data from budgetutilazation_master (when View button clicked)
    public function getbudgetList()
    {
        $fkbudgetmain_id = $this->input->post('fkbudgetmain_id');
        
        $data = $this->BudgetutiReport_model->getBudgetUtilizationDetails($fkbudgetmain_id);
        echo json_encode($data);
    }



    public function getPrintHeadings()
    {
        $data = $this->BudgetutiReport_model->getPrintHeadings();
        echo json_encode($data);
    }

    public function getYearwiseData()
    {
        $year = $this->input->post('year');
        $branches = $this->input->post('branches');

        if ($year == "0" || empty($year)) {
            $summary = $this->BudgetutiReport_model->getAllYearsData();
            $types = [];
        } else {
            $summary = $this->BudgetutiReport_model->getSingleYearData($year, $branches);
            $types = $this->BudgetutiReport_model->getYearwiseTypes($year, $branches);
        }
     
        echo json_encode([
            "status"  => "success",
            "summary" => $summary,
            "types"   => $types
        ]);
    }
     
    public function getBranchwiseData()
    {
        $institu   = $this->input->post('fk_institu');
        $branches  = $this->input->post('branches');
        $year      = $this->input->post('year');
        $startDate = $this->input->post('StartDate');
        $endDate   = $this->input->post('EndDate');
     
        $result = $this->BudgetutiReport_model->getBranchwiseCount($institu, $branches, $year, $startDate, $endDate);
        echo json_encode($result);
    }
     
    public function getBranchDetails()
    {
        $branch_id = $this->input->post('branch_id');
        $institu   = $this->input->post('fk_institu');
        $year      = $this->input->post('year');
        $startDate = $this->input->post('StartDate');
        $endDate   = $this->input->post('EndDate');
     
        $result = $this->BudgetutiReport_model->getBranchDetailsData($branch_id, $institu, $year, $startDate, $endDate);
        echo json_encode($result);
    }
     
    public function getCombinedData()
    {
        $institu   = $this->input->post('fk_institu');
        $branches  = $this->input->post('branches');
        $years     = $this->input->post('years');
        $startDate = $this->input->post('StartDate');
        $endDate   = $this->input->post('EndDate');
     
        $result = $this->BudgetutiReport_model->getCombinedData($institu, $branches, $years, $startDate, $endDate);
     
        echo json_encode([
            "status"      => "success",
            "branchData"  => $result['branchData'],
            "yearData"    => $result['yearData']
        ]);
    }
}