<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ChapterReport extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('ChapterReport_model');
        $this->load->library('upload');
    }

    public function Report()
    {
        $data['institutedata'] = $this->ChapterReport_model->get_all_institute();
        $data['Branch'] = $this->ChapterReport_model->get_all_Branch();
        $data['Faculty'] = $this->ChapterReport_model->get_all_Faculty();
        $data['Student'] = $this->ChapterReport_model->get_all_Student();
        $data['yeardata'] = $this->ChapterReport_model->getyear();
        $data['clubNames'] = $this->ChapterReport_model->getAllClubNames();
        $data['branchdata'] = $this->ChapterReport_model->getbranch();   

        $activeYear = $this->db
            ->select('finiYear_id')
            ->from('finiyear_master')
            ->where('Active_Deactive', 1)
            ->get()
            ->row();
     
        $data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;

        $this->load->view('admin/header_view');
        $this->load->view('admin/ChapterReport_view',$data);
        $this->load->view('admin/footer_view');
    }

    // Main report data - Show all clubs with filters
    public function showDataByInstitute()
    {
        $institute_id = $this->input->post('InstituteId');
        $startdate    = $this->input->post('startdate');
        $enddate      = $this->input->post('enddate');
        $branches     = $this->input->post('fkbranch_id');
        $faculties    = $this->input->post('fkFacCo_id');
        $students     = $this->input->post('fkStudCo_id');
        $year         = $this->input->post('year');

        $data = $this->ChapterReport_model->getDataByInstitute(
            $institute_id,
            $startdate,
            $enddate,
            $branches,
            $faculties,
            $students,
            $year
        );

        echo json_encode($data);
    }

    // Get club details for View button (students + activities + faculty)
    public function getClubDetails()
    {
        $club_id = $this->input->post('club_id');
        
        if(empty($club_id)) {
            echo json_encode(['status' => 'error', 'message' => 'Club ID required']);
            return;
        }

        $data = $this->ChapterReport_model->getClubFullDetails($club_id);
        
        echo json_encode([
            'status' => 'success',
            'students' => $data['students'],
            'activities' => $data['activities'],
            'faculties' => $data['faculties']  // ✅ Added faculty data
        ]);
    }

    public function getPrintHeadings()
    {
        $data = $this->ChapterReport_model->getPrintHeadings();
        echo json_encode($data);
    }

    public function getYearwiseData()
    {
        $year      = $this->input->post('year');
        $institu   = $this->input->post('fk_institu');
        $branches  = $this->input->post('branches');
        $startDate = $this->input->post('StartDate');
        $endDate   = $this->input->post('EndDate');

        if ($year == "0" || empty($year)) {
            $summary = $this->ChapterReport_model->getAllYearsData();
            $types   = [];
        } else {
            $summary = $this->ChapterReport_model->getSingleYearData($year, $institu, $branches, $startDate, $endDate);
            $types   = $this->ChapterReport_model->getYearwiseTypes($year, $institu, $branches, $startDate, $endDate);
        }

        echo json_encode([
            "status"  => "success",
            "summary" => $summary,
            "types"   => $types
        ]);
    }

    public function getBranchwiseData()
    {
        $institu   = $this->input->post('fk_institu');
        $branches  = $this->input->post('fkbranch_id');
        $year      = $this->input->post('year');
        $startDate = $this->input->post('StartDate');
        $endDate   = $this->input->post('EndDate');

        $result = $this->ChapterReport_model->getBranchwiseCount($institu, $branches, $year, $startDate, $endDate);
        echo json_encode($result);
    }

    public function getBranchDetails()
    {
        $branch_id = $this->input->post('branch_id');
        $institu   = $this->input->post('fkbranch_id');
        $year      = $this->input->post('year');
        $startDate = $this->input->post('StartDate');
        $endDate   = $this->input->post('EndDate');

        $result = $this->ChapterReport_model->getBranchDetailsData($branch_id, $institu, $year, $startDate, $endDate);
        echo json_encode($result);
    }

    public function getCombinedData()
    {
        $institu   = $this->input->post('fk_institu'); 
        $branches  = $this->input->post('branches');
        $years     = $this->input->post('years');
        $startDate = $this->input->post('StartDate');
        $endDate   = $this->input->post('EndDate');

        $result = $this->ChapterReport_model->getCombinedData($institu, $branches, $years, $startDate, $endDate);

        echo json_encode([
            "status"      => "success",
            "branchData"  => $result['branchData'],
            "yearData"    => $result['yearData']
        ]);
    }
}