<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class CollegeFeedback extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('CollegeFeedback_model');

        if (empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
        }
    }

    // ==================== PAGE LOAD FUNCTIONS ====================

    // List page — shows all saved URLs
    public function index()
    {
        $data['alldata'] = $this->CollegeFeedback_model->getAllGeneratedURLs();

        $this->load->view('admin/header_view');
        $this->load->view('admin/CollegeFeedback_detailview', $data);
        $this->load->view('admin/footer_view');
    }

    // Create (Add new) page
    public function create()
    {
        $data['institutedata'] = $this->CollegeFeedback_model->getinstitute();
        $data['feedbackdata']  = $this->CollegeFeedback_model->getFeedbackFor();
        $data['yeardata']      = $this->CollegeFeedback_model->getyear();
        $data['activeYear']    = $this->CollegeFeedback_model->getActiveYear();

        // Branch: load for first institute by default
        $instituteId = !empty($data['institutedata'][0]->Institu_id) ? $data['institutedata'][0]->Institu_id : null;
        $data['branchdata'] = $this->CollegeFeedback_model->getBranch($instituteId);

        $this->load->view('admin/header_view');
        $this->load->view('admin/CollegeFeedback_view', $data);
        $this->load->view('admin/footer_view');
    }

    // Edit (Update) page — loads existing record
    public function update()
    {
        $id = $this->uri->segment(4);
        $data['data'] = $this->CollegeFeedback_model->getbyid($id);

        $data['institutedata'] = $this->CollegeFeedback_model->getinstitute();
        $data['feedbackdata']  = $this->CollegeFeedback_model->getFeedbackFor();
        $data['yeardata']      = $this->CollegeFeedback_model->getyear();
        $data['activeYear']    = $this->CollegeFeedback_model->getActiveYear();

        // Branch: load for the institute of the existing record
        $instituteId = !empty($data['data'][0]->fkInsitute_id) ? $data['data'][0]->fkInsitute_id : null;
        $data['branchdata'] = $this->CollegeFeedback_model->getBranch($instituteId);

        $this->load->view('admin/header_view');
        $this->load->view('admin/CollegeFeedback_view', $data);
        $this->load->view('admin/footer_view');
    }

    // ==================== AJAX: BRANCH DROPDOWN ====================

    // Called via AJAX when institute changes — returns branches as JSON
    public function getBranchByInstitute()
    {
        $institute_id = $this->input->post('institute_id');

        if (!$institute_id) {
            echo json_encode(array());
            return;
        }

        $branches = $this->CollegeFeedback_model->getBranch($institute_id);
        echo json_encode($branches);
    }

    // ==================== INSERT ====================

    public function insertFeedbackURL()
    {
        $instituteId   = $this->input->post('fkInsitute_id');
        $feedbackForId = $this->input->post('fkfeedbackforid');
        $branchId      = $this->input->post('fkbranchid');
        $academicYear  = $this->input->post('academicyear');
        $url           = $this->input->post('generated_url');
        $isActive      = $this->input->post('is_active');
        
        // Validate
        if (!$instituteId || !$feedbackForId  || !$academicYear || !$url) {
            echo json_encode(array(
                'status'  => false,
                'message' => 'All fields are required'
            ));
            return;
        }
        
        $data = array(
            'institute_id'  => $instituteId,
            'feedbackforid' => $feedbackForId,
            'branchid'      => $branchId,
            'academicyear'  => $academicYear,
            'url'           => $url,
            'is_active'     => ($isActive == 1) ? 1 : 0
        );
        
        $result = $this->CollegeFeedback_model->saveGeneratedURL($data);
        
        if ($result['status']) {
            echo json_encode(array(
                'status'  => true,
                'message' => 'Data saved successfully',
                'url_id'  => $result['url_id']
            ));
        } else {
            echo json_encode(array(
                'status'  => false,
                'message' => 'Failed to save data'
            ));
        }
    }

    // ==================== UPDATE ====================

public function updateFeedbackURL()
{
    $urlId = $this->input->post('url_id');
    $isActive = $this->input->post('is_active');
    
    if (empty($urlId)) {
        echo json_encode(['status' => false, 'message' => 'Invalid ID']);
        return;
    }

    // Sirf status update karein agar aap chahte hain ki baki data change na ho
    $data = array(
        'is_active' => ($isActive == 1) ? 1 : 0,
        // 'modified_date' => date('Y-m-d H:i:s'), // Agar audit fields hain toh
    );
    
    $result = $this->CollegeFeedback_model->updateURL($urlId, $data);
    
    if ($result) {
        echo json_encode(['status' => true, 'message' => 'Status updated successfully']);
    } else {
        echo json_encode(['status' => false, 'message' => 'Failed to update status']);
    }
}

    // ==================== TOGGLE ACTIVE STATUS ====================

    public function toggleActiveStatus()
    {
        $url_id    = $this->input->post('url_id');
        $is_active = $this->input->post('is_active');
        
        if (!isset($url_id)) {
            echo json_encode(array(
                'status'  => false,
                'message' => 'URL ID is required'
            ));
            return;
        }
        
        $result = $this->CollegeFeedback_model->toggleActiveStatus($url_id, $is_active);
        
        if ($result) {
            echo json_encode(array(
                'status'  => true,
                'message' => 'Status updated successfully'
            ));
        } else {
            echo json_encode(array(
                'status'  => false,
                'message' => 'Failed to update status'
            ));
        }
    }
}
?>