<?php
defined('BASEPATH') OR exit('No direct script access allowed');
 
class Course extends CI_Controller {
   
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Course_model');
        $this->load->library('upload');
        $this->load->model('Log_model');
        $this->load->helper('log');
        
        if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
        }
    }
    
    public function Dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/Course_dash_view.php');
        $this->load->view('admin/footer_view');
    }

    public function create()
    {
        $data['branchdata'] = $this->Course_model->getbranch();
        $data['yeardata'] = $this->Course_model->getyear();
        $data['activeYear'] = $this->Course_model->getActiveYear();
        
        // Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/Course_view.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function index()
    {
        // Load list view
        $data['alldata'] = $this->Course_model->getdetailview();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Course_detailview.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function insertCourse()
    {
        try {
            $this->output->set_content_type('application/json');
            
            // Get form data
            $fkbranch_id = $this->input->post('fkbranch_id');
            $finicial_Year = $this->input->post('finicial_Year');
            $Course_code = $this->input->post('Course_code');
            $Course_title = $this->input->post('Course_title');
            $Order_no = $this->input->post('Order_no');
            $status = $this->input->post('status');
            $fk_submenuId = $this->input->post('fk_submenuId');
            
            // Log received data for debugging
            log_message('debug', 'Status array received: ' . print_r($status, true));
            log_message('debug', 'Course_code count: ' . count($Course_code));
            
            // Validation
            if (empty($fkbranch_id)) {
                echo json_encode(['status' => 'error', 'message' => 'Please select Department']);
                return;
            }

            if (empty($finicial_Year)) {
                echo json_encode(['status' => 'error', 'message' => 'Please select Academic Year']);
                return;
            }

            if (empty($Course_code) || !is_array($Course_code)) {
                echo json_encode(['status' => 'error', 'message' => 'Course data is required']);
                return;
            }
            
            // Handle Excel file upload
            $excel_name = null;
            if (!empty($_FILES['excel_file']['name'])) {
                $upload_path = './uploads/excel/';
                
                if (!is_dir($upload_path)) {
                    mkdir($upload_path, 0777, true);
                }
                
                $config['upload_path'] = $upload_path;
                $config['allowed_types'] = 'xlsx|xls';
                $config['max_size'] = 10240;
                $config['file_name'] = 'course_excel_' . time() . '_' . $_FILES['excel_file']['name'];
                $config['overwrite'] = FALSE;
                
                $this->upload->initialize($config);
                
                if ($this->upload->do_upload('excel_file')) {
                    $upload_data = $this->upload->data();
                    $excel_name = $upload_data['file_name'];
                    log_message('debug', "Excel file uploaded: {$excel_name}");
                } else {
                    log_message('error', "Excel upload failed: " . $this->upload->display_errors());
                }
            }

            // Get institute
            $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
            $institute_id = $institute ? $institute->Institu_id : null;

            $inserted_count = 0;
            $failed_count = 0;
            $total_rows = count($Course_code);

            // Create status map
            $status_map = array();
            if (is_array($status)) {
                foreach ($status as $checked_index => $value) {
                    if ($value == '1') {
                        $status_map[$checked_index] = 1;
                    }
                }
            }
            
            log_message('debug', 'Status map created: ' . print_r($status_map, true));

            // Insert all course records
            for ($i = 0; $i < $total_rows; $i++) {
                // Skip empty rows
                if (empty($Course_code[$i]) && empty($Course_title[$i])) {
                    continue;
                }
                
                // Check if this row's checkbox was checked
                $status_value = isset($status_map[$i]) && $status_map[$i] == 1 ? 1 : 0;
                
                log_message('debug', "Row {$i}: Status = {$status_value}");
                
                // Prepare data for insertion
                $courseData = array(
                    'fkbranch_id' => $fkbranch_id,
                    'finicial_Year' => $finicial_Year,
                    'Course_code' => isset($Course_code[$i]) && !empty($Course_code[$i]) ? $Course_code[$i] : null,
                    'Course_title' => isset($Course_title[$i]) && !empty($Course_title[$i]) ? $Course_title[$i] : null,
                    'Order_no' => isset($Order_no[$i]) && !empty($Order_no[$i]) ? $Order_no[$i] : null,
                    'status' => $status_value,
                    'institute' => $institute_id,
                    'excel_file' => $excel_name,
                    'is_on' => 1,
                    'is_active' => 1,
                    'created_date' => date('Y-m-d H:i:s'),
                    'created_by' => $this->session->userdata('userID')
                );

                log_message('debug', "Inserting row {$i}: " . print_r($courseData, true));

                // Insert into database
                $inserted_id = $this->Course_model->insertCourse($courseData);

                if ($inserted_id) {
                    $inserted_count++;

                    // Insert log
                    if (!empty($fk_submenuId)) {
                        $action = 1;
                        $record_id = $inserted_id;
                        $Fk_branch = $fkbranch_id;

                        insert_log(
                            $this,
                            $fk_submenuId,
                            $action,
                            $record_id,
                            null,
                            $Fk_branch,
                            $this->session->userdata('userID')
                        );
                    }
                } else {
                    $failed_count++;
                    log_message('error', "Failed to insert row {$i}");
                }
            }

            // Response
            if ($inserted_count > 0) {
                $message = "Successfully saved {$inserted_count} out of {$total_rows} course records";
                if ($failed_count > 0) {
                    $message .= ". {$failed_count} records failed.";
                }
                
                echo json_encode([
                    'status' => 'success', 
                    'inserted_count' => $inserted_count,
                    'failed_count' => $failed_count,
                    'total_rows' => $total_rows,
                    'message' => $message
                ]);
            } else {
                echo json_encode([
                    'status' => 'error', 
                    'message' => "No records were saved"
                ]);
            }
            
        } catch (Exception $e) {
            log_message('error', 'Course insertion error: ' . $e->getMessage());
            echo json_encode(['status' => 'error', 'message' => 'Server error: ' . $e->getMessage()]);
        }
    }

    public function update($Course_id)
    {
        // Get existing record
        $data['record'] = $this->Course_model->getCourseById($Course_id);
        
        if (empty($data['record'])) {
            show_error('Course not found', 404);
            return;
        }
        
        $data['branchdata'] = $this->Course_model->getbranch();
        $data['yeardata'] = $this->Course_model->getyear();
        $data['activeYear'] = $this->Course_model->getActiveYear();
        
        $current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
        $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/Course_view.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function updateCourse()
    {
        try {
            $this->output->set_content_type('application/json');
            
            // Get Course ID
            $Course_id = $this->input->post('Course_id');
            
            // Debug logs
            log_message('debug', 'Course_id received: ' . $Course_id);
            log_message('debug', 'All POST data: ' . print_r($this->input->post(), true));
            
            if (empty($Course_id)) {
                echo json_encode(['status' => 'error', 'message' => 'Course ID is required']);
                return;
            }
            
            // Get existing record
            $existing_record = $this->Course_model->getCourseById($Course_id);
            
            if (empty($existing_record)) {
                echo json_encode(['status' => 'error', 'message' => 'Course not found']);
                return;
            }
            
            // Get form data
            $fkbranch_id = $this->input->post('fkbranch_id');
            $finicial_Year = $this->input->post('finicial_Year');
            $Course_code = $this->input->post('Course_code');
            $Course_title = $this->input->post('Course_title');
            $Order_no = $this->input->post('Order_no');
            $status = $this->input->post('status');
            $fk_submenuId = $this->input->post('fk_submenuId');
            
            log_message('debug', 'Status received in update: ' . print_r($status, true));
            
            // Proper checkbox handling for UPDATE mode
            $status_value = 0;
            if (is_array($status) && !empty($status)) {
                if (isset($status[0]) && $status[0] == '1') {
                    $status_value = 1;
                }
            }
            
            log_message('debug', "Final status value for update: {$status_value}");
            
            // Handle Excel file if uploaded
            $excel_name = $existing_record->excel_file;
            
            if (!empty($_FILES['excel_file']['name'])) {
                $upload_path = './uploads/excel/';
                
                if (!is_dir($upload_path)) {
                    mkdir($upload_path, 0777, true);
                }
                
                $config = [
                    'upload_path' => $upload_path,
                    'allowed_types' => 'xlsx|xls',
                    'max_size' => 10240,
                    'file_name' => 'course_excel_' . time() . '_' . $_FILES['excel_file']['name'],
                    'overwrite' => FALSE
                ];
                
                $this->upload->initialize($config);
                
                if ($this->upload->do_upload('excel_file')) {
                    $upload_data = $this->upload->data();
                    $excel_name = $upload_data['file_name'];
                    
                    // Delete old excel file
                    if (!empty($existing_record->excel_file)) {
                        $old_file = $upload_path . $existing_record->excel_file;
                        if (file_exists($old_file)) {
                            @unlink($old_file);
                        }
                    }
                    
                    log_message('debug', "Excel file updated: {$excel_name}");
                } else {
                    log_message('error', "Excel upload failed: " . $this->upload->display_errors());
                }
            }
            
            // Prepare update data - Keep old values if new values are empty
            $updateData = array(
                'fkbranch_id' => !empty($fkbranch_id) ? $fkbranch_id : $existing_record->fkbranch_id,
                'finicial_Year' => !empty($finicial_Year) ? $finicial_Year : $existing_record->finicial_Year,
                'Course_code' => isset($Course_code[0]) && !empty($Course_code[0]) ? $Course_code[0] : $existing_record->Course_code,
                'Course_title' => isset($Course_title[0]) && !empty($Course_title[0]) ? $Course_title[0] : $existing_record->Course_title,
                'Order_no' => isset($Order_no[0]) && !empty($Order_no[0]) ? $Order_no[0] : $existing_record->Order_no,
                'status' => $status_value,
                'excel_file' => $excel_name,
                'modified_date' => date('Y-m-d H:i:s'),
                'modified_by' => $this->session->userdata('userID')
            );
            
            log_message('debug', 'Update data: ' . print_r($updateData, true));
            
            // Update record
            if ($this->Course_model->updateCourse($Course_id, $updateData)) {
                // Insert log
                if (!empty($fk_submenuId)) {
                    $action = 2;
                    $record_id = $Course_id;
                    $Fk_branch = $updateData['fkbranch_id'];
                    
                    insert_log(
                        $this, 
                        $fk_submenuId, 
                        $action, 
                        $record_id, 
                        null, 
                        $Fk_branch,
                        $this->session->userdata('userID')
                    );
                }
                
                echo json_encode([
                    'status' => 'success',
                    'message' => 'Course updated successfully!'
                ]);
            } else {
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Failed to update Course'
                ]);
            }
            
        } catch (Exception $e) {
            log_message('error', 'Course update error: ' . $e->getMessage());
            echo json_encode(['status' => 'error', 'message' => 'Server error: ' . $e->getMessage()]);
        }
    }

    public function delete($Course_id)
    {
        try {
            if ($this->Course_model->deleteCourse($Course_id)) {
                $this->session->set_flashdata('success', 'Course deleted successfully!');
            } else {
                $this->session->set_flashdata('error', 'Failed to delete Course!');
            }
        } catch (Exception $e) {
            $this->session->set_flashdata('error', 'Error: ' . $e->getMessage());
        }
        
        redirect('admin/Course/index');
    }
}
?>