<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class FeedbackFor extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('FeedbackFor_model');

        if (empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
        }
    }

    // ==================== PAGE LOAD FUNCTIONS ====================

    // List page
    public function index()
    {
        $data['alldata'] = $this->FeedbackFor_model->getAllFeedbackFor();

        $this->load->view('admin/header_view');
        $this->load->view('admin/FeedbackFor_detailview', $data);
        $this->load->view('admin/footer_view');
    }

    // Create (Add new) page
    public function create()
    {
        $data['answertypedata'] = $this->FeedbackFor_model->getAnswerType();

        $this->load->view('admin/header_view');
        $this->load->view('admin/FeedbackFor_view', $data);
        $this->load->view('admin/footer_view');
    }

    // Edit (Update) page
    public function update()
    {
        $id = $this->uri->segment(4);
        $data['data'] = $this->FeedbackFor_model->getbyid($id);
        $data['answertypedata'] = $this->FeedbackFor_model->getAnswerType();
        
        // Get selected answer types for this feedback for
        $data['selected_answertypes'] = $this->FeedbackFor_model->getSelectedAnswerTypes($id);

        $this->load->view('admin/header_view');
        $this->load->view('admin/FeedbackFor_view', $data);
        $this->load->view('admin/footer_view');
    }

    // ==================== INSERT ====================

    public function insertFeedbackFor()
    {
        $feedbackForName = trim($this->input->post('feedbackforname'));
        $answerTypes     = $this->input->post('answertypes'); // Array of answer type IDs
        $questionPerPage = $this->input->post('questionperpage');
       
       
        // Validate
        if (!$feedbackForName) {
            echo json_encode(array(
                'status'  => false,
                'message' => 'Feedback For Name is required'
            ));
            return;
        }
        
        if (empty($answerTypes) || !is_array($answerTypes)) {
            echo json_encode(array(
                'status'  => false,
                'message' => 'Please select at least one Answer Type'
            ));
            return;
        }
        
        // Check duplicate
        if ($this->FeedbackFor_model->checkDuplicateFeedbackFor($feedbackForName)) {
            echo json_encode(array(
                'status'  => false,
                'message' => 'This Feedback For name already exists'
            ));
            return;
        }
        
        $data = array(
            'feedbackforname' => $feedbackForName,
            'questionperpage' => $questionPerPage
           
    
        );
        
        $result = $this->FeedbackFor_model->insertFeedbackFor($data, $answerTypes);
        
        if ($result['status']) {
            echo json_encode(array(
                'status'  => true,
                'message' => 'Feedback For added successfully',
                'id'      => $result['feedbackid']
            ));
        } else {
            echo json_encode(array(
                'status'  => false,
                'message' => 'Failed to add Feedback For'
            ));
        }
    }

    // ==================== UPDATE ====================

    public function updateFeedbackFor()
    {
        $feedbackForId   = $this->input->post('feedbackid');
        $feedbackForName = trim($this->input->post('feedbackforname'));
        $answerTypes     = $this->input->post('answertypes'); // Array of answer type IDs
        $questionPerPage = $this->input->post('questionperpage');
        
        if (empty($feedbackForId)) {
            echo json_encode(['status' => false, 'message' => 'Invalid ID']);
            return;
        }

        // Validate
        if (!$feedbackForName) {
            echo json_encode(array(
                'status'  => false,
                'message' => 'Feedback For Name is required'
            ));
            return;
        }
        
        if (empty($answerTypes) || !is_array($answerTypes)) {
            echo json_encode(array(
                'status'  => false,
                'message' => 'Please select at least one Answer Type'
            ));
            return;
        }
        
        // Check duplicate
        if ($this->FeedbackFor_model->checkDuplicateFeedbackFor($feedbackForName, $feedbackForId)) {
            echo json_encode(array(
                'status'  => false,
                'message' => 'This Feedback For name already exists'
            ));
            return;
        }

        $data = array(
            'feedbackforname' => $feedbackForName,
            'questionperpage' => $questionPerPage
           
        );
        
        
        $result = $this->FeedbackFor_model->updateFeedbackFor($feedbackForId, $data, $answerTypes);
        
        if ($result) {
            echo json_encode(['status' => true, 'message' => 'Feedback For updated successfully']);
        } else {
            echo json_encode(['status' => false, 'message' => 'Failed to update Feedback For']);
        }
    }

    // ==================== TOGGLE ACTIVE STATUS ====================

    public function toggleActiveStatus()
    {
        $feedbackfor_id = $this->input->post('feedbackid');
        $is_active      = $this->input->post('is_active');
        
        if (!isset($feedbackfor_id)) {
            echo json_encode(array(
                'status'  => false,
                'message' => 'ID is required'
            ));
            return;
        }
        
        $result = $this->FeedbackFor_model->toggleActiveStatus($feedbackfor_id, $is_active);
        
        if ($result) {
            echo json_encode(array(
                'status'  => true,
                'message' => 'Status updated successfully'
            ));
        } else {
            echo json_encode(array(
                'status'  => false,
                'message' => 'Failed to update status'
            ));
        }
    }
}
?>