<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class FeedbackReport extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('FeedbackReport_model');
        $this->load->helper('url');
    }

    /**
     * Print view - opens in new tab with table
     * @param int $url_id
     */
    public function print_view($url_id = null)
    {
        // Validate URL ID
        if (empty($url_id) || !is_numeric($url_id)) {
            show_error('Invalid URL ID provided', 400);
            return;
        }

        // Get complete report data from model
        $data = $this->FeedbackReport_model->get_report_data($url_id);
        
        if (!$data) {
            show_error('Feedback data not found', 404);
            return;
        }

        // Load views with header and footer
        $this->load->view('admin/header_view');
        $this->load->view('admin/FeedbackReport_view', $data);
        $this->load->view('admin/footer_view');
    }
}
?>