<?php
defined('BASEPATH') OR exit('No direct script access allowed');
 
class Grantrec extends CI_Controller {
   
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Grantrec_model');
        $this->load->library('upload');
        $this->load->model('Log_model');
        $this->load->helper('log');
           if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
    }
    
    public function Dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/Grantrec_dash_view.php');
        $this->load->view('admin/footer_view');
    }

    public function create()
    {
        $data['facultydata'] = $this->Grantrec_model->getfaculty();
        $data['branchdata'] = $this->Grantrec_model->getbranch();
        $data['institutedata'] = $this->Grantrec_model->getinstitute();
        $data['granttypedata'] = $this->Grantrec_model->getgranttype();
        $data['yeardata'] = $this->Grantrec_model->getyear();
        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/Grantrec_view.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function index()
    {
        $data['alldata'] = $this->Grantrec_model->getdetailview();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Grantrec_detailview.php', $data);
        $this->load->view('admin/footer_view');
    }

   public function insertGrantrec()
{
    // Clean output buffer to prevent HTML errors
    if (ob_get_level()) ob_clean();
    
    header('Content-Type: application/json');
    
    try {
        // Get POST data
        $fkfac_id = $this->input->post('fkfac_id') ?: [];
        $fkbranch_id = $this->input->post('fkbranch_id') ?: [];
        $institute = $this->input->post('institute') ?: [];
        $Grant_date = $this->input->post('Grant_date') ?: [];
        $description = $this->input->post('description') ?: [];
        $fkgranttype_id = $this->input->post('fkgranttype_id') ?: [];
        $Amount_rec = $this->input->post('Amount_rec') ?: [];
        $finicial_Year = $this->input->post('finicial_Year') ?: [];
        $fk_submenuId = $this->input->post('fk_submenuId');

        // Get file indices
        $approval_indices = $this->input->post('approval_indices') ?: [];
        $other_indices = $this->input->post('other_indices') ?: [];

        // Validation
        if (empty($fkbranch_id) || !is_array($fkbranch_id)) {
            echo json_encode(['status' => 'error', 'message' => 'At least one grant record is required']);
            return;
        }

        // Get new master data
        $new_faculties = json_decode($this->input->post('new_faculties'), true) ?: [];
        $new_branches = json_decode($this->input->post('new_branches'), true) ?: [];
        $new_institutes = json_decode($this->input->post('new_institutes'), true) ?: [];
        $new_granttypes = json_decode($this->input->post('new_granttypes'), true) ?: [];
        $new_years = json_decode($this->input->post('new_years'), true) ?: [];
        
        // Create mappings
        $faculty_mapping = [];
        $branch_mapping = [];
        $institute_mapping = [];
        $granttype_mapping = [];
        $year_mapping = [];
        
        $masters_created = [
            'faculties' => 0, 'branches' => 0, 'institutes' => 0,
            'granttypes' => 0, 'years' => 0
        ];

        // Insert new faculties
        foreach ($new_faculties as $name) {
            if (empty($name)) continue;
            $existing = $this->Grantrec_model->getFacultyIdByName($name);
            if ($existing) {
                $faculty_mapping['NEW::' . $name] = $existing;
            } else {
                $id = $this->Grantrec_model->insertFaculty([
                    'fac_Fullname' => $name,
                    'is_active' => 1,
                    'created_date' => date('Y-m-d H:i:s')
                ]);
                if ($id) {
                    $faculty_mapping['NEW::' . $name] = $id;
                    $masters_created['faculties']++;
                }
            }
        }
        
        // Insert new branches
        foreach ($new_branches as $name) {
            if (empty($name)) continue;
            $existing = $this->Grantrec_model->getBranchIdByName($name);
            if ($existing) {
                $branch_mapping['NEW::' . $name] = $existing;
            } else {
                $id = $this->Grantrec_model->insertBranch([
                    'branch_name' => $name,
                    'is_active' => 1,
                    'created_date' => date('Y-m-d H:i:s')
                ]);
                if ($id) {
                    $branch_mapping['NEW::' . $name] = $id;
                    $masters_created['branches']++;
                }
            }
        }

        // Insert new institutes
        foreach ($new_institutes as $name) {
            if (empty($name)) continue;
            $existing = $this->Grantrec_model->getinstituteIdByName($name);
            if ($existing) {
                $institute_mapping['NEW::' . $name] = $existing;
            } else {
                $id = $this->Grantrec_model->insertinstitute([
                    'Institu_name' => $name,
                    'is_active' => 1,
                    'created_date' => date('Y-m-d H:i:s')
                ]);
                if ($id) {
                    $institute_mapping['NEW::' . $name] = $id;
                    $masters_created['institutes']++;
                }
            }
        }
        
        // Insert new grant types
        foreach ($new_granttypes as $name) {
            if (empty($name)) continue;
            $existing = $this->Grantrec_model->getGranttypeIdByName($name);
            if ($existing) {
                $granttype_mapping['NEW::' . $name] = $existing;
            } else {
                $id = $this->Grantrec_model->insertGranttype([
                    'granttype_name' => $name,
                    'is_active' => 1,
                    'created_date' => date('Y-m-d H:i:s')
                ]);
                if ($id) {
                    $granttype_mapping['NEW::' . $name] = $id;
                    $masters_created['granttypes']++;
                }
            }
        }
        
        // Insert new years
        foreach ($new_years as $name) {
            if (empty($name)) continue;
            $existing = $this->Grantrec_model->getYearIdByName($name);
            if ($existing) {
                $year_mapping['NEW::' . $name] = $existing;
            } else {
                $id = $this->Grantrec_model->insertYear([
                    'fini_Label' => $name,
                    'is_active' => 1,
                    'created_date' => date('Y-m-d H:i:s')
                ]);
                if ($id) {
                    $year_mapping['NEW::' . $name] = $id;
                    $masters_created['years']++;
                }
            }
        }

        // Handle Excel file
        $excel_name = null;
        if (!empty($_FILES['excel_file']['name'])) {
            $upload_path = './uploads/excel/';
            if (!is_dir($upload_path)) mkdir($upload_path, 0777, true);
            
            $config = [
                'upload_path' => $upload_path,
                'allowed_types' => 'xlsx|xls',
                // 'max_size' => 10240,
                'file_name' => 'grantrec_' . time() . '_' . $_FILES['excel_file']['name']
            ];
            
            $this->upload->initialize($config);
            if ($this->upload->do_upload('excel_file')) {
                $excel_name = $this->upload->data('file_name');
            }
        }

        // Process file uploads
        $approval_files = [];
        $other_files = [];
        
        // Handle Approval letters
        if (!empty($_FILES['Approval_letter']['name'])) {
            $file_count = count($_FILES['Approval_letter']['name']);
            
            for ($i = 0; $i < $file_count; $i++) {
                if (empty($_FILES['Approval_letter']['name'][$i])) continue;
                
                $_FILES['temp_file'] = [
                    'name' => $_FILES['Approval_letter']['name'][$i],
                    'type' => $_FILES['Approval_letter']['type'][$i],
                    'tmp_name' => $_FILES['Approval_letter']['tmp_name'][$i],
                    'error' => $_FILES['Approval_letter']['error'][$i],
                    'size' => $_FILES['Approval_letter']['size'][$i]
                ];
                
                $upload_path = './uploads/letters/Approval/';
                if (!is_dir($upload_path)) mkdir($upload_path, 0777, true);
                
                $config = [
                    'upload_path' => $upload_path,
                    'allowed_types' => 'pdf|doc|docx',
                    'file_name' => 'approval_' . time() . '_' . $i . '_' . $_FILES['Approval_letter']['name'][$i],
                    'max_size' => 5120
                ];
                
                $this->upload->initialize($config);
                if ($this->upload->do_upload('temp_file')) {
                    $row_index = isset($approval_indices[$i]) ? $approval_indices[$i] : $i;
                    $approval_files[$row_index] = $this->upload->data('file_name');
                }
            }
        }

        // Handle Other documents
        if (!empty($_FILES['Other_doc']['name'])) {
            $file_count = count($_FILES['Other_doc']['name']);
            
            for ($i = 0; $i < $file_count; $i++) {
                if (empty($_FILES['Other_doc']['name'][$i])) continue;
                
                $_FILES['temp_file'] = [
                    'name' => $_FILES['Other_doc']['name'][$i],
                    'type' => $_FILES['Other_doc']['type'][$i],
                    'tmp_name' => $_FILES['Other_doc']['tmp_name'][$i],
                    'error' => $_FILES['Other_doc']['error'][$i],
                    'size' => $_FILES['Other_doc']['size'][$i]
                ];
                
                $upload_path = './uploads/letters/Other_doc/';
                if (!is_dir($upload_path)) mkdir($upload_path, 0777, true);
                
                $config = [
                    'upload_path' => $upload_path,
                    'allowed_types' => 'pdf|doc|docx',
                    'file_name' => 'other_' . time() . '_' . $i . '_' . $_FILES['Other_doc']['name'][$i],
                    // 'max_size' => 5120
                ];
                
                $this->upload->initialize($config);
                if ($this->upload->do_upload('temp_file')) {
                    $row_index = isset($other_indices[$i]) ? $other_indices[$i] : $i;
                    $other_files[$row_index] = $this->upload->data('file_name');
                }
            }
        }

        // Insert records
        $inserted = 0;
        $failed = 0;
        $total = count($fkbranch_id);

        for ($i = 0; $i < $total; $i++) {
            $branch_id = $fkbranch_id[$i];
            if (empty($branch_id)) {
                $failed++;
                continue;
            }

            // Resolve IDs
            $faculty_id = isset($fkfac_id[$i]) ? $fkfac_id[$i] : null;
            if ($faculty_id && strpos($faculty_id, 'NEW::') === 0) {
                $faculty_id = isset($faculty_mapping[$faculty_id]) ? $faculty_mapping[$faculty_id] : null;
            }
            
            if (strpos($branch_id, 'NEW::') === 0) {
                if (!isset($branch_mapping[$branch_id])) {
                    $failed++;
                    continue;
                }
                $branch_id = $branch_mapping[$branch_id];
            }

            $institute_id = isset($institute[$i]) ? $institute[$i] : null;
            if ($institute_id && strpos($institute_id, 'NEW::') === 0) {
                $institute_id = isset($institute_mapping[$institute_id]) ? $institute_mapping[$institute_id] : null;
            }
            
            $granttype_id = isset($fkgranttype_id[$i]) ? $fkgranttype_id[$i] : null;
            if ($granttype_id && strpos($granttype_id, 'NEW::') === 0) {
                $granttype_id = isset($granttype_mapping[$granttype_id]) ? $granttype_mapping[$granttype_id] : null;
            }
            
            $year_id = isset($finicial_Year[$i]) ? $finicial_Year[$i] : null;
            if ($year_id && strpos($year_id, 'NEW::') === 0) {
                $year_id = isset($year_mapping[$year_id]) ? $year_mapping[$year_id] : null;
            }

            // Prepare data
            $data = [
                'fkfac_id' => $faculty_id,
                'fkbranch_id' => $branch_id,
                'institute' => $institute_id,
                'Grant_date' => isset($Grant_date[$i]) && !empty($Grant_date[$i]) ? $Grant_date[$i] : null,
                'description' => isset($description[$i]) && !empty($description[$i]) ? $description[$i] : null,
                'fkgranttype_id' => $granttype_id,
                'Amount_rec' => isset($Amount_rec[$i]) && !empty($Amount_rec[$i]) ? $Amount_rec[$i] : null,
                'finicial_Year' => $year_id,
                'Approval_letter' => isset($approval_files[$i]) ? $approval_files[$i] : null,
                'Other_doc' => isset($other_files[$i]) ? $other_files[$i] : null,
                'excel_file' => $excel_name,
                'is_on' => 1,
                'is_active' => 1,
                'created_date' => date('Y-m-d H:i:s'),
                'created_by'=>$_SESSION['userID']
            ];
$inserted_id = $this->Grantrec_model->insertGrantRec($data);

if ($inserted_id) {

    $inserted++;   // counter
    // $sub_id = $inserted_id;

    // Insert log - Action 1 (Insert)
    $action = 1;
    $record_id = $inserted_id;
    $excel_name = null;
    $Fk_branch = $branch_id;

    insert_log(
        $this,
        $fk_submenuId,
        $action,
        $record_id,
        $excel_name,
        $Fk_branch,
        $_SESSION['userID']
    );
}


            // if ($this->Grantrec_model->insertGrantRec($data)) {
            //     $inserted++;
            // } 
            
            else {
                $failed++;
            }
        }

        if ($inserted > 0) {
            echo json_encode([
                'status' => 'success',
                'message' => "Saved {$inserted}/{$total} records successfully",
                'inserted' => $inserted,
                'failed' => $failed,
                'masters_created' => $masters_created
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => "No records saved. Total: {$total}, Failed: {$failed}"
            ]);
        }
        
    } catch (Exception $e) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Server error: ' . $e->getMessage()
        ]);
    }
}

    public function update($Grant_id)
    {
        $data['record'] = $this->Grantrec_model->getGrantRecById($Grant_id);
        $data['facultydata'] = $this->Grantrec_model->getfaculty();
        $data['branchdata'] = $this->Grantrec_model->getbranch();
        $data['institutedata'] = $this->Grantrec_model->getinstitute();
        $data['granttypedata'] = $this->Grantrec_model->getgranttype();
        $data['yeardata'] = $this->Grantrec_model->getyear();
        
$current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/Grantrec_view.php', $data);
        $this->load->view('admin/footer_view');
    }

   

public function updateGrantrec()
{
    // Clean output buffer
    if (ob_get_level()) ob_clean();
    
    header('Content-Type: application/json');
    
    // DEBUG: Log incoming data
    log_message('debug', 'Update Request - POST: ' . print_r($_POST, true));
    log_message('debug', 'Update Request - FILES: ' . print_r($_FILES, true));
    
    try {
        // Get Grant ID
        $Grant_id = $this->input->post('Grant_id');
        
        log_message('debug', 'Grant_id: ' . $Grant_id);
        
        if (empty($Grant_id)) {
            echo json_encode(['status' => 'error', 'message' => 'Grant ID is required']);
            return;
        }
        
        // Get existing record
        $existing_record = $this->Grantrec_model->getGrantRecById($Grant_id);
        if (!$existing_record) {
            echo json_encode(['status' => 'error', 'message' => 'Record not found']);
            return;
        }
        
        // Get POST data
        $fkfac_id = $this->input->post('fkfac_id') ?: [];
        $fkbranch_id = $this->input->post('fkbranch_id') ?: [];
        $institute = $this->input->post('institute') ?: [];
        $Grant_date = $this->input->post('Grant_date') ?: [];
        $description = $this->input->post('description') ?: [];
        $fkgranttype_id = $this->input->post('fkgranttype_id') ?: [];
        $Amount_rec = $this->input->post('Amount_rec') ?: [];
        $finicial_Year = $this->input->post('finicial_Year') ?: [];
        $fk_submenuId = $this->input->post('fk_submenuId');
        // Validation
        if (empty($fkbranch_id[0])) {
            echo json_encode(['status' => 'error', 'message' => 'Branch is required']);
            return;
        }

        // Get new master data
        $new_faculties = json_decode($this->input->post('new_faculties'), true) ?: [];
        $new_branches = json_decode($this->input->post('new_branches'), true) ?: [];
        $new_institutes = json_decode($this->input->post('new_institutes'), true) ?: [];
        $new_granttypes = json_decode($this->input->post('new_granttypes'), true) ?: [];
        $new_years = json_decode($this->input->post('new_years'), true) ?: [];
        
        // Create mappings
        $faculty_mapping = [];
        $branch_mapping = [];
        $institute_mapping = [];
        $granttype_mapping = [];
        $year_mapping = [];
        
        $masters_created = [
            'faculties' => 0, 'branches' => 0, 'institutes' => 0,
            'granttypes' => 0, 'years' => 0
        ];

        // Insert new faculties
        foreach ($new_faculties as $name) {
            if (empty($name)) continue;
            $existing = $this->Grantrec_model->getFacultyIdByName($name);
            if ($existing) {
                $faculty_mapping['NEW::' . $name] = $existing;
            } else {
                $id = $this->Grantrec_model->insertFaculty([
                    'fac_Fullname' => $name,
                    'is_active' => 1,
                    'created_date' => date('Y-m-d H:i:s')
                ]);
                if ($id) {
                    $faculty_mapping['NEW::' . $name] = $id;
                    $masters_created['faculties']++;
                }
            }
        }
        
        // Insert new branches
        foreach ($new_branches as $name) {
            if (empty($name)) continue;
            $existing = $this->Grantrec_model->getBranchIdByName($name);
            if ($existing) {
                $branch_mapping['NEW::' . $name] = $existing;
            } else {
                $id = $this->Grantrec_model->insertBranch([
                    'branch_name' => $name,
                    'is_active' => 1,
                    'created_date' => date('Y-m-d H:i:s')
                ]);
                if ($id) {
                    $branch_mapping['NEW::' . $name] = $id;
                    $masters_created['branches']++;
                }
            }
        }

        // Insert new institutes
        foreach ($new_institutes as $name) {
            if (empty($name)) continue;
            $existing = $this->Grantrec_model->getinstituteIdByName($name);
            if ($existing) {
                $institute_mapping['NEW::' . $name] = $existing;
            } else {
                $id = $this->Grantrec_model->insertinstitute([
                    'Institu_name' => $name,
                    'is_active' => 1,
                    'created_date' => date('Y-m-d H:i:s')
                ]);
                if ($id) {
                    $institute_mapping['NEW::' . $name] = $id;
                    $masters_created['institutes']++;
                }
            }
        }
        
        // Insert new grant types
        foreach ($new_granttypes as $name) {
            if (empty($name)) continue;
            $existing = $this->Grantrec_model->getGranttypeIdByName($name);
            if ($existing) {
                $granttype_mapping['NEW::' . $name] = $existing;
            } else {
                $id = $this->Grantrec_model->insertGranttype([
                    'granttype_name' => $name,
                    'is_active' => 1,
                    'created_date' => date('Y-m-d H:i:s')
                ]);
                if ($id) {
                    $granttype_mapping['NEW::' . $name] = $id;
                    $masters_created['granttypes']++;
                }
            }
        }
        
        // Insert new years
        foreach ($new_years as $name) {
            if (empty($name)) continue;
            $existing = $this->Grantrec_model->getYearIdByName($name);
            if ($existing) {
                $year_mapping['NEW::' . $name] = $existing;
            } else {
                $id = $this->Grantrec_model->insertYear([
                    'fini_Label' => $name,
                    'is_active' => 1,
                    'created_date' => date('Y-m-d H:i:s')
                ]);
                if ($id) {
                    $year_mapping['NEW::' . $name] = $id;
                    $masters_created['years']++;
                }
            }
        }

        // Resolve IDs for first row (index 0)
        $faculty_id = isset($fkfac_id[0]) ? $fkfac_id[0] : null;
        if ($faculty_id && strpos($faculty_id, 'NEW::') === 0) {
            $faculty_id = isset($faculty_mapping[$faculty_id]) ? $faculty_mapping[$faculty_id] : null;
        }
        
        $branch_id = $fkbranch_id[0];
        if (strpos($branch_id, 'NEW::') === 0) {
            if (!isset($branch_mapping[$branch_id])) {
                echo json_encode(['status' => 'error', 'message' => 'Branch mapping failed']);
                return;
            }
            $branch_id = $branch_mapping[$branch_id];
        }

        $institute_id = isset($institute[0]) ? $institute[0] : null;
        if ($institute_id && strpos($institute_id, 'NEW::') === 0) {
            $institute_id = isset($institute_mapping[$institute_id]) ? $institute_mapping[$institute_id] : null;
        }
        
        $granttype_id = isset($fkgranttype_id[0]) ? $fkgranttype_id[0] : null;
        if ($granttype_id && strpos($granttype_id, 'NEW::') === 0) {
            $granttype_id = isset($granttype_mapping[$granttype_id]) ? $granttype_mapping[$granttype_id] : null;
        }
        
        $year_id = isset($finicial_Year[0]) ? $finicial_Year[0] : null;
        if ($year_id && strpos($year_id, 'NEW::') === 0) {
            $year_id = isset($year_mapping[$year_id]) ? $year_mapping[$year_id] : null;
        }

        // ============================================
        // CRITICAL FIX: FILE HANDLING
        // ============================================
        
        // Initialize with existing files
        $approval_letter = $existing_record->Approval_letter;
        $other_doc = $existing_record->Other_doc;
        
        log_message('debug', 'Existing Approval: ' . $approval_letter);
        log_message('debug', 'Existing Other: ' . $other_doc);
        
        // Handle Approval Letter Upload
        if (!empty($_FILES['Approval_letter']['name'][0])) {
            log_message('debug', 'Processing Approval Letter upload');
            
            $upload_path = './uploads/letters/Approval/';
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777, true);
            }
            
            // Set up temp file for upload
            $_FILES['temp_approval'] = [
                'name' => $_FILES['Approval_letter']['name'][0],
                'type' => $_FILES['Approval_letter']['type'][0],
                'tmp_name' => $_FILES['Approval_letter']['tmp_name'][0],
                'error' => $_FILES['Approval_letter']['error'][0],
                'size' => $_FILES['Approval_letter']['size'][0]
            ];
            
            $config = [
                'upload_path' => $upload_path,
                'allowed_types' => 'pdf|doc|docx',
                'file_name' => 'approval_' . time() . '_' . $_FILES['Approval_letter']['name'][0],
                // 'max_size' => 5120,
                'overwrite' => FALSE
            ];
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('temp_approval')) {
                $upload_data = $this->upload->data();
                
                // Delete old file if exists
                if ($approval_letter && file_exists($upload_path . $approval_letter)) {
                    unlink($upload_path . $approval_letter);
                    log_message('debug', 'Deleted old approval: ' . $approval_letter);
                }
                
                $approval_letter = $upload_data['file_name'];
                log_message('debug', 'New approval uploaded: ' . $approval_letter);
            } else {
                $error = $this->upload->display_errors('', '');
                log_message('error', 'Approval upload failed: ' . $error);
            }
        }

        // Handle Other Document Upload
        if (!empty($_FILES['Other_doc']['name'][0])) {
            log_message('debug', 'Processing Other Document upload');
            
            $upload_path = './uploads/letters/Other_doc/';
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777, true);
            }
            
            // Set up temp file for upload
            $_FILES['temp_other'] = [
                'name' => $_FILES['Other_doc']['name'][0],
                'type' => $_FILES['Other_doc']['type'][0],
                'tmp_name' => $_FILES['Other_doc']['tmp_name'][0],
                'error' => $_FILES['Other_doc']['error'][0],
                'size' => $_FILES['Other_doc']['size'][0]
            ];
            
            $config = [
                'upload_path' => $upload_path,
                'allowed_types' => 'pdf|doc|docx',
                'file_name' => 'other_' . time() . '_' . $_FILES['Other_doc']['name'][0],
                // 'max_size' => 5120,
                'overwrite' => FALSE
            ];
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('temp_other')) {
                $upload_data = $this->upload->data();
                
                // Delete old file if exists
                if ($other_doc && file_exists($upload_path . $other_doc)) {
                    unlink($upload_path . $other_doc);
                    log_message('debug', 'Deleted old other doc: ' . $other_doc);
                }
                
                $other_doc = $upload_data['file_name'];
                log_message('debug', 'New other doc uploaded: ' . $other_doc);
            } else {
                $error = $this->upload->display_errors('', '');
                log_message('error', 'Other doc upload failed: ' . $error);
            }
        }
        
        log_message('debug', 'Final Approval: ' . $approval_letter);
        log_message('debug', 'Final Other: ' . $other_doc);
        
        // Prepare update data
        $updateData = [
            'fkfac_id' => $faculty_id,
            'fkbranch_id' => $branch_id,
            'institute' => $institute_id,
            'Grant_date' => isset($Grant_date[0]) && !empty($Grant_date[0]) ? $Grant_date[0] : null,
            'description' => isset($description[0]) && !empty($description[0]) ? $description[0] : null,
            'fkgranttype_id' => $granttype_id,
            'Amount_rec' => isset($Amount_rec[0]) && !empty($Amount_rec[0]) ? $Amount_rec[0] : null,
            'finicial_Year' => $year_id,
            'Approval_letter' => $approval_letter,
            'Other_doc' => $other_doc,
            'modified_date' => date('Y-m-d H:i:s'),
            'modified_by'=>$_SESSION['userID']
        ];
        
        log_message('debug', 'Update Data: ' . print_r($updateData, true));
        
        // Update record
        if ($this->Grantrec_model->updateGrantRec($Grant_id, $updateData)) {
            // Insert log - Action 2 (Update)
        $action = 2;
        $record_id = $Grant_id;
        $excel_name = null;
        $Fk_branch = $branch_id;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);

            echo json_encode([
                'status' => 'success',
                'message' => 'Grant Record updated successfully!',
                'masters_created' => $masters_created,
                'files_updated' => [
                    'approval' => $approval_letter,
                    'other' => $other_doc
                ]
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to update Grant Record'
            ]);
        }
        
    } catch (Exception $e) {
        log_message('error', 'Update Exception: ' . $e->getMessage());
        echo json_encode([
            'status' => 'error',
            'message' => 'Server error: ' . $e->getMessage()
        ]);
    }
}
}