<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require_once(APPPATH . '../vendor/autoload.php'); // Load Composer packages

use PhpOffice\PhpSpreadsheet\IOFactory;

class GuestlecImport extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('GuestlecImport_model');
           if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
    }

    // Load Import View
    public function create()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/GuestlecImport_view');
        $this->load->view('admin/footer_view');
    }

    // Import Excel Logic
    public function importExcel()
    {
        try {
            if (!empty($_FILES['excel_file']['name'])) {
                $file = $_FILES['excel_file']['tmp_name'];

                // Load Excel
                $spreadsheet = IOFactory::load($file);
                $sheetData   = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

                $classMap = [];
                $classes = $this->db->get_where('classmaster', ['is_on' => 1, 'is_active' => 1])->result();
                foreach ($classes as $c) {
                    $classMap[strtolower(trim($c->classname))] = $c->class_id;
                }

                $insertData = [];

                foreach ($sheetData as $key => $row) {
                    if ($key == 1) continue; // Skip header row

                    // Clean and extract
                    $Guest_id     = trim($row['B'] ?? '');
                    $Guest_name   = trim($row['C'] ?? '');
                    $Expert_topic = !empty(trim($row['D'] ?? '')) ? trim($row['D']) : null;
                    $No_benefit   = !empty(trim($row['E'] ?? '')) ? trim($row['E']) : null;
                    $Talk_date    = !empty(trim($row['F'] ?? '')) ? trim($row['F']) : null;
                    $classStr     = strtolower(trim($row['P'] ?? ''));

                    // Skip if any required field missing
                    if (empty($Guest_id) || empty($Guest_name) || empty($Expert_topic) || empty($No_benefit) || empty($Talk_date) || empty($classStr)) {
                        continue;
                    }

                    // Check duplicate Guest_id
                    $exists = $this->db->get_where('guestlectures_master', ['Guest_id' => $Guest_id])->row();
                    if ($exists) continue;

                    // Class
                    if (!isset($classMap[$classStr])) {
                        $this->db->insert('classmaster', [
                            'classname' => ucfirst($classStr),
                            'is_on' => 1,
                            'is_active' => 1
                        ]);
                        $class_id = $this->db->insert_id();
                        $classMap[$classStr] = $class_id;
                    } else {
                        $class_id = $classMap[$classStr];
                    }

                    // Prepare row
                    $insertData[] = [
                        'Guest_id'     => $Guest_id,
                        'Guest_name'   => $Guest_name,
                        'Expert_topic' => $Expert_topic,
                        'No_benefit'   => $No_benefit,
                        'Talk_date'    => $Talk_date,
                        'fkclass_id'   => $class_id
                    ];
                }

                // Insert into DB
                if (!empty($insertData)) {
                    $this->GuestlecImport_model->insert_batch($insertData);
                    echo json_encode(['status' => 'success', 'message' => 'Excel data imported successfully']);
                } else {
                    echo json_encode(['status' => 'error', 'message' => 'No valid data found in Excel']);
                }

            } else {
                echo json_encode(['status' => 'error', 'message' => 'No file uploaded']);
            }
        } catch (Exception $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
    }
}
