<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Honor_MinorReport extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Honor_MinorReport_model');
           if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
    }

   
    public function create()
	{
  $data['honor_minor_types'] = $this->Honor_MinorReport_model->gethonor();
  $data['institutedata'] = $this->Honor_MinorReport_model->getinstitu();
$data['yeardata'] = $this->Honor_MinorReport_model->getyear();
 $data['branchdata'] = $this->Honor_MinorReport_model->getbranch();

$activeYear = $this->db
    ->select('finiYear_id')
    ->from('finiyear_master')
    ->where('Active_Deactive', 1)
    ->get()
    ->row();

$data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
        
        //  echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
		$this->load->view('admin/Honor_MinorReport_view',$data);
		$this->load->view('admin/footer_view');
	

	}



public function showDataByInstitute()
{
    $institute_id = $this->input->post('fk_institu');
    $year = $this->input->post('year');
  $typeids = $this->input->post('fk_honor_minor_type'); 
$branch_ids = $this->input->post('fkbranch_id'); 

    $data = $this->Honor_MinorReport_model->getDataByInstitute(
        $institute_id,
        $year,
        $branch_ids,
        $typeids
        
    );

    echo json_encode($data);
}

// for print
public function getPrintHeadings()
{
    $data = $this->Honor_MinorReport_model->getPrintHeadings();
    echo json_encode($data);
}



//  public function getYearwiseData()
// {
//     $year      = $this->input->post('year');
//     $branches  = $this->input->post('branches');   // may be an array
    
 
//     if ($year == "0" || empty($year)) {
//         // All years
//         $summary = $this->Honor_MinorReport_model->getAllYearsData();
//         $types   = [];
//     } else {
//         // Single year — pass all filters
//         $summary = $this->Honor_MinorReport_model->getSingleYearData($year, $branches);
//         $types   = $this->Honor_MinorReport_model->getYearwiseTypes($year,$branches);
//     }
 
//     echo json_encode([
//         "status"  => "success",
//         "summary" => $summary,
//         "types"   => $types
//     ]);
// }
 
 
 
// // Add these methods to your VAPReport controller
 
// public function getBranchwiseData()
// {
//     $institu   = $this->input->post('fk_institu'); // match JS
//     $branches  = $this->input->post('fkBranchName_id'); // match JS
//     $year      = $this->input->post('year');
   
 
//     $result = $this->Honor_MinorReport_model->getBranchwiseCount($institu, $branches, $year);
//     echo json_encode($result);
// }
 
// public function getBranchDetails()
// {
//     $branch_id = $this->input->post('branch_id'); // correct
//     $institu   = $this->input->post('fkBranchName_id'); // match JS
//     $year      = $this->input->post('year');
  
//     $result = $this->Honor_MinorReport_model->getBranchDetailsData($branch_id, $institu, $year);
//     echo json_encode($result);
// }
 
 
// public function getCombinedData()
// {
//     $institu   = $this->input->post('fk_institu');
//     // $branches  = $this->input->post('branches');   // ❌ Commented - not using
//     $years     = $this->input->post('years');
  
//     $result = $this->Honor_MinorReport_model->getCombinedData($institu, [], $years); // Empty array for branches
 
//     echo json_encode([
//         "status"      => "success",
//         // "branchData"  => $result['branchData'], // ❌ Commented - not needed
//         "yearData"    => $result['yearData']
//     ]);
// }
 
public function getStudentList()
{
    $fk_honor_minor_id = $this->input->post('fk_honor_minor_id');
    if (!$fk_honor_minor_id) {
        echo json_encode([]);
        return;
    }
 
    // $this->load->model('ParentMeet_model');
    $students = $this->Honor_MinorReport_model->getStudentsByMeetId($fk_honor_minor_id);
 
    echo json_encode($students);
}


 public function getYearwiseData()
{
    $year      = $this->input->post('year');
    $branches  = $this->input->post('branches');   // branch filter
    
    if ($year == "0" || empty($year)) {
        // All years with branch filter
        $summary = $this->Honor_MinorReport_model->getAllYearsData($branches);
        $types   = [];
    } else {
        // Single year with branch filter
        $summary = $this->Honor_MinorReport_model->getSingleYearData($year, $branches);
        $types   = $this->Honor_MinorReport_model->getYearwiseTypes($year, $branches);
    }
 
    echo json_encode([
        "status"  => "success",
        "summary" => $summary,
        "types"   => $types
    ]);
}

public function getBranchwiseData()
{
    $institu   = $this->input->post('fk_institu');
    $branches  = $this->input->post('branches'); // updated parameter name
    $year      = $this->input->post('year');
 
    $result = $this->Honor_MinorReport_model->getBranchwiseCount($institu, $branches, $year);
    echo json_encode($result);
}

public function getBranchDetails()
{
    $branch_id = $this->input->post('branch_id');
    $institu   = $this->input->post('fk_institu');
    $year      = $this->input->post('year');
  
    $result = $this->Honor_MinorReport_model->getBranchDetailsData($branch_id, $institu, $year);
    echo json_encode($result);
}

public function getCombinedData()
{
    $institu   = $this->input->post('fk_institu');
    $branches  = $this->input->post('branches');  // branch filter added
    $years     = $this->input->post('years');
  
    $result = $this->Honor_MinorReport_model->getCombinedData($institu, $branches, $years);
 
    echo json_encode([
        "status"      => "success",
        "branchData"  => $result['branchData'],
        "yearData"    => $result['yearData']
    ]);
}

}
