<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class Import extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Import_model');
        $this->load->model('Log_model');
        $this->load->helper('log');
           if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
    }

    // Load Import View
    public function create()
    {
         // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);
        $this->load->view('admin/header_view');
        $this->load->view('admin/Import_view',$data);
        $this->load->view('admin/footer_view');
    }
public function import_excel()
{
    try {
         $fk_submenuId = $this->input->post('fk_submenuId');
        if (!empty($_FILES['excel_file']['name'])) {
            $originalName = $_FILES['excel_file']['name'];
            $tempPath = $_FILES['excel_file']['tmp_name'];

            $uploadPath = 'uploads/excel/';
            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0777, true);
            }

            $filename = date('YmdHis') . '_' . $originalName;
            $targetFilePath = $uploadPath . $filename;

            if (!move_uploaded_file($tempPath, $targetFilePath)) {
                echo "file_upload_error";
                return;
            }

            // Load Excel
            $spreadsheet = IOFactory::load($targetFilePath);
            $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

            if (empty($sheetData) || count($sheetData) < 2) {
                echo "no_data";
                return;
            }

            // Extract headers from first row
            $headers = $sheetData[1];
            $headerMap = [];
            foreach ($headers as $col => $headerName) {
                $headerMap[strtolower(trim($headerName))] = $col;
            }

            log_message('debug', 'Excel Header Map: ' . print_r($headerMap, true));

            // Helper function to get cell value
            function getCellValue($headerMap, $row, $headerName) {
                return isset($headerMap[$headerName], $row[$headerMap[$headerName]]) 
                    ? trim($row[$headerMap[$headerName]]) 
                    : null;
            }

            // Master maps - load all at once
            $genderMap = [];
            $districtMap = [];
            $talukaMap = [];
            $regionMap = [];
            $classMap = [];
            $religionMap = [];
            $motherTongueMap = [];
            $familyIncomeMap = [];
            $stateMap = [];
            $villageMap = [];
            $sscBoardMap = [];
            $religMinMap = [];
            $linguMinMap = [];
            $defTypeMap = [];
            $phTypeMap = [];
            $catMap = [];
            $homeUniMap = [];
            $candTypeMap = [];
            $qualifyExamMap = [];
            $hscBoardMap = [];
            $addSubMap = [];
            $instituteMap = [];
            $branchMap = [];
            $seatTypeMap = [];

            // Load master data
            foreach ($this->db->get_where('gender_master', ['is_on' => 1, 'is_active' => 1])->result() as $g) {
                $genderMap[strtolower(trim($g->gender_name))] = $g->gender_id;
            }
            foreach ($this->db->get_where('district_master', ['is_on' => 1, 'is_active' => 1])->result() as $d) {
                $districtMap[strtolower(trim($d->district_name))] = $d->district_id;
            }
            foreach ($this->db->get_where('taluka_master', ['is_on' => 1, 'is_active' => 1])->result() as $t) {
                $talukaMap[strtolower(trim($t->taulkaName))] = $t->taluka_id;
            }
            foreach ($this->db->get_where('region_master', ['is_on' => 1, 'is_active' => 1])->result() as $r) {
                $regionMap[strtolower(trim($r->region_name))] = $r->regid;
            }
            foreach ($this->db->get_where('classmaster', ['is_on' => 1, 'is_active' => 1])->result() as $class) {
                $classMap[strtolower(trim($class->classname))] = $class->class_id;
            }
            foreach ($this->db->get_where('religion_master', ['is_on' => 1, 'is_active' => 1])->result() as $rel) {
                $religionMap[strtolower(trim($rel->Religion_name))] = $rel->Religion_id;
            }
            foreach ($this->db->get_where('mothertong', ['is_on' => 1, 'is_active' => 1])->result() as $mt) {
                $motherTongueMap[strtolower(trim($mt->mtname))] = $mt->mtid;
            }
            foreach ($this->db->get_where('famincome', ['is_on' => 1, 'is_active' => 1])->result() as $fi) {
                $familyIncomeMap[strtolower(trim($fi->FamIncome))] = $fi->famid;
            }
            foreach ($this->db->get_where('state_master', ['is_on' => 1, 'is_active' => 1])->result() as $s) {
                $stateMap[strtolower(trim($s->stateName))] = $s->stateId;
            }
            foreach ($this->db->get_where('village_master', ['is_on' => 1, 'is_active' => 1])->result() as $v) {
                $villageMap[strtolower(trim($v->VillName))] = $v->Villid;
            }
            foreach ($this->db->get_where('sscboard_master', ['is_on' => 1, 'is_active' => 1])->result() as $s) {
                $sscBoardMap[strtolower(trim($s->boardname))] = $s->boardid;
            }
            foreach ($this->db->get_where('relig_minority', ['is_on' => 1, 'is_active' => 1])->result() as $r) {
                $religMinMap[strtolower(trim($r->RelMinname))] = $r->id;
            }
            foreach ($this->db->get_where('lingu_min', ['is_on' => 1, 'is_active' => 1])->result() as $l) {
                $linguMinMap[strtolower(trim($l->linName))] = $l->lin_id;
            }
            foreach ($this->db->get_where('def_type', ['is_on' => 1, 'is_active' => 1])->result() as $d) {
                $defTypeMap[strtolower(trim($d->defname))] = $d->defid;
            }
            foreach ($this->db->get_where('handikap_master', ['is_on' => 1, 'is_active' => 1])->result() as $p) {
                $phTypeMap[strtolower(trim($p->handikap_name))] = $p->handikap_id;
            }
            foreach ($this->db->get_where('castecategory_master', ['is_on' => 1, 'is_active' => 1])->result() as $c) {
                $catMap[strtolower(trim($c->Category_name))] = $c->Category_id;
            }
            foreach ($this->db->get_where('university_master', ['is_on' => 1, 'is_active' => 1])->result() as $u) {
                $homeUniMap[strtolower(trim($u->UNiName))] = $u->Uniid;
            }
            foreach ($this->db->get_where('can_type', ['is_on' => 1, 'is_active' => 1])->result() as $ct) {
                $candTypeMap[strtolower(trim($ct->CanName))] = $ct->id;
            }
            foreach ($this->db->get_where('qualify_master', ['is_on' => 1, 'is_active' => 1])->result() as $ct) {
                $qualifyExamMap[strtolower(trim($ct->Qualify_name))] = $ct->Qualify_id;
            }
            foreach ($this->db->get_where('hscboard_master', ['is_on' => 1, 'is_active' => 1])->result() as $ct) {
                $hscBoardMap[strtolower(trim($ct->hscname))] = $ct->hscid;
            }
            foreach ($this->db->get_where('sub_master', ['is_on' => 1, 'is_active' => 1])->result() as $ct) {
                $addSubMap[strtolower(trim($ct->sub_name))] = $ct->sub_id;
            }
            foreach ($this->db->get_where('institute_master', ['is_on' => 1, 'is_active' => 1])->result() as $ct) {
                $instituteMap[strtolower(trim($ct->Institu_name))] = $ct->Institu_id;
            }
            foreach ($this->db->get_where('branch_master', ['is_on' => 1, 'is_active' => 1])->result() as $ct) {
                $branchMap[strtolower(trim($ct->branch_name))] = $ct->branch_id;
            }
            foreach ($this->db->get_where('seat_type', ['is_on' => 1, 'is_active' => 1])->result() as $ct) {
                $seatTypeMap[strtolower(trim($ct->Seatname))] = $ct->Seatid;
            }

            $insertData = [];

            foreach ($sheetData as $key => $row) {
                if ($key == 1) continue; // skip header

                // Extract all fields with null handling
                $appliID = getCellValue($headerMap, $row, 'application id');
                $fullName = getCellValue($headerMap, $row, 'candidate name');
                $fatherName = getCellValue($headerMap, $row, 'father name');
                $motherName = getCellValue($headerMap, $row, 'mother name');
                $genderStr = getCellValue($headerMap, $row, 'gender');
                $DOB = getCellValue($headerMap, $row, 'dob');
                $classStr = getCellValue($headerMap, $row, 'class');
                $religionStr = getCellValue($headerMap, $row, 'religion');
                $regionStr = getCellValue($headerMap, $row, 'region');
                $motherTongueStr = getCellValue($headerMap, $row, 'mother tongue');
                $famIncStr = getCellValue($headerMap, $row, 'annual family income');
                $addLine1 = getCellValue($headerMap, $row, 'address line 1');
                $addLine2 = getCellValue($headerMap, $row, 'address line 2');
                $addLine3 = getCellValue($headerMap, $row, 'address line 3');
                $districtStr = getCellValue($headerMap, $row, 'district');
                $talukaStr = getCellValue($headerMap, $row, 'taluka');
                $stateStr = getCellValue($headerMap, $row, 'state');
                $villageStr = getCellValue($headerMap, $row, 'village');
                $pincode = getCellValue($headerMap, $row, 'pincode');
                $mobile = getCellValue($headerMap, $row, 'mobile no');
                $email = getCellValue($headerMap, $row, 'e-mail id');
                $phone = getCellValue($headerMap, $row, 'phone no');
                $sscBoardStr = getCellValue($headerMap, $row, 'ssc board');
                $relMinStr = getCellValue($headerMap, $row, 'religious minority');
                $linguMinStr = getCellValue($headerMap, $row, 'linguistic minority');
                $defTypeStr = getCellValue($headerMap, $row, 'defence type');
                $phTypeStr = getCellValue($headerMap, $row, 'ph type');
                $catStr = getCellValue($headerMap, $row, 'category');
                $homeUniStr = getCellValue($headerMap, $row, 'home university');
                $candTypeStr = getCellValue($headerMap, $row, 'candidature type');
                $sscPassYear = getCellValue($headerMap, $row, 'ssc passing year');
                $sscSeatNo = getCellValue($headerMap, $row, 'ssc seat no');
                $sscMathPer = getCellValue($headerMap, $row, 'ssc math percentage');
                $sscTotalPer = getCellValue($headerMap, $row, 'ssc total percentage');
                $qualifyExamStr = getCellValue($headerMap, $row, 'qualifying exam');
                $hscBoardStr = getCellValue($headerMap, $row, 'hsc board');
                $hscPassYear = getCellValue($headerMap, $row, 'hsc passing year');
                $hscSeat = getCellValue($headerMap, $row, 'hsc seat no');
                $hscPhy = getCellValue($headerMap, $row, 'hsc physics percentage');
                $hscChem = getCellValue($headerMap, $row, 'hsc chemistry percentage');
                $hscMath = getCellValue($headerMap, $row, 'hsc math percentage');
                $addSubStr = getCellValue($headerMap, $row, 'hsc additional subject for eligiblity');
                $hscSubPer = getCellValue($headerMap, $row, 'hsc subject percentage');
                $hscEngPer = getCellValue($headerMap, $row, 'hsc english percentage');
                $hscTotPer = getCellValue($headerMap, $row, 'hsc total percentage');
                $EligiPer = getCellValue($headerMap, $row, 'eligibility percentage');
                $CETRoll = getCellValue($headerMap, $row, 'cet roll no');
                $CETPer = getCellValue($headerMap, $row, 'cet percentile');
                $JEEPer = getCellValue($headerMap, $row, 'jee percentile');
                $JEERoll = getCellValue($headerMap, $row, 'jee roll no');
                $MeritNo = getCellValue($headerMap, $row, 'merit no');
                $MeritMarks = getCellValue($headerMap, $row, 'merit marks');
                $InsituCode = getCellValue($headerMap, $row, 'institute code');
                $InstituteStr = getCellValue($headerMap, $row, 'institute name');
                $branchStr = getCellValue($headerMap, $row, 'course name');
                $choiceCode = getCellValue($headerMap, $row, 'choice code');
                $seatTypeStr = getCellValue($headerMap, $row, 'seat type');
                $AdmDate = getCellValue($headerMap, $row, 'admission date');
                $ReportedDate = getCellValue($headerMap, $row, 'reported date');

                // Skip if mandatory fields are empty
                if (empty($appliID) || empty($fullName) || empty($genderStr) || empty($districtStr) || empty($talukaStr)) {
                    continue;
                }

                // Skip duplicate AppliID
                if ($this->db->get_where('student_reg', ['AppliID' => $appliID])->row()) {
                    continue;
                }

                // Helper function to handle master data
              // Helper function to handle master data
$getMasterId = function(&$map, $str, $table, $nameField, $idField) {
    if (empty($str)) {
        return null;
    }
    
    $strLower = strtolower($str);
    if (!isset($map[$strLower])) {
        $this->db->insert($table, [
            $nameField => ucfirst($str),
            'is_on' => 1,
            'is_active' => 1
        ]);
        $newId = $this->db->insert_id();
        $map[$strLower] = $newId;
        return $newId;
    }
    return $map[$strLower];
};

                // Process all master data with null handling
                $genderId = $getMasterId($genderMap, $genderStr, 'gender_master', 'gender_name', 'gender_id');
                $districtId = $getMasterId($districtMap, $districtStr, 'district_master', 'district_name', 'district_id');
                $talukaId = $getMasterId($talukaMap, $talukaStr, 'taluka_master', 'taulkaName', 'taluka_id');
                $stateId = $getMasterId($stateMap, $stateStr, 'state_master', 'stateName', 'stateId');
                $Villid = $getMasterId($villageMap, $villageStr, 'village_master', 'VillName', 'Villid');
                $class_id = $getMasterId($classMap, $classStr, 'classmaster', 'classname', 'class_id');
                $religionId = $getMasterId($religionMap, $religionStr, 'religion_master', 'Religion_name', 'Religion_id');
                $regionId = $getMasterId($regionMap, $regionStr, 'region_master', 'region_name', 'regid');
                $motherTongueId = $getMasterId($motherTongueMap, $motherTongueStr, 'mothertong', 'mtname', 'mtid');
                $familyIncomeId = $getMasterId($familyIncomeMap, $famIncStr, 'famincome', 'FamIncome', 'famid');
                $sscBoardId = $getMasterId($sscBoardMap, $sscBoardStr, 'sscboard_master', 'boardname', 'boardid');
                $relMinId = $getMasterId($religMinMap, $relMinStr, 'relig_minority', 'RelMinname', 'id');
                $linguMinId = $getMasterId($linguMinMap, $linguMinStr, 'lingu_min', 'linName', 'lin_id');
                $defTypeId = $getMasterId($defTypeMap, $defTypeStr, 'def_type', 'defname', 'defid');
                $phTypeId = $getMasterId($phTypeMap, $phTypeStr, 'handikap_master', 'handikap_name', 'handikap_id');
                $catId = $getMasterId($catMap, $catStr, 'castecategory_master', 'Category_name', 'Category_id');
                $homeUniId = $getMasterId($homeUniMap, $homeUniStr, 'university_master', 'UNiName', 'Uniid');
                $candTypeId = $getMasterId($candTypeMap, $candTypeStr, 'can_type', 'CanName', 'id');
                $Qualify_id = $getMasterId($qualifyExamMap, $qualifyExamStr, 'qualify_master', 'Qualify_name', 'Qualify_id');
                $hscid = $getMasterId($hscBoardMap, $hscBoardStr, 'hscboard_master', 'hscname', 'hscid');
                $sub_id = $getMasterId($addSubMap, $addSubStr, 'sub_master', 'sub_name', 'sub_id');
                $Institu_id = $getMasterId($instituteMap, $InstituteStr, 'institute_master', 'Institu_name', 'Institu_id');
                $branch_id = $getMasterId($branchMap, $branchStr, 'branch_master', 'branch_name', 'branch_id');
                $Seatid = $getMasterId($seatTypeMap, $seatTypeStr, 'seat_type', 'Seatname', 'Seatid');

                // Financial Year calculation
             $Financial_Year = null;
if (!empty($AdmDate)) {
    // Normalize the date string
    $dateStr = str_replace('/', '-', $AdmDate);
    
    // Try different date formats
    $dateObj = DateTime::createFromFormat('d-m-Y', $dateStr);
    if (!$dateObj) {
        $dateObj = DateTime::createFromFormat('Y-m-d', $dateStr);
    }
    if (!$dateObj) {
        $dateObj = DateTime::createFromFormat('m-d-Y', $dateStr);
    }
    if (!$dateObj) {
        $dateObj = DateTime::createFromFormat('d/m/Y', $AdmDate);
    }
    if (!$dateObj) {
        $dateObj = DateTime::createFromFormat('m/d/Y', $AdmDate);
    }
    
    if ($dateObj) {
        $admissionDate = $dateObj->format('Y-m-d');
        
        // Log for debugging
        log_message('debug', 'Parsed Admission Date: ' . $admissionDate . ' from original: ' . $AdmDate);
        
        // Get all financial years
        $finiYearRows = $this->db
            ->where('is_on', 1)
            ->where('is_active', 1)
            ->get('finiyear_master')
            ->result();
        
        log_message('debug', 'Financial Years found: ' . count($finiYearRows));
        
        foreach ($finiYearRows as $rowFY) {
            log_message('debug', 'Checking FY ID: ' . $rowFY->finiYear_id . ' Start: ' . $rowFY->StartDate . ' End: ' . $rowFY->EndDate);
            
            // Check if admission date falls between StartDate and EndDate
            if (!empty($rowFY->StartDate) && !empty($rowFY->EndDate)) {
                if ($admissionDate >= $rowFY->StartDate && $admissionDate <= $rowFY->EndDate) {
                    $Financial_Year = $rowFY->finiYear_id;
                    log_message('debug', 'Matched Financial Year: ' . $Financial_Year);
                    break;
                }
            }
        }
        
        if ($Financial_Year === null) {
            log_message('debug', 'No matching financial year found for date: ' . $admissionDate);
        }
    } else {
        log_message('error', 'Failed to parse admission date: ' . $AdmDate);
    }
}
                // Final data array
                $insertData[] = [
                    'AppliID' => $appliID,
                    'FullName' => $fullName,
                    'FatherName' => $fatherName,
                    'MotherName' => $motherName,
                    'fkGender_id' => $genderId,
                    'DOB' => $DOB,
                    'fkClass_id' => $class_id,
                    'fkReligion_id' => $religionId,
                    'fkRegion_id' => $regionId,
                    'fkMotherTon_id' => $motherTongueId,
                    'fkFamInc_id' => $familyIncomeId,
                    'AddLine1' => $addLine1,
                    'AddLine2' => $addLine2,
                    'AddLine3' => $addLine3,
                    'fkDistrict_id' => $districtId,
                    'fkTaluka_id' => $talukaId,
                    'fkState_id' => $stateId,
                    'fkVillage_id' => $Villid,
                    'Phone' => $phone,
                    'EMail' => $email,
                    'Mobile' => $mobile,
                    'Pincode' => $pincode,
                    'fkSSCBoard_id' => $sscBoardId,
                    'fkRelMin_id' => $relMinId,
                    'fkLinguMin_id' => $linguMinId,
                    'fkDefType_id' => $defTypeId,
                    'fkhandikap_id' => $phTypeId,
                    'fkCat_id' => $catId,
                    'fkHomeUni_id' => $homeUniId,
                    'fkCandType_id' => $candTypeId,
                    'SSCPassYear' => $sscPassYear,
                    'SSCSeatNo' => $sscSeatNo,
                    'SSCMathPer' => $sscMathPer,
                    'SSCTotalPer' => $sscTotalPer,
                    'fkQualifyExam_id' => $Qualify_id,
                    'fkHSCBoard_id' => $hscid,
                    'HSCPassYear' => $hscPassYear,
                    'HSCSeatNo' => $hscSeat,
                    'HSCPhyPer' => $hscPhy,
                    'HSCChemPer' => $hscChem,
                    'HSCMathPer' => $hscMath,
                    'fkHSCAddSub_id' => $sub_id,
                    'HSCSubPer' => $hscSubPer,
                    'HSCEngPer' => $hscEngPer,
                    'HSCTotalPer' => $hscTotPer,
                    'EligiPer' => $EligiPer,
                    'CETRoll' => $CETRoll,
                    'CETPer' => $CETPer,
                    'JEERollNo' => $JEERoll,
                    'JEEPer' => $JEEPer,
                    'MeritNo' => $MeritNo,
                    'MeritMarks' => $MeritMarks,
                    'InstCode' => $InsituCode,
                    'fkInstitName_id' => $Institu_id,
                    'fkBranchName_id' => $branch_id,
                    'ChoiceCode' => $choiceCode,
                    'fkSeatType_id' => $Seatid,
                    'AdmDate' => $AdmDate,
                    'ReportedDate' => $ReportedDate,
                    'Financial_Year' => $Financial_Year,
                    'form_no' => 1,
                    'ExcelName' => $originalName,
                    'created_by'=>$_SESSION['userID']
                ];
            }

            if (!empty($insertData)) {
                $this->Import_model->insert_batch($insertData);
                echo "success";
            } else {
                echo "no_data";
            }
            
            // Insert log - Action 4 (Excel)
 
        $action = 4;

        $record_id = null;

        $excel_name = $originalName;

        $Fk_branch = null;

        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name,$Fk_branch,$_SESSION['userID']);

        } else {
            echo "no_file";
        }

    } catch (Exception $e) {
        log_message('error', 'Import Error: ' . $e->getMessage());
        echo "error: " . $e->getMessage();
    }
}

 
}
