<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class Import_Guestlec extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Import_Guestlec_model');
        $this->load->model('Log_model');
        $this->load->helper('log'); // Load log helper
        
    }

    // Load Import View
    public function create()
    {
        
        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);
        $this->load->view('admin/header_view');
        $this->load->view('admin/Import_Guestlec_view',$data);
        $this->load->view('admin/footer_view');
    }

 






   public function import_excel_save() {
        try {
            $fk_submenuId = $this->input->post('fk_submenuId');
             // ✅ Check if file is uploaded and save it
        if (!empty($_FILES['excel_file']['name'])) {
            $originalName = $_FILES['excel_file']['name'];
            $tempPath = $_FILES['excel_file']['tmp_name'];
 
            $uploadDir = FCPATH . 'uploads/excel/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }
 
            // Create filename: Value_Addition_Program_YYYYMMDD_HHMMSS.xlsx
            $extension = pathinfo($originalName, PATHINFO_EXTENSION);
            $filename = 'Guest_lecture_' . date('Ymd_His') . '.' . $extension;
            $targetFile = $uploadDir . $filename;
 
            if (!move_uploaded_file($tempPath, $targetFile)) {
                echo "file_error";
                return;
            }
        }
            
            $postData = $this->input->post('tableData');
            if (empty($postData)) {
                echo "no_data";
                return;
            }

            $rows = json_decode($postData, true);
            $insertData = [];

            //  $finiYear = $this->db ->select('finiYear_id')->from('finiyear_master')->where('Active_Deactive', 1)->get()->row();
            //  $finicial_Year = $finiYear ? $finiYear->finiYear_id : null;

             $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
             $Institute = $institute ? $institute->Institu_id : null;

    
            // ✅ Load existing branch & class maps
           $branchMap = [];
            $classMap  = [];
            $yearMap = [];
            $semMap = [];
            $desigMap = [];
            $facultyMap = [];
            $hodMap = [];

            

            foreach ($this->db->get_where('branch_master', ['is_on' => 1, 'is_active' => 1])->result() as $g) {
                $branchMap[strtolower(trim($g->branch_name))] = $g->branch_id;
            }
            foreach ($this->db->get_where('classmaster', ['is_on' => 1, 'is_active' => 1])->result() as $d) {
                $classMap[strtolower(trim($d->classname))] = $d->class_id;
            }
            foreach ($this->db->get_where('finiyear_master', ['is_active' => 1, 'is_active' => 1])->result() as $g) {
                $yearMap[strtolower(trim($g->fini_Label))] = $g->finiYear_id;
            }
            foreach ($this->db->get_where('semester_master', ['is_active' => 1, 'is_active' => 1])->result() as $g) {
                $semMap[strtolower(trim($g->Sem_Name))] = $g->SemID;
            }
            foreach ($this->db->get_where('designation_master', ['is_active' => 1, 'is_active' => 1])->result() as $g) {
                $desigMap[strtolower(trim($g->desig_name))] = $g->desig_id;
            }
            foreach ($this->db->get_where('faculty_master', ['is_active' => 1, 'is_active' => 1])->result() as $g) {
                $facultyMap[strtolower(trim($g->fac_Fullname))] = $g->fac_id;
            }
            foreach ($this->db->get_where('faculty_master', ['is_active' => 1, 'is_active' => 1])->result() as $g) {
                $hodMap[strtolower(trim($g->fac_Fullname))] = $g->fac_id;
            }





            $rowCount = 0;
        foreach ($rows as $row) {
            $rowCount++;
 
            // ✅ Header skip
            if ($rowCount === 1) {
                continue;
            }

            
                // ---- Branch mapping ----
                $branchStr = strtolower(trim($row['fkbranch_id'] ?? ''));
                if ($branchStr !== '') {
                    if (!isset($branchMap[$branchStr])) {
                        $this->db->insert('branch_master', [
                            'branch_name' => ucfirst($branchStr),
                            'is_on'       => 1,
                            'is_active'   => 1
                        ]);
                        $branch_id = $this->db->insert_id();
                        $branchMap[$branchStr] = $branch_id;
                    } else {
                        $branch_id = $branchMap[$branchStr];
                    }
                } else {
                    $branch_id = null;
                }

                 // ---- Class mapping ----
                $classStr = strtolower(trim($row['fkclass_id'] ?? ''));
                if ($classStr !== '') {
                    if (!isset($classMap[$classStr])) {
                        $this->db->insert('classmaster', [
                            'classname' => ucfirst($classStr),
                            'is_on'     => 1,
                            'is_active' => 1
                        ]);
                        $class_id = $this->db->insert_id();
                        $classMap[$classStr] = $class_id;
                    } else {
                        $class_id = $classMap[$classStr];
                    }
                } else {
                    $class_id = null;
                }


                // ---- Year mapping ----
                $yearStr = strtolower(trim($row['finicial_Year'] ?? ''));
            if ($yearStr !== '') {
                if (!isset($yearMap[$yearStr])) {
                    $this->db->insert('finiyear_master', [
                        'fini_Label' => ucfirst($yearStr),
                        'is_active' => 1,
                        'is_active' => 1
                    ]);
                    $finiYear_id = $this->db->insert_id();
                    $yearMap[$yearStr] = $finiYear_id;
                } else {
                    $finiYear_id = $yearMap[$yearStr];
                }
            } else {
                $finiYear_id = null;
            }

             // ---- Semester mapping ----
                $semStr = strtolower(trim($row['fkSemID'] ?? ''));
                if ($semStr !== '') {
                    if (!isset($semMap[$semStr])) {
                        $this->db->insert('semester_master', [
                            'Sem_Name' => ucfirst($semStr),
                            'is_on'     => 1,
                            'is_active' => 1
                        ]);
                        $SemID = $this->db->insert_id();
                        $semMap[$semStr] = $SemID;
                    } else {
                        $SemID = $semMap[$semStr];
                    }
                } else {
                    $SemID = null;
                }

                // ---- Designation mapping ----
                $desigStr = strtolower(trim($row['fkdesig_id'] ?? ''));
                if ($desigStr !== '') {
                    if (!isset($desigMap[$desigStr])) {
                        $this->db->insert('designation_master', [
                            'desig_name' => ucfirst($desigStr),
                            'is_on'     => 1,
                            'is_active' => 1
                        ]);
                        $desig_id = $this->db->insert_id();
                        $desigMap[$desigStr] = $desig_id;
                    } else {
                        $desig_id = $desigMap[$desigStr];
                    }
                } else {
                    $desig_id = null;
                }

                // ---- faculty mapping ----
                $facultyStr = strtolower(trim($row['fkfac_id'] ?? ''));
                if ($facultyStr !== '') {
                    if (!isset($facultyMap[$facultyStr])) {
                        $this->db->insert('faculty_master', [
                            'fac_Fullname' => ucfirst($facultyStr),
                            'is_on'     => 1,
                            'is_active' => 1
                        ]);
                        $fac_id = $this->db->insert_id();
                        $facultyMap[$facultyStr] = $fac_id;
                    } else {
                        $fac_id = $facultyMap[$facultyStr];
                    }
                } else {
                    $fac_id = null;
                }

                // ---- HOD mapping (HODId) ----
                $hodStr = strtolower(trim($row['HODId'] ?? ''));
                if ($hodStr !== '') {
                   if (!isset($hodMap[$hodStr])) {
                        $this->db->insert('faculty_master', [
                            'fac_Fullname' => ucfirst($hodStr),
                            'is_on'     => 1,
                            'is_active' => 1
                        ]);
                        $hod_id = $this->db->insert_id();
                        $hodMap[$hodStr] = $hod_id;
                    } else {
                        $hod_id = $hodMap[$hodStr];
                    }
                } else {
                    $hod_id = null;
                }




                // ---- Prepare row for insert ----
                $insertData[] = [
                    'Guest_name'     => $row['Guest_name'] ?? '',
                    'fkbranch_id'  => $branch_id,
                    'fkclass_id'   => $class_id,
                    'fkSemID'   => $SemID,
                    'fkdesig_id'   => $desig_id,
                    'Expert_topic'   => $row['Expert_topic'] ?? '',
                    'Talk_date'    => !empty($row['Talk_date']) ? date('Y-m-d', strtotime($row['Talk_date'])) : null,
                    'No_benefit'   => $row['No_benefit'] ?? '',
                    'oraganization'   => $row['oraganization'] ?? '',
                    'fkfac_id'   => $fac_id,
                    'HODId'   => $hod_id,
                    'guest_summary'   => $row['guest_summary'] ?? '',
                    'start_date'    => !empty($row['start_date']) ? date('Y-m-d', strtotime($row['start_date'])) : null,
                    'end_date'    => !empty($row['end_date']) ? date('Y-m-d', strtotime($row['end_date'])) : null,
                    'location'   => $row['location'] ?? '',
                    'finicial_Year'  => $finiYear_id,
                    'Institute'  => $Institute,
                    'created_date' => date('Y-m-d H:i:s'),
                    'is_on'        => 1,
                    'is_active'    => 1,
                    'created_by'=>$_SESSION['userID']
                ];
            }

            if (!empty($insertData)) {
                // ✅ use model method
                $this->Import_Guestlec_model->insert_batch($insertData);
                echo "success";
            } else {
                echo "no_data";
            }
            
             // Insert log - Action 4 (Excel)

        $action = 4;
        $record_id = null;
        $excel_name = $filename;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name,$Fk_branch,$_SESSION['userID']);

        } catch (Exception $e) {
            echo "Error: " . $e->getMessage();
        }
    }
}
