<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class Import_MOUexcel extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Import_MOUexcel_model');
         $this->load->model('Log_model');
        $this->load->helper('log'); // Load log helper
    }

    // Load Import View
    public function create()
    {
        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Import_MOUexcel_view',$data);
        $this->load->view('admin/footer_view');
    }

    

public function import_excel_save() {
    try {
        $fk_submenuId = $this->input->post('fk_submenuId');
        
        // ✅ Handle Excel file upload
        if (!empty($_FILES['excel_file']['name'])) {
            $originalName = $_FILES['excel_file']['name'];
            $tempPath = $_FILES['excel_file']['tmp_name'];

            // Upload path
            $uploadDir = FCPATH . 'uploads/excel/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }

            $filename = 'MOU_excel_' . date('Ymd_His') . '_' . basename($originalName);
            $targetFile = $uploadDir . $filename;

            if (!move_uploaded_file($tempPath, $targetFile)) {
                echo "file_error";
                return;
            }
        }

        // ✅ Process table data
        $postData = $this->input->post('tableData');
        if (empty($postData)) {
            echo "no_data";
            return;
        }

        $rows = json_decode($postData, true);
        $insertData = [];

        // ✅ Load maps for existing master data
       
        $yearMap = [];
        $branchMap = [];
        $durationMap = [];
        

       
        foreach ($this->db->get_where('finiyear_master', ['is_active' => 1])->result() as $g) {
            $yearMap[strtolower(trim($g->fini_Label))] = $g->finiYear_id;
        }
        foreach ($this->db->get_where('branch_master', ['is_on' => 1, 'is_active' => 1])->result() as $r) {
            $branchMap[strtolower(trim($r->branch_name))] = $r->branch_id;
        }
        
$durationMap = [];

foreach (
    $this->db->get_where(
        'internduration_master',
        ['is_on' => 1, 'is_active' => 1]
    )->result() as $q
) {
    if (!empty($q->duration_type)) {
        $key = strtolower(trim((string)$q->duration_type));
        $durationMap[$key] = $q->duration_id;
    }
}

        // foreach ($this->db->get_where('internduration_master', ['is_on' => 1, 'is_active' => 1])->result() as $q) {
        //     $durationMap[strtolower(trim($q->duration_type))] = $q->duration_id;
        // }

        

        $rowCount = 0;
        foreach ($rows as $row) {
            $rowCount++;

            // ✅ Skip header row
            if ($rowCount === 1) continue;

            // ✅ Skip blank row
            // if (
            //     empty(trim($row['fkbranch_id'])) &&
            //     empty(trim($row['fk_company'])) &&
            //     empty(trim($row['fac_1'])) &&
            //     empty(trim($row['fac_2'])) &&
            //     empty(trim($row['fac_3'])) &&
            //     empty(trim($row['fac_4']))
            // ) {
            //     continue;
            // }

            // ✅ Branch Master
            $branchStr = strtolower(trim($row['Branch_id'] ?? ''));
            if ($branchStr !== '') {
                if (!isset($branchMap[$branchStr])) {
                    $this->db->insert('branch_master', [
                        'branch_name' => ucfirst($branchStr),
                        'is_on' => 1,
                        'is_active' => 1
                    ]);
                    $branch_id = $this->db->insert_id();
                    $branchMap[$branchStr] = $branch_id;
                } else {
                    $branch_id = $branchMap[$branchStr];
                }
            } else {
                $branch_id = null;
            }

            // ✅ duration Master
            $divStr = strtolower(trim($row['fkDuration_id'] ?? ''));
            if ($divStr !== '') {
                if (!isset($durationMap[$divStr])) {
                    $this->db->insert('internduration_master', [
                        'duration_type' => ucfirst($divStr),
                        'is_on' => 1,
                        'is_active' => 1
                    ]);
                    $duration_id = $this->db->insert_id();
                    $durationMap[$divStr] = $duration_id;
                } else {
                    $duration_id = $durationMap[$divStr];
                }
            } else {
                $duration_id = null;
            }



            // ✅ Year Master
            $yearStr = strtolower(trim($row['fkYear_id'] ?? ''));
            if ($yearStr !== '') {
                if (!isset($yearMap[$yearStr])) {
                    $this->db->insert('finiyear_master', [
                        'fini_Label' => ucfirst($yearStr),
                        'is_active' => 1
                    ]);
                    $finiYear_id = $this->db->insert_id();
                    $yearMap[$yearStr] = $finiYear_id;
                } else {
                    $finiYear_id = $yearMap[$yearStr];
                }
            } else {
                $finiYear_id = null;
            }

            
            

            // ✅ Date conversions
            $SignDate = !empty($row['SignDate'])
                ? (is_numeric($row['SignDate'])
                    ? gmdate("Y-m-d", ($row['SignDate'] - 25569) * 86400)
                    : date('Y-m-d', strtotime(str_replace('/', '-', $row['SignDate']))))
                : null;

            $StartDate = !empty($row['StartDate'])
                ? (is_numeric($row['StartDate'])
                    ? gmdate("Y-m-d", ($row['StartDate'] - 25569) * 86400)
                    : date('Y-m-d', strtotime(str_replace('/', '-', $row['StartDate']))))
                : null;

                 $EndDate = !empty($row['EndDate'])
                ? (is_numeric($row['EndDate'])
                    ? gmdate("Y-m-d", ($row['EndDate'] - 25569) * 86400)
                    : date('Y-m-d', strtotime(str_replace('/', '-', $row['EndDate']))))
                : null;

            // ✅ Insert row
            $insertData[] = [
                'Indu_Name' => $row['Indu_Name'] ?? '',
                'SignDate'     => $SignDate,
                'StartDate'     => $StartDate,
                'EndDate'     => $EndDate,
                 'fkDuration_id'   => $duration_id,
                 'Highlight_Detail' => $row['Highlight_Detail'] ?? '',
                'Branch_id'   => $branch_id,
               'fkYear_id'=> $finiYear_id,
                'created_date' => date('Y-m-d'),
                'created_by'=>$_SESSION['userID']
            ];
        }

        if (!empty($insertData)) {
            $this->db->insert_batch('mou_master', $insertData);
            echo "success";
        } else {
            echo "no_data";
        }
        
        // Insert log - Action 4 (Excel)

        $action = 4;
        $record_id = null;
        $excel_name = $filename;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name,$Fk_branch,$_SESSION['userID']);

        
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
}


}
