<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Import_Practiced extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Import_Practiced_model');
    }

    // Load Import View
    public function create()
    {

     $data['mainuserdata'] = $this->Import_Practiced_model->getmainuser();
     $data['Platformtdata'] = $this->Import_Practiced_model->getplatform();
        $data['gradedata'] = $this->Import_Practiced_model->getgrade();
          $data['yeardata'] = $this->Import_Practiced_model->getyear();
         $data['activeYear'] = $this->Import_Practiced_model->getActiveYear();

        $this->load->view('admin/header_view');
        $this->load->view('admin/Import_Practiced_view',$data);
        $this->load->view('admin/footer_view');
    }

    public function import_excel_save() {
        try {
            // ✅ Check if file is uploaded and save it
            if (!empty($_FILES['excel_file']['name'])) {
                $originalName = $_FILES['excel_file']['name'];
                $tempPath = $_FILES['excel_file']['tmp_name'];
    
                $uploadDir = FCPATH . 'uploads/excel/';
                if (!is_dir($uploadDir)) {
                    mkdir($uploadDir, 0777, true);
                }
    
                $extension = pathinfo($originalName, PATHINFO_EXTENSION);
                $filename = 'Best_Practiced_' . date('Ymd_His') . '.' . $extension;
                $targetFile = $uploadDir . $filename;
    
                if (!move_uploaded_file($tempPath, $targetFile)) {
                    echo "file_error";
                    return;
                }
            }
    
            // Get POST data
            $postData = $this->input->post('tableData');
            $fkmainuser_id = $this->input->post('fkmainuser_id');
            $fkPlatform_id = $this->input->post('fkPlatform_id');
            $finicial_Year = $this->input->post('finicial_Year');

            if (empty($postData)) {
                echo "no_data";
                return;
            }

            $rows = json_decode($postData, true);
            $insertData = [];

            // Get active institute
            $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
            $Institute = $institute ? $institute->Institu_id : null;

            // ✅ Load existing maps
            $gradeMap = [];
            $durationMap = [];
            $yearMap = [];

            foreach ($this->db->get_where('grade_master', ['is_on' => 1, 'is_active' => 1])->result() as $d) {
                $gradeMap[strtolower(trim((string)$d->Grade_name))] = $d->Grade_id;
            }

            foreach ($this->db->get_where('internduration_master', ['is_on' => 1, 'is_active' => 1])->result() as $g) {
                $durationMap[strtolower(trim((string)$g->duration_type))] = $g->duration_id;
            }

            foreach ($this->db->get_where('finiyear_master', ['is_active' => 1])->result() as $g) {
                $yearMap[strtolower(trim((string)$g->fini_Label))] = $g->finiYear_id;
            }

            foreach ($rows as $row) {
                // ---- Grade mapping ----
                $gradeStr = strtolower(trim((string)($row['fkGrade_id'] ?? '')));
                $Grade_id = null;
                
                if ($gradeStr !== '') {
                    if (!isset($gradeMap[$gradeStr])) {
                        $this->db->insert('grade_master', [
                            'Grade_name' => ucfirst($gradeStr),
                            'is_on' => 1,
                            'is_active' => 1
                        ]);
                        $Grade_id = $this->db->insert_id();
                        $gradeMap[$gradeStr] = $Grade_id;
                    } else {
                        $Grade_id = $gradeMap[$gradeStr];
                    }
                }

                // ---- Duration mapping ----
                $durationStr = strtolower(trim((string)($row['fkduration_id'] ?? '')));
                $duration_id = null;
                
                if ($durationStr !== '') {
                    if (!isset($durationMap[$durationStr])) {
                        $this->db->insert('internduration_master', [
                            'duration_type' => ucfirst($durationStr),
                            'is_on' => 1,
                            'is_active' => 1
                        ]);
                        $duration_id = $this->db->insert_id();
                        $durationMap[$durationStr] = $duration_id;
                    } else {
                        $duration_id = $durationMap[$durationStr];
                    }
                }

                // ---- Year mapping ----
                $yearStr = strtolower(trim((string)($row['Financial_Year'] ?? '')));
                $finiYear_id = $finicial_Year; // Use selected year from dropdown
                
                if ($yearStr !== '' && !$finiYear_id) {
                    if (!isset($yearMap[$yearStr])) {
                        $this->db->insert('finiyear_master', [
                            'fini_Label' => ucfirst($yearStr),
                            'is_active' => 1
                        ]);
                        $finiYear_id = $this->db->insert_id();
                        $yearMap[$yearStr] = $finiYear_id;
                    } else {
                        $finiYear_id = $yearMap[$yearStr];
                    }
                }

                // ---- Prepare row for insert ----
                $insertData[] = [
                    'fkmainuser_id' => $fkmainuser_id,
                    'fkPlatform_id' => $fkPlatform_id,
                    'Applicant_name' => $row['Applicant_name'] ?? '',
                    'Applicant_id' => $row['Applicant_id'] ?? '',
                    'fkduration_id' => $duration_id,
                    'Course_name' => $row['Course_name'] ?? '',
                    'Practice_prece' => $row['Practice_prece'] ?? '',
                    'fkGrade_id' => $Grade_id,
                    'StartDate' => !empty($row['StartDate']) ? date('Y-m-d', strtotime($row['StartDate'])) : null,
                    'EndDate' => !empty($row['EndDate']) ? date('Y-m-d', strtotime($row['EndDate'])) : null,
                    'finicial_Year' => $finiYear_id,
                    'institute' => $Institute,
                    'is_on' => 1,
                    'is_active' => 1,
                    'created_date' => date('Y-m-d H:i:s')
                ];
            }

            if (!empty($insertData)) {
                $result = $this->Import_Practiced_model->insert_batch($insertData);
                if ($result) {
                    echo "success";
                } else {
                    echo "db_error";
                }
            } else {
                echo "no_data";
            }

        } catch (Exception $e) {
            echo "error: " . $e->getMessage();
        }
    }
}