<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class Import_VAP extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Import_VAP_model');
            if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
    }

    // Load Import View
    public function create()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/Import_VAP_view');
        $this->load->view('admin/footer_view');
    }



   public function import_excel_save() {
        try {
            
             // ✅ Check if file is uploaded and save it
        if (!empty($_FILES['excel_file']['name'])) {
            $originalName = $_FILES['excel_file']['name'];
            $tempPath = $_FILES['excel_file']['tmp_name'];
 
            $uploadDir = FCPATH . 'uploads/excel/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }
 
            // Create filename: Value_Addition_Program_YYYYMMDD_HHMMSS.xlsx
            $extension = pathinfo($originalName, PATHINFO_EXTENSION);
            $filename = 'Value_Addition_Program_' . date('Ymd_His') . '.' . $extension;
            $targetFile = $uploadDir . $filename;
 
            if (!move_uploaded_file($tempPath, $targetFile)) {
                echo "file_error";
                return;
            }
        }
            
            
            $postData = $this->input->post('tableData');
            if (empty($postData)) {
                echo "no_data";
                return;
            }

            $rows = json_decode($postData, true);
            $insertData = [];

            // $finiYear = $this->db ->select('finiYear_id')->from('finiyear_master')->where('Active_Deactive', 1)->get()->row();
            //  $finicial_Year = $finiYear ? $finiYear->finiYear_id : null;
            

             $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
             $Institute = $institute ? $institute->Institu_id : null;

    
            // ✅ Load existing branch & class maps
            $companyMap  = [];
            $branchMap = [];
             $yearMap = [];
            
           
           
             foreach ($this->db->get_where('company_master', ['is_on' => 1, 'is_active' => 1])->result() as $d) {
                $companyMap[strtolower(trim($d->comp_name))] = $d->ID ;
            }

            foreach ($this->db->get_where('branch_master', ['is_on' => 1, 'is_active' => 1])->result() as $g) {
                $branchMap[strtolower(trim($g->branch_name))] = $g->branch_id;
            }

            foreach ($this->db->get_where('finiyear_master', ['is_active' => 1, 'is_active' => 1])->result() as $g) {
            $yearMap[strtolower(trim($g->fini_Label))] = $g->finiYear_id;
            }

            $rowCount = 0;
        foreach ($rows as $row) {
            $rowCount++;
 
            // ✅ Header skip
            if ($rowCount === 1) {
                continue;
            }


            
              
                 // ---- Company mapping ----
                $companyStr = strtolower(trim($row['fkcomp_ID'] ?? ''));
                if ($companyStr !== '') {
                    if (!isset($companyMap[$companyStr])) {
                        $this->db->insert('company_master', [
                            'comp_name' => ucfirst($companyStr),
                            'is_on'     => 1,
                            'is_active' => 1
                        ]);
                        $ID = $this->db->insert_id();
                        $companyMap[$companyStr] = $ID;
                    } else {
                        $ID = $companyMap[$companyStr];
                    }
                } else {
                    $ID = null;
                }

                  // ---- Branch mapping ----
                $branchStr = strtolower(trim($row['fkbranch_id'] ?? ''));
                if ($branchStr !== '') {
                    if (!isset($branchMap[$branchStr])) {
                        $this->db->insert('branch_master', [
                            'branch_name' => ucfirst($branchStr),
                            'is_on'       => 1,
                            'is_active'   => 1
                        ]);
                        $branch_id = $this->db->insert_id();
                        $branchMap[$branchStr] = $branch_id;
                    } else {
                        $branch_id = $branchMap[$branchStr];
                    }
                } else {
                    $branch_id = null;
                }

                
                // ---- Year mapping ----
                $yearStr = strtolower(trim($row['finicial_Year'] ?? ''));
            if ($yearStr !== '') {
                if (!isset($yearMap[$yearStr])) {
                    $this->db->insert('finiyear_master', [
                        'fini_Label' => ucfirst($yearStr),
                        'is_active' => 1,
                        'is_active' => 1
                    ]);
                    $finiYear_id = $this->db->insert_id();
                    $yearMap[$yearStr] = $finiYear_id;
                } else {
                    $finiYear_id = $yearMap[$yearStr];
                }
            } else {
                $finiYear_id = null;
            }


                // ---- Prepare row for insert ----
                $insertData[] = [
                    'fkcomp_ID'  => $ID,
                    'fkbranch_id'  => $branch_id,
                    'Specialisation'     => $row['Specialisation'] ?? '',
                    'VAP_date'    => !empty($row['VAP_date']) ? date('Y-m-d', strtotime($row['VAP_date'])) : null,
                    'Outcome'     => $row['Outcome'] ?? '',
                    'Exp_Details'   => $row['Exp_Details'] ?? '',
                    'address'     => $row['address'] ?? '',
                    'finicial_Year'  => $finiYear_id,
                    'Institute'  => $Institute,
                    'created_date' => date('Y-m-d H:i:s'),
                    'is_on'        => 1,
                    'is_active'    => 1
                ];
            }

            if (!empty($insertData)) {
                // ✅ use model method
                $this->Import_VAP_model->insert_batch($insertData);
                echo "success";
            } else {
                echo "no_data";
            }

        } catch (Exception $e) {
            echo "Error: " . $e->getMessage();
        }
    }
}
