<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class Import_collegpub_excel extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Import_collegpub_excel_model');
         $this->load->model('Log_model');
        $this->load->helper('log'); // Load log helper
           if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
    }

    // Load Import View
    public function create()
    {
        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);
        $this->load->view('admin/header_view');
        $this->load->view('admin/Import_collegpub_excel_view',$data);
        $this->load->view('admin/footer_view');
    }

    
public function import_excel_save() {
    try {
         $fk_submenuId = $this->input->post('fk_submenuId');
        // ✅ Handle Excel file upload
        if (!empty($_FILES['excel_file']['name'])) {
            $originalName = $_FILES['excel_file']['name'];
            $tempPath = $_FILES['excel_file']['tmp_name'];

            // Save path -> "C:\xampp\htdocs\NAAC\uploads\excel"
            $uploadDir = FCPATH . 'uploads/excel/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }

            $filename = 'collegepub_excel_' . date('Ymd_His') . '_' . basename($originalName);
            $targetFile = $uploadDir . $filename;

            if (!move_uploaded_file($tempPath, $targetFile)) {
                echo "file_error";
                return;
            }
        }

        // ✅ Process table data
        $postData = $this->input->post('tableData');
        if (empty($postData)) {
            echo "no_data";
            return;
        }

        $rows = json_decode($postData, true);
        $insertData = [];

        $institute = $this->db->select('Institu_id')
            ->from('institute_master')
            ->get()
            ->row();
        $Institute = $institute ? $institute->Institu_id : null;

        // ✅ Load master maps
        $branchMap = [];
        $pubtypeMap = [];
        $semesterMap = [];
        $yearMap = [];

        foreach ($this->db->get_where('branch_master', ['is_on' => 1, 'is_active' => 1])->result() as $r) {
            $branchMap[strtolower(trim($r->branch_name))] = $r->branch_id;
        }
        foreach ($this->db->get_where('semester_master', ['is_on' => 1, 'is_active' => 1])->result() as $d) {
            $semesterMap[strtolower(trim($d->Sem_Name))] = $d->SemID;
        }
        foreach ($this->db->get_where('college_publishtype', ['is_on' => 1, 'is_active' => 1])->result() as $p) {
            $pubtypeMap[strtolower(trim($p->college_publishName))] = $p->c_id;
        }
        foreach ($this->db->get_where('finiyear_master', ['is_active' => 1])->result() as $g) {
            $yearMap[strtolower(trim($g->fini_Label))] = $g->finiYear_id;
        }

        $rowCount = 0;
        foreach ($rows as $row) {
            $rowCount++;
            if ($rowCount === 1) continue; // skip header

            // ✅ Skip blank row
            if (
                empty(trim($row['fk_pubtype'])) &&
                // empty(trim($row['date'])) &&
                empty(trim($row['fk_branch'])) &&
                empty(trim($row['fk_semester'])) &&
                empty(trim($row['description'])) &&
                empty(trim($row['Name_of']))
            ) {
                continue;
            }

            // ✅ Skip "participation within institute"
            if (!empty($row['fk_eventtype']) && trim(strtolower($row['fk_eventtype'])) === 'participation within institute') {
                continue;
            }

            // ✅ Branch
            $branchStr = strtolower(trim($row['fk_branch'] ?? ''));
            if ($branchStr !== '') {
                if (!isset($branchMap[$branchStr])) {
                    $this->db->insert('branch_master', [
                        'branch_name' => ucfirst($branchStr),
                        'is_on' => 1,
                        'is_active' => 1
                    ]);
                    $branch_id = $this->db->insert_id();
                    $branchMap[$branchStr] = $branch_id;
                } else {
                    $branch_id = $branchMap[$branchStr];
                }
            } else {
                $branch_id = null;
            }

            // ✅ PubType
            $pubtypeStr = strtolower(trim($row['fk_pubtype'] ?? ''));
            if ($pubtypeStr !== '') {
                if (!isset($pubtypeMap[$pubtypeStr])) {
                    $this->db->insert('college_publishtype', [
                        'college_publishName' => ucfirst($pubtypeStr),
                        'is_on' => 1,
                        'is_active' => 1
                    ]);
                    $c_id = $this->db->insert_id();
                    $pubtypeMap[$pubtypeStr] = $c_id;
                } else {
                    $c_id = $pubtypeMap[$pubtypeStr];
                }
            } else {
                $c_id = null;
            }

            // ✅ Semester
            $semesterStr = strtolower(trim($row['fk_semester'] ?? ''));
            if ($semesterStr !== '') {
                if (!isset($semesterMap[$semesterStr])) {
                    $this->db->insert('semester_master', [
                        'Sem_Name' => ucfirst($semesterStr),
                        'is_on' => 1,
                        'is_active' => 1
                    ]);
                    $SemID = $this->db->insert_id();
                    $semesterMap[$semesterStr] = $SemID;
                } else {
                    $SemID = $semesterMap[$semesterStr];
                }
            } else {
                $SemID = null;
            }

            // ✅ Year Master
            $yearStr = strtolower(trim($row['Financial_Year'] ?? ''));
            if ($yearStr !== '') {
                if (!isset($yearMap[$yearStr])) {
                    $this->db->insert('finiyear_master', [
                        'fini_Label' => ucfirst($yearStr),
                        'is_active' => 1
                    ]);
                    $finiYear_id = $this->db->insert_id();
                    $yearMap[$yearStr] = $finiYear_id;
                } else {
                    $finiYear_id = $yearMap[$yearStr];
                }
            } else {
                $finiYear_id = null;
            }

            // ✅ Date conversion
            // $date = null;
            // if (!empty($row['date'])) {
            //     $dateValue = $row['date'];
            //     if (is_numeric($dateValue)) {
            //         $unix_date = ($dateValue - 25569) * 86400;
            //         $date = gmdate("Y-m-d", $unix_date);
            //     } else {
            //         $date = date('Y-m-d', strtotime(str_replace('/', '-', $dateValue)));
            //     }
            // }

            // ✅ Insert row
            $insertData[] = [
                'fk_pubtype'   => $c_id,
                // 'date'         => $date,
                'fk_branch'    => $branch_id,
                'fk_semester'  => $SemID,
                'description'  => $row['description'] ?? '',
                'Name_of'         => $row['Name_of'] ?? '',
                'Financial_Year' => $finiYear_id,
                'Institute'    => $Institute,
                'created_date' => date('Y-m-d H:i:s'),
                'is_on'        => 1,
                'is_active'    => 1,
                'created_by'=>$_SESSION['userID']
            ];
        }

        if (!empty($insertData)) {
            $this->db->insert_batch('college_publication', $insertData);
            echo "success";
        } else {
            echo "no_data";
        }
        
         // Insert log - Action 4 (Excel)

        $action = 4;
        $record_id = null;
        $excel_name = $filename;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name,$Fk_branch,$_SESSION['userID']);

        
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
}


}
