<?php
defined('BASEPATH') OR exit('No direct script access allowed');
 require_once(APPPATH . '../vendor/autoload.php'); // Load Composer packages
 
use PhpOffice\PhpSpreadsheet\IOFactory;
 
// use PhpOffice\PhpSpreadsheet\IOFactory;
 
class Import_earn extends CI_Controller {
 
    // public function __construct()
    // {
    //     parent::__construct();
    //     $this->load->model('Import_tech_model');
    // }
 
    // Load Import View
    public function create()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/Import_earn_view');
        $this->load->view('admin/footer_view');
    }
 
    // Import Excel Logic
    public function import_excel()
    {
        try {
            if (!empty($_FILES['excel_file']['name'])) {
                $file = $_FILES['excel_file']['tmp_name'];
 
                // Load Excel
                $spreadsheet = IOFactory::load($file);
                $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);
 
                // Debug log
                log_message('debug', 'Excel Header Row: ' . print_r($sheetData[1], true));
 
                // Master Maps
                $genderMap = [];
                $districtMap = [];
                $talukaMap = [];
 
                // Load Gender Master
                $genders = $this->db->get_where('gender_master', ['is_on' => 1, 'is_active' => 1])->result();
                foreach ($genders as $g) {
                    $genderMap[strtolower(trim($g->gender_name))] = $g->gender_id;
                }
 
                // Load District Master
                $districts = $this->db->get_where('district_master', ['is_on' => 1, 'is_active' => 1])->result();
                foreach ($districts as $d) {
                    $districtMap[strtolower(trim($d->district_name))] = $d->district_id;
                }
 
                // Load Taluka Master
                $talukas = $this->db->get_where('taluka_master', ['is_on' => 1, 'is_active' => 1])->result();
                foreach ($talukas as $t) {
                    $talukaMap[strtolower(trim($t->taulkaName))] = $t->taluka_id;
                }
 
                $insertData = [];
 
                foreach ($sheetData as $key => $row) {
                    if ($key == 1) continue; // Skip header
 
                    // Clean and extract
                    $appliID     = trim($row['B'] ?? '');
                    $fullName    = trim($row['C'] ?? '');
                    $fatherName  = !empty(trim($row['D'] ?? '')) ? trim($row['D']) : null;
                    $motherName  = !empty(trim($row['E'] ?? '')) ? trim($row['E']) : null;
                    $genderStr   = strtolower(trim($row['F'] ?? ''));
                    $districtStr = strtolower(trim($row['P'] ?? ''));
                    $talukaStr   = strtolower(trim($row['Q'] ?? ''));
 
                    // Skip if any required field is missing
                    if (empty($appliID) || empty($fullName) || empty($genderStr) || empty($districtStr) || empty($talukaStr)) {
                        continue;
                    }
 
                    // Check if AppliID already exists
                    $exists = $this->db->get_where('student_reg', ['AppliID' => $appliID])->row();
                    if ($exists) continue;
 
                    // Gender
                    if (!isset($genderMap[$genderStr])) {
                        $this->db->insert('gender_master', [
                            'gender_name' => ucfirst($genderStr),
                            'is_on' => 1,
                            'is_active' => 1
                        ]);
                        $genderId = $this->db->insert_id();
                        $genderMap[$genderStr] = $genderId;
                    } else {
                        $genderId = $genderMap[$genderStr];
                    }
 
                    // District
                    if (!isset($districtMap[$districtStr])) {
                        $this->db->insert('district_master', [
                            'district_name' => ucfirst($districtStr),
                            'is_on' => 1,
                            'is_active' => 1
                        ]);
                        $districtId = $this->db->insert_id();
                        $districtMap[$districtStr] = $districtId;
                    } else {
                        $districtId = $districtMap[$districtStr];
                    }
 
                    // Taluka
                    if (!isset($talukaMap[$talukaStr])) {
                        $this->db->insert('taluka_master', [
                            'taulkaName' => ucfirst($talukaStr),
                            'is_on' => 1,
                            'is_active' => 1
                        ]);
                        $talukaId = $this->db->insert_id();
                        $talukaMap[$talukaStr] = $talukaId;
                    } else {
                        $talukaId = $talukaMap[$talukaStr];
                    }
 
                    // Prepare row
                    $insertData[] = [
                        'AppliID'        => $appliID,
                        'FullName'       => $fullName,
                        'FatherName'     => $fatherName,
                        'MotherName'     => $motherName,
                        'fkGender_id'    => $genderId,
                        'fkDistrict_id'  => $districtId,
                        'fkTaluka_id'    => $talukaId
                    ];
                }
 
                // Insert into DB
                if (!empty($insertData)) {
                    $this->Import_model->insert_batch($insertData);
                    echo "success";
                } else {
                    echo "no_data";
                }
 
            } else {
                echo "no_file";
            }
 
        } catch (Exception $e) {
            echo "Error: " . $e->getMessage();
        }
    }
}
 