<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class Import_placeExcel extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Import_placeExcel_model');
         $this->load->model('Log_model');
        $this->load->helper('log'); // Load log helper
    }

    // Load Import View
    public function create()
    {
         // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Import_placeExcel_view',$data);
        $this->load->view('admin/footer_view');
    }

    

public function import_excel_save() {
    try {
        $fk_submenuId = $this->input->post('fk_submenuId');
        
        // ================== File Upload ==================
        $uploadedFileName = null;
        if (!empty($_FILES['excel_file']['name'])) {
            $uploadPath = FCPATH . "uploads/excel/";
            if (!is_dir($uploadPath)) mkdir($uploadPath, 0777, true);

            $config['upload_path']   = $uploadPath;
            $config['allowed_types'] = 'xls|xlsx|csv';
            $config['max_size']      = 2048;

            // Clean filename
            $originalName = pathinfo($_FILES['excel_file']['name'], PATHINFO_FILENAME);
            $extension    = pathinfo($_FILES['excel_file']['name'], PATHINFO_EXTENSION);
            $cleanName    = preg_replace('/[^A-Za-z0-9_\-]/', '_', $originalName);

            $config['file_name'] = 'Placement_' . date('Ymd_His') . '_' . $cleanName . '.' . $extension;

            $this->load->library('upload', $config);

            if (!$this->upload->do_upload('excel_file')) {
                echo "upload_error: " . $this->upload->display_errors();
                return;
            } else {
                $uploadData = $this->upload->data();
                $uploadedFileName = $uploadData['file_name'];
            }
        }

        // ================== Table Data ==================
        $postData = $this->input->post('tableData');
        if (empty($postData)) {
            echo "no_data";
            return;
        }

        $rows = json_decode($postData, true);
        $insertData = [];

        // ================== Institute ==================
        $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
        $Institute = $institute ? $institute->Institu_id : null;

        // ================== Load Master Maps ==================
        $branchMap = [];
        $companyMap = [];
        $divisionMap = [];
        $studentMap = [];
        $desigMap = [];
        $placeMap = [];
        $classMap = [];
        $yearMap = [];

        foreach ($this->db->get_where('branch_master', ['is_on'=>1,'is_active'=>1])->result() as $r) {
            $branchMap[strtolower(trim($r->branch_name))] = $r->branch_id;
        }
        foreach ($this->db->get_where('company_master', ['is_on'=>1,'is_active'=>1])->result() as $g) {
            $companyMap[strtolower(trim($g->comp_name))] = $g->ID;
        }
        foreach ($this->db->get_where('division_master', ['is_on'=>1,'is_active'=>1])->result() as $d) {
            $divisionMap[strtolower(trim($d->div_name))] = $d->div_id;
        }
        foreach ($this->db->get_where('student_reg', ['is_on'=>1,'is_active'=>1])->result() as $s) {
            $studentMap[strtolower(trim($s->FullName))] = $s->Student_id;
        }
        foreach ($this->db->get_where('designation_master', ['is_on'=>1,'is_active'=>1])->result() as $s) {
            $desigMap[strtolower(trim($s->desig_name))] = $s->desig_id;
        }
        foreach ($this->db->get_where('placement_type', ['is_on'=>1,'is_active'=>1])->result() as $t) {
            $placeMap[strtolower(trim($t->name))] = $t->id;
        }
        foreach ($this->db->get_where('classmaster', ['is_on'=>1,'is_active'=>1])->result() as $s) {
            $classMap[strtolower(trim($s->classname))] = $s->class_id;
        }
        foreach ($this->db->get_where('finiyear_master', ['is_active'=>1])->result() as $g) {
            $yearMap[strtolower(trim($g->fini_Label))] = $g->finiYear_id;
        }

        // ================== Process Rows ==================
        $rowCount = 0;
        foreach ($rows as $row) {
            $rowCount++;
            if ($rowCount === 1) continue; // skip header

            // Skip blank row
            if (empty(array_filter($row))) continue;

            // ====== Branch ======
            $branchStr = strtolower(trim($row['fk_branch'] ?? ''));
            $branch_id = !empty($branchStr)
                ? ($branchMap[$branchStr] ?? $this->create_master('branch_master', 'branch_id', 'branch_name', $branchStr, $branchMap))
                : null;

            // ====== Company ======
            $companyStr = strtolower(trim($row['fk_company'] ?? ''));
            $ID = !empty($companyStr)
                ? ($companyMap[$companyStr] ?? $this->create_master('company_master', 'ID', 'comp_name', $companyStr, $companyMap))
                : null;

            // ====== Division ======
            $divisionStr = strtolower(trim($row['fk_div'] ?? ''));
            $div_id = !empty($divisionStr)
                ? ($divisionMap[$divisionStr] ?? $this->create_master('division_master', 'div_id', 'div_name', $divisionStr, $divisionMap))
                : null;

            // ====== Student ======
            $studentStr = strtolower(trim($row['fk_student'] ?? ''));
            $Student_id = !empty($studentStr)
                ? ($studentMap[$studentStr] ?? $this->create_master('student_reg', 'Student_id', 'FullName', $studentStr, $studentMap))
                : null;

            // ====== Designation ======
            $desigStr = strtolower(trim($row['fk_desig'] ?? ''));
            $desig_id = !empty($desigStr)
                ? ($desigMap[$desigStr] ?? $this->create_master('designation_master', 'desig_id', 'desig_name', $desigStr, $desigMap))
                : null;

            // ====== Placement Type ======
            $placeStr = strtolower(trim($row['fk_place'] ?? ''));
            $place_id = !empty($placeStr)
                ? ($placeMap[$placeStr] ?? $this->create_master('placement_type', 'id', 'name', $placeStr, $placeMap))
                : null;

            // ====== Class ======
            $classStr = strtolower(trim($row['fk_class'] ?? ''));
            $class_id = !empty($classStr)
                ? ($classMap[$classStr] ?? $this->create_master('classmaster', 'class_id', 'classname', $classStr, $classMap))
                : null;

            // ====== Year ======
            $yearStr = strtolower(trim($row['Financial_Year'] ?? ''));
            $finiYear_id = !empty($yearStr)
                ? ($yearMap[$yearStr] ?? $this->create_master('finiyear_master', 'finiYear_id', 'fini_Label', $yearStr, $yearMap))
                : null;

            // ====== Dates ======
            $joining_date   = $this->convert_excel_date($row['joining_date'] ?? null);
            $selected_date  = $this->convert_excel_date($row['selected_date'] ?? null);

            // ====== Prepare insert ======
            $insertData[] = [
                'fk_branch'      => $branch_id,
                'fk_student'     => $Student_id,
                'fk_div'         => $div_id,
                'fk_place'       => $place_id,
                'roll_no'        => $row['roll_no'] ?? '',
                'contact'        => $row['contact'] ?? '',
                'email'          => $row['email'] ?? '',
                'fk_company'     => $ID,
                'fk_desig'       => $desig_id,
                'joining_date'   => $joining_date,
                'salary_package' => $row['salary_package'] ?? '',
                'fk_class'       => $class_id,
                'prn_no'         => $row['prn_no'] ?? '',
                'selected_date'  => $selected_date,
                'Financial_Year' => $finiYear_id,
                'Institute'      => $Institute,
                'created_date'   => date('Y-m-d H:i:s'),
                'is_on'          => 1,
                'is_active'      => 1,
                'created_by'=>$_SESSION['userID']
            ];
        }

        if (!empty($insertData)) {
            $this->db->insert_batch('placement_master', $insertData);
            echo "success";
        } else {
            echo "no_data";
        }
        
         // Insert log - Action 4 (Excel)

        $action = 4;
        $record_id = null;
        $excel_name = $uploadedFileName;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name,$Fk_branch,$_SESSION['userID']);

    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
}

// ================== Helper: Create Master ==================
private function create_master($table, $pk, $col, $value, &$map) {
    $this->db->insert($table, [
        $col => ucfirst($value),
        'is_on' => 1,
        'is_active' => 1
    ]);
    $id = $this->db->insert_id();
    $map[strtolower(trim($value))] = $id;
    return $id;
}

// ================== Helper: Convert Excel Dates ==================
private function convert_excel_date($dateValue) {
    if (empty($dateValue)) return null;
    if (is_numeric($dateValue)) {
        $unix_date = ($dateValue - 25569) * 86400;
        return gmdate("Y-m-d", $unix_date);
    }
    return date('Y-m-d', strtotime(str_replace('/', '-', $dateValue)));
}

}
