<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class Import_studpub_Excel extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Import_studpub_Excel_model');
    }

    // Load Import View
    public function create()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/Import_studpub_Excel_view');
        $this->load->view('admin/footer_view');
    }

    // Load Import View
    public function Report()
    {

        $data['Branch'] = $this->Import_studpub_Excel_model->getDistinctDepartments();

        $data['institutedata'] = $this->Import_studpub_Excel_model->get_all_institute();
//  $data['Branch'] = $this->Import_studpub_Excel_model->get_all_Branch();
      
$data['yeardata'] = $this->Import_studpub_Excel_model->getyear();
 $activeYear = $this->db
    ->select('finiYear_id')
    ->from('finiyear_master')
    ->where('Active_Deactive', 1)
    ->get()
    ->row();
 
$data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;

        $this->load->view('common/header_view');
        $this->load->view('NSS/NSS_Report',$data);
        $this->load->view('common/footer_view');
    }


        public function index()
    {

        $data['alldata']=$this->Import_studpub_Excel_model->getdetailview();

        $this->load->view('common/header_view');
        $this->load->view('NSS/NSS_Detailview',$data);
        $this->load->view('common/footer_view');
    }

// public function import_excel()
// {
//     try {
//         if (!empty($_FILES['excel_file']['name'])) {

//             $originalName = $_FILES['excel_file']['name'];
//             $tempPath     = $_FILES['excel_file']['tmp_name'];

//             $uploadPath = 'uploads/excel/';
//             if (!is_dir($uploadPath)) {
//                 mkdir($uploadPath, 0777, true);
//             }

//             $filename       = date('YmdHis') . '_' . $originalName;
//             $targetFilePath = $uploadPath . $filename;

//             if (!move_uploaded_file($tempPath, $targetFilePath)) {
//                 echo "file_upload_error";
//                 return;
//             }

//             // Load Excel
//             $spreadsheet = IOFactory::load($targetFilePath);
//             $sheetData   = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

//             if (empty($sheetData) || count($sheetData) < 4) {
//                 echo "no_data";
//                 return;
//             }

//             // Assume row 4 = headers
//             $headers   = $sheetData[4];
//             // Normalize header keys & handle duplicates
// $headerMap = [];
// $seenKeys  = [];

// foreach ($headers as $col => $headerName) {
//     $key = strtolower(trim(preg_replace('/\s+/', ' ', $headerName)));

//     if (isset($seenKeys[$key])) {
//         $seenKeys[$key]++;
//         $key = $key . '_' . $seenKeys[$key];   // activity_2, activity_3...
//     } else {
//         $seenKeys[$key] = 1;
//     }

//     $headerMap[$key] = $col;
// }

//             // $headerMap = [];

//             // // Normalize header keys
//             // foreach ($headers as $col => $headerName) {
//             //     $key = strtolower(trim(preg_replace('/\s+/', ' ', $headerName)));
//             //     $headerMap[$key] = $col;
//             // }

//             $insertData = [];

//             foreach ($sheetData as $key => $row) {
//                 if ($key <= 4) continue; // Skip title + header rows

//                 // Extract safely with fallbacks
//                 $activity     = trim($row[$headerMap['activity'] ?? $headerMap['activity name'] ?? '' ] ?? '');
//                 $placeOfAct   = trim($row[$headerMap['place of activity'] ?? $headerMap['place'] ?? '' ] ?? '');
//                 $spocName     = trim($row[$headerMap['spoc name'] ?? $headerMap['spoc'] ?? '' ] ?? '');
//                 $department   = trim($row[$headerMap['department'] ?? '' ] ?? '');
//                 $month        = trim($row[$headerMap['month'] ?? '' ] ?? '');
//                 $actDate      = trim($row[$headerMap['date'] ?? '' ] ?? '');
//                 $studPart     = trim($row[$headerMap['student participated'] ?? $headerMap['students participated'] ?? '' ] ?? '');
//                 $submitted    = trim($row[$headerMap['submitted'] ?? '' ] ?? '');
//                 $activityStatus = trim($row[$headerMap['activity_2'] ?? $headerMap['activity status'] ?? '' ] ?? '');

//                 // Skip empty rows
//                 if (empty($activity) && empty($placeOfAct) && empty($spocName)) {
//                     continue;
//                 }

//                 // Format date
//                 if (!empty($actDate)) {
//                     $actDate = date('Y-m-d', strtotime($actDate));
//                 } else {
//                     $actDate = null;
//                 }

//                 $insertData[] = [
//                     'NssActName'      => $activity,
//                     'PlaceOFAct'      => $placeOfAct,
//                     'SPOCName'        => $spocName,
//                     'Department'      => $department,
//                     'Month'           => $month,
//                     'ActDate'         => $actDate,
//                     'StudPart'        => $studPart,
//                     'Report_Flag'     => $submitted,
//                     'Report_pdf'      => null,
//                     'Activity_Status' => $activityStatus
//                 ];
//             }

//             if (!empty($insertData)) {
//                 $this->db->insert_batch('nss_master', $insertData);
//                 echo "success";
//             } else {
//                 echo "no_data";
//             }

//         } else {
//             echo "no_file";
//         }
//     } catch (Exception $e) {
//         echo "Error: " . $e->getMessage();
//     }
// }


public function showDataByInstitute()
{
    $institute_id = $this->input->post('InstituteId');
    $startdate    = $this->input->post('startdate');
    $enddate      = $this->input->post('enddate');
    $departments  = $this->input->post('Department');  // coming from multi-select

    $data = $this->Import_studpub_Excel_model->getDataByInstitute(
        $institute_id,
        $startdate,
        $enddate,
        $departments
    );

    echo json_encode($data);
}


public function getPrintHeadings()
{
    $data = $this->Import_studpub_Excel_model->getPrintHeadings();
    echo json_encode($data);
}

// public function import_excel_save() {
//     try {
//         $postData = $this->input->post('tableData');
//         if (empty($postData)) {
//             echo "no_data";
//             return;
//         }

//         $rows = json_decode($postData, true);
//         $insertData = [];

//         // // ✅ Get Active Financial Year ID
//         // $finiYear = $this->db
//         //     ->select('finiYear_id')
//         //     ->from('finiyear_master')
//         //     ->where('Active_Deactive', 1)
//         //     ->get()
//         //     ->row();
//         // $finiYearId = $finiYear ? $finiYear->finiYear_id : null;

//         // // ✅ Get Institute ID (first record from institute_master)
//         // $institute = $this->db
//         //     ->select('Institu_id')
//         //     ->from('institute_master')
//         //     ->get()
//         //     ->row();
//         // $instituteId = $institute ? $institute->Institu_id : null;

//         $rowCount = 0;
//       foreach ($rows as $row) {
//     $rowCount++;

//     // ✅ Header skip karna (11th row se data start hota hai tumhare case me)
//     if ($rowCount === 11) {
//         continue;
//     }

//     // ✅ Agar puri row empty hai to skip
//     if (
//         empty(trim($row['fk_student'])) &&
//         empty(trim($row['fk_rank'])) &&
//         empty(trim($row['Institute'])) &&
//         empty(trim($row['eventName'])) &&
//         empty(trim($row['fk_leval'])) &&
//         empty(trim($row['startdate'])) &&
//         empty(trim($row['fk_eventtype']))
//     ) {
//         continue;
//     }

//     // ✅ Agar Event type "Participation within Institute" hai to skip
//     if (!empty($row['fk_eventtype']) && trim(strtolower($row['fk_eventtype'])) === 'participation within institute') {
//         continue;
//     }

//     // ✅ Date convert karna
//     $startdate = !empty($row['startdate']) ? date('Y-m-d', strtotime($row['startdate'])) : null;

//     // ✅ Insert data prepare
//     $insertData[] = [
//         'fk_student'   => $row['fk_student'] ?? '',
//         'fk_rank'      => $row['fk_rank'] ?? '',
//         'Institute'    => $row['Institute'] ?? '',
//         'eventName'    => $row['eventName'] ?? '',
//         'fk_leval'     => $row['fk_leval'] ?? '',
//         'startdate'    => $startdate,
//         'fk_eventtype' => $row['fk_eventtype'] ?? '',
//     ];
// }


//         if (!empty($insertData)) {
//             $this->db->insert_batch('tech_event_student', $insertData);
//             echo "success";
//         } else {
//             echo "no_data";
//         }
//     } catch (Exception $e) {
//         echo "Error: " . $e->getMessage();
//     }
// }

public function import_excel_save() {
    try {
        $postData = $this->input->post('tableData');
        if (empty($postData)) {
            echo "no_data";
            return;
        }

        $rows = json_decode($postData, true);
        $insertData = [];
 // ✅ Get Active Financial Year ID
         $finiYear = $this->db
         ->select('finiYear_id')
             ->from('finiyear_master')
             ->where('Active_Deactive', 1)
         ->get()
             ->row();
         $Financial_Year = $finiYear ? $finiYear->finiYear_id : null;


         $institute = $this->db->select('Institu_id')
         ->from('institute_master')
         ->get()
         ->row();
             $Institute = $institute ? $institute->Institu_id : null;
 

        // ✅ Load maps for existing master data
        $facultyMap = [];
        $studentMap = [];
        $branchMap = [];


        foreach ($this->db->get_where('branch_master', ['is_on' => 1, 'is_active' => 1])->result() as $r) {
            $branchMap[strtolower(trim($r->branch_name))] = $r->branch_id;
        }
        foreach ($this->db->get_where('student_reg', ['is_on' => 1, 'is_active' => 1])->result() as $s) {
            $studentMap[strtolower(trim($s->FullName))] = $s->Student_id;
        }
         foreach ($this->db->get_where('faculty_master', ['is_on' => 1, 'is_active' => 1])->result() as $p) {
            $facultyMap[strtolower(trim($p->fac_Fullname))] = $p->fac_id;
        }

        // ✅ Yahan ek hi baar technical_event insert karna hai
//        $this->db->insert('technical_event', [
//     'eventName'      => NULL,
//     'Financial_Year' => $Financial_Year
// ]);
// $tech_id = $this->db->insert_id();


        $rowCount = 0;
        foreach ($rows as $row) {
            $rowCount++;

            // ✅ Header skip
            if ($rowCount === 1) {
                continue;
            }

            // ✅ Blank row skip
            if (
                empty(trim($row['fk_branch'])) &&
                empty(trim($row['applicant_name'])) &&
                empty(trim($row['prn_no'])) &&
                // empty(trim($row['fk_pubtype'])) &&
                empty(trim($row['fk_usertype'])) &&
              empty(trim($row['authour_name'])) &&
                empty(trim($row['book_title'])) &&
                empty(trim($row['ISBN_NO'])) &&
                empty(trim($row['publisher_name'])) &&
                empty(trim($row['pub_date']))

            ) {
                continue;
            }

            // ✅ Participation within Institute skip
            if (!empty($row['fk_eventtype']) && trim(strtolower($row['fk_eventtype'])) === 'participation within institute') {
                continue;
            }

            // ✅ branch Master
            $branchStr = strtolower(trim($row['fk_branch'] ?? ''));
            if ($branchStr !== '') {
                if (!isset($branchMap[$branchStr])) {
                    $this->db->insert('branch_master', [
                        'branch_name' => ucfirst($branchStr),
                        'is_on' => 1,
                        'is_active' => 1
                    ]);
                    $branch_id = $this->db->insert_id();
                    $branchMap[$branchStr] = $branch_id;
                } else {
                    $branch_id = $branchMap[$branchStr];
                }
            } else {
                $branch_id = null;
            }

            // ✅ Faculty Master
            $facStr = strtolower(trim($row['fk_student'] ?? ''));
            if ($facStr !== '') {
                if (!isset($facultyMap[$facStr])) {
                    $this->db->insert('faculty_master', [
                        'fac_Fullname' => ucfirst($facStr),
                        'is_on' => 1,
                        'is_active' => 1
                    ]);
                    $fac_id = $this->db->insert_id();
                    $facultyMap[$facStr] = $fac_id;
                } else {
                    $fac_id = $facultyMap[$facStr];
                }
            } else {
                $fac_id = null;
            }

           

            // ✅ Student Master
            $studentStr = strtolower(trim($row['fk_student'] ?? ''));
            if ($studentStr !== '') {
                if (!isset($studentMap[$studentStr])) {
                    $this->db->insert('student_reg', [
                        'FullName' => ucfirst($studentStr),
                        'is_on' => 1,
                        'is_active' => 1
                    ]);
                    $Student_id = $this->db->insert_id();
                    $studentMap[$studentStr] = $Student_id;
                } else {
                    $Student_id = $studentMap[$studentStr];
                }
            } else {
                $Student_id = null;
            }

            // ✅ Date convert
            $pub_date = null;
            if (!empty($row['pub_date'])) {
                $dateValue = $row['pub_date'];
                if (is_numeric($dateValue)) {
                    $unix_date = ($dateValue - 25569) * 86400; 
                    $pub_date = gmdate("Y-m-d", $unix_date);
                } else {
                    $pub_date = date('Y-m-d', strtotime(str_replace('/', '-', $dateValue)));
                }
            }

            // ✅ Insert row
            $insertData[] = [

                'fk_branch'   => $branch_id,  
                // 'fk_fac'   => $Student_id,
                'prn_no'      => $row['prn_no'] ?? '',
                'applicant_name'    =>  $row['applicant_name'] ?? '',   
                'fk_usertype'    => $row['fk_usertype'] ?? '',
                'authour_name'     => $row['authour_name'] ?? '',       
                'book_title'    => $row['book_title'] ?? '',
                'ISBN_NO' =>$row['ISBN_NO'] ?? '',
                 'publisher_name' => $row['publisher_name'] ?? '',
                'pub_date' => $pub_date,
                'Financial_Year' => $Financial_Year,
                'Institute' => $Institute,
            ];
        }

        if (!empty($insertData)) {
            $this->db->insert_batch('student_publication', $insertData);
            echo "success";
        } else {
            echo "no_data";
        }
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
}

}
