<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class Import_studpub_Excel extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Import_studpub_Excel_model');
        $this->load->model('Log_model');
        $this->load->helper('log');
    }

    // Load Import View
    public function create()
    {
        $data['maindata'] = $this->Import_studpub_Excel_model->getmainuser();
        $data['publidata'] = $this->Import_studpub_Excel_model->getpubli();
        $data['yeardata'] = $this->Import_studpub_Excel_model->getyear();

// ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/Import_studpub_Excel_view',$data);
        $this->load->view('admin/footer_view');
    }


    public function import_excel_save() {
        try {
            $fk_submenuId = $this->input->post('fk_submenuId');
            
            // ✅ Handle Excel file upload
            if (!empty($_FILES['excel_file']['name'])) {
                $originalName = $_FILES['excel_file']['name'];
                $tempPath = $_FILES['excel_file']['tmp_name'];

                $uploadDir = FCPATH . 'uploads/excel/';
                if (!is_dir($uploadDir)) {
                    mkdir($uploadDir, 0777, true);
                }

                $filename = 'studpub_excel_' . date('Ymd_His') . '_' . basename($originalName);
                $targetFile = $uploadDir . $filename;

                if (!move_uploaded_file($tempPath, $targetFile)) {
                    echo "file_error";
                    return;
                }
            }

            // ✅ Process table data
            $postData = $this->input->post('tableData');
            if (empty($postData)) {
                echo "no_data";
                return;
            }

            $rows = json_decode($postData, true);
            $insertData = [];

            // ✅ Get Institute
            $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
            $Institute = $institute ? $institute->Institu_id : null;

            // ✅ Load master maps
            $branchMap = [];

            foreach ($this->db->get_where('branch_master', ['is_on' => 1, 'is_active' => 1])->result() as $r) {
                $branchMap[strtolower(trim($r->branch_name))] = $r->branch_id;
            }

            $rowCount = 0;
            foreach ($rows as $row) {
                $rowCount++;
                if ($rowCount === 1) continue; // skip header

                // ✅ Skip blank rows
                if (empty(array_filter($row))) continue;

                // ✅ Branch Master
                $branchStr = strtolower(trim($row['fk_branch'] ?? ''));
                $branch_id = null;
                if ($branchStr !== '') {
                    if (!isset($branchMap[$branchStr])) {
                        $this->db->insert('branch_master', [
                            'branch_name' => ucfirst($branchStr),
                            'is_on' => 1,
                            'is_active' => 1
                        ]);
                        $branch_id = $this->db->insert_id();
                        $branchMap[$branchStr] = $branch_id;
                    } else {
                        $branch_id = $branchMap[$branchStr];
                    }
                }

                // ✅ Date convert
                $pub_date = null;
                if (!empty($row['pub_date'])) {
                    $dateValue = $row['pub_date'];
                    
                    // Check if it's DD-MM-YYYY format from frontend
                    if (preg_match('/^\d{2}-\d{2}-\d{4}$/', $dateValue)) {
                        $parts = explode('-', $dateValue);
                        $pub_date = $parts[2] . '-' . $parts[1] . '-' . $parts[0]; // Convert to YYYY-MM-DD
                    } 
                    // Check if it's numeric (Excel serial date)
                    else if (is_numeric($dateValue)) {
                        $unix_date = ($dateValue - 25569) * 86400;
                        $pub_date = gmdate("Y-m-d", $unix_date);
                    } 
                    // Other formats
                    else {
                        $pub_date = date('Y-m-d', strtotime(str_replace('/', '-', $dateValue)));
                    }
                }

                // ✅ Prepare insert data - Use dropdown IDs directly
                $insertData[] = [
                    'fk_branch' => $branch_id,
                    'fk_pubtype' => $row['fk_pubtype'] ?? null, // Dropdown selected ID
                    'prn_no' => $row['prn_no'] ?? null,
                    'authour_name' => $row['authour_name'] ?? null,
                    'fk_usertype' => $row['fk_usertype'] ?? null, // Dropdown selected ID
                    'book_title' => $row['book_title'] ?? null,
                    'ISBN_NO' => $row['ISBN_NO'] ?? null,
                    'publisher_name' => $row['publisher_name'] ?? null,
                    'pub_date' => $pub_date,
                    // 'paper_name' => $row['paper_name'] ?? null,
                    'conf_name' => $row['conf_name'] ?? null,
                    'sci_other' => $row['sci_other'] ?? null,
                    'doi_issue' => $row['doi_issue'] ?? null,
                    'date_place' => $row['date_place'] ?? null,
                    'journal_name' => $row['journal_name'] ?? null,
                    'qurter' => $row['qurter'] ?? null,
                    'collaborative' => $row['collaborative'] ?? null,
                    'Financial_Year' => $row['Financial_Year'] ?? null, // Dropdown selected ID
                    'Institute' => $Institute,
                    'created_date' => date('Y-m-d H:i:s'),
                    'is_on' => 1,
                    'is_active' => 1,
                    'created_by'=>$_SESSION['userID']
                ];
            }

            if (!empty($insertData)) {
                $this->db->insert_batch('student_publication', $insertData);
                echo "success";
            } else {
                echo "no_data";
            }
            // Insert log - Action 4 (Excel)
 
        $action = 4;
        $record_id = null;
        $excel_name = $filename;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name,$Fk_branch,$_SESSION['userID']);
            
        } catch (Exception $e) {
            log_message('error', 'Import Error: ' . $e->getMessage());
            echo "Error: " . $e->getMessage();
        }
    }
}