<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class Impot_softExcel extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Impot_softExcel_model');
        $this->load->model('Log_model');
        $this->load->helper('log');
            if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
    }

    // Load Import View
    public function create()
    {
        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);
        $this->load->view('admin/header_view');
        $this->load->view('admin/Impot_softExcel_view',$data);
        $this->load->view('admin/footer_view');
    }

   
public function import_excel_save() {
    try {
        $fk_submenuId = $this->input->post('fk_submenuId');
        // ✅ Handle Excel file upload
        if (!empty($_FILES['excel_file']['name'])) {
            $originalName = $_FILES['excel_file']['name'];
            $tempPath = $_FILES['excel_file']['tmp_name'];

            $uploadDir = FCPATH . 'uploads/excel/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }

            $filename = 'software_excel_' . date('Ymd_His') . '_' . basename($originalName);
            $targetFile = $uploadDir . $filename;

            if (!move_uploaded_file($tempPath, $targetFile)) {
                echo "no_data";
                return;
            }
        }

        $postData = $this->input->post('tableData');
        if (empty($postData)) {
            echo "no_data";
            return;
        }

        $rows = json_decode($postData, true);
        $insertData = [];

        $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
        $Institute = $institute ? $institute->Institu_id : null;

        // ✅ Load maps for branch, duration, year
        $branchMap = [];
        $durationMap = [];
        $yearMap = [];

        foreach ($this->db->get_where('branch_master', ['is_on' => 1, 'is_active' => 1])->result() as $r) {
            $branchMap[strtolower(trim($r->branch_name))] = $r->branch_id;
        }

        foreach ($this->db->get_where('internduration_master', ['is_on' => 1, 'is_active' => 1])->result() as $d) {
            $key = strtolower(trim((string)$d->duration_type));
            if ($key !== '') $durationMap[$key] = $d->duration_id;
        }

        foreach ($this->db->get_where('finiyear_master', ['is_on' => 1, 'is_active' => 1])->result() as $g) {
            $yearMap[strtolower(trim($g->fini_Label))] = $g->finiYear_id;
        }

        $rowCount = 0;
        foreach ($rows as $row) {
            $rowCount++;
            if ($rowCount === 1) continue; // skip header

            // branch
            $branchStr = strtolower(trim($row['fk_branch'] ?? ''));
            $branch_id = $branchStr ? ($branchMap[$branchStr] ?? $this->db->insert('branch_master', ['branch_name'=>ucfirst($branchStr),'is_on'=>1,'is_active'=>1]) && ($branchMap[$branchStr] = $this->db->insert_id())) : null;

            // duration
            $durationStr = strtolower(trim($row['fk_duration'] ?? ''));
            $duration_id = $durationStr ? ($durationMap[$durationStr] ?? $this->db->insert('internduration_master', ['duration_type'=>ucfirst($durationStr),'is_on'=>1,'is_active'=>1]) && ($durationMap[$durationStr] = $this->db->insert_id())) : null;

            // year
            $yearStr = strtolower(trim($row['Financial_Year'] ?? ''));
            $finiYear_id = $yearStr ? ($yearMap[$yearStr] ?? $this->db->insert('finiyear_master', ['fini_Label'=>ucfirst($yearStr),'is_on'=>1,'is_active'=>1]) && ($yearMap[$yearStr] = $this->db->insert_id())) : null;

            // Date convert
            $Insta_date = !empty($row['Insta_date']) ? (is_numeric($row['Insta_date']) ? gmdate("Y-m-d", ($row['Insta_date'] - 25569) * 86400) : date('Y-m-d', strtotime(str_replace('/', '-', $row['Insta_date'])))) : null;
            $renew_date = !empty($row['renew_date']) ? (is_numeric($row['renew_date']) ? gmdate("Y-m-d", ($row['renew_date'] - 25569) * 86400) : date('Y-m-d', strtotime(str_replace('/', '-', $row['renew_date'])))) : null;

            $insertData[] = [
                'fk_branch' => $branch_id,
                'soft_name' => $row['soft_name'] ?? '',
                'Insta_date' => $Insta_date,
                'licence_withlicence' => $row['licence_withlicence'] ?? '',
                'fk_duration' => $duration_id,
                'renew_date' => $renew_date,
                'licence_key' => $row['licence_key'] ?? '',
                'No_user' => $row['No_user'] ?? '',
                'description' => $row['description'] ?? '',
                'price' => $row['price'] ?? '',
                'Financial_Year' => $finiYear_id,
                'Institute' => $Institute,
                'created_date' => date('Y-m-d H:i:s'),
                'is_on' => 1,
                'is_active' => 1,
                'created_by'=>$_SESSION['userID']
            ];
        }

        if (!empty($insertData)) {
            $this->Impot_softExcel_model->insert_batch($insertData);
            echo "success";
        } else echo "no_data";
        
        // Insert log - Action 4 (Excel)
 
        $action = 4;
        $record_id = null;
        $excel_name = $filename;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name,$Fk_branch,$_SESSION['userID']);

    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
}

}
